/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.katalon.platform.api.execution.TestCaseExecutionContext;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.ReportController;
import com.kms.katalon.controller.TestSuiteController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.reporting.ReportUtil;
import com.kms.katalon.core.reporting.ReportWriterUtil;
import com.kms.katalon.core.reporting.pdf.exception.JasperReportException;
import com.kms.katalon.core.reporting.service.IFailureAnalysisService;
import com.kms.katalon.core.setting.ReportSettings;
import com.kms.katalon.core.testdata.reader.CSVReader;
import com.kms.katalon.core.testdata.reader.CSVSeparator;
import com.kms.katalon.core.testdata.reader.CsvWriter;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.global.GlobalVariableEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.report.ReportEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.addon.ExecutionBundleActivator;
import com.kms.katalon.execution.configuration.AbstractRunConfiguration;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.constants.StringConstants;
import com.kms.katalon.execution.core.interfaces.IExecutedEntity;
import com.kms.katalon.execution.entity.EmailConfig;
import com.kms.katalon.execution.entity.ReportLocationSetting;
import com.kms.katalon.execution.entity.Reportable;
import com.kms.katalon.execution.entity.Rerunable;
import com.kms.katalon.execution.entity.TestCaseBindingExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseExecutedEntity;
import com.kms.katalon.execution.entity.TestCaseExecutionContextImpl;
import com.kms.katalon.execution.entity.TestSuiteExecutedEntity;
import com.kms.katalon.execution.entity.TestSuiteExecutionContextImpl;
import com.kms.katalon.execution.entity.TestSuiteExecutionEvent;
import com.kms.katalon.execution.handler.OrganizationHandler;
import com.kms.katalon.execution.integration.ReportIntegrationContribution;
import com.kms.katalon.execution.integration.ReportIntegrationFactory;
import com.kms.katalon.execution.launcher.LoggableLauncher;
import com.kms.katalon.execution.launcher.manager.LauncherManager;
import com.kms.katalon.execution.launcher.result.LauncherStatus;
import com.kms.katalon.execution.setting.EmailVariableBinding;
import com.kms.katalon.execution.setting.ReportSettingStore;
import com.kms.katalon.execution.util.ExecutionProfileStore;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.execution.util.MailUtil;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.testops.core.model.TestOpsErrorResponse;
import com.kms.katalon.util.CryptoUtil;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

public abstract class ReportableLauncher
extends LoggableLauncher {
    private ReportEntity reportEntity;
    private Date startTime;
    private Date endTime;
    private TestSuiteLogRecord suiteLogRecord;
    private TestSuiteCollectionEntity testSuiteCollectionEntity;
    private boolean isTestSuiteCompleted;
    protected ReportSettingStore reportSettingStore;
    private boolean generateConsoleLog;

    public ReportableLauncher(LauncherManager manager, IRunConfiguration runConfig) {
        this(manager, runConfig, null);
    }

    public ReportableLauncher(LauncherManager manager, IRunConfiguration runConfig, TestSuiteCollectionEntity testSuiteCollectionEntity) {
        super(manager, runConfig);
        this.setExecutionUUID(runConfig.getExecutionUUID());
        this.testSuiteCollectionEntity = testSuiteCollectionEntity;
        this.reportSettingStore = ReportSettingStore.getStore();
        try {
            this.generateConsoleLog = this.reportSettingStore.useGenerateConsoleLog();
        }
        catch (IOException e) {
            this.generateConsoleLog = true;
            LogUtil.logError((String)"Failed to get useGenerateConsoleLog");
            LogUtil.logError((Throwable)e);
            LogUtil.logError((String)"Fallback useGenerateConsoleLog to TRUE");
        }
    }

    public TestSuiteCollectionEntity getTestSuiteCollectionEntity() {
        return this.testSuiteCollectionEntity;
    }

    public void setTestSuiteCollectionEntity(TestSuiteCollectionEntity testSuiteCollectionEntity) {
        this.testSuiteCollectionEntity = testSuiteCollectionEntity;
    }

    public abstract ReportableLauncher clone(IRunConfiguration var1);

    private void sendTrackingActivity() {
        ReportIntegrationContribution analyticsProvider = ReportIntegrationFactory.getInstance().getAnalyticsProvider();
        String machineId = this.getMachineId();
        String sessionId = this.getExecutionUUID();
        Date startTime = this.getStartTime();
        Date endTime = this.getEndTime();
        String ksVersion = VersionUtil.getCurrentVersion().getVersion();
        Long organizationId = OrganizationHandler.getOrganizationId();
        ExecutorService executors = Executors.newCachedThreadPool();
        executors.submit(() -> analyticsProvider.sendTrackingActivity(organizationId, machineId, sessionId, startTime, endTime, ksVersion));
    }

    @Override
    protected void onStartExecution() {
        super.onStartExecution();
        this.startTime = new Date();
        if (this.parentLauncher == null && this.getExecutedEntity() instanceof Reportable) {
            this.sendTrackingActivity();
        }
        for (Map.Entry<String, ReportIntegrationContribution> reportContributorEntry : ReportIntegrationFactory.getInstance().getIntegrationContributorMap().entrySet()) {
            ReportIntegrationContribution contribution = reportContributorEntry.getValue();
            contribution.fetchRemoteSettings();
        }
        this.fireTestSuiteExecutionEvent("KATALON_EXECUTION/TEST_SUITE_STARTED");
    }

    @Override
    protected void preExecutionComplete(boolean runTestSuite) {
        TestSuiteEntity testSuite;
        this.endTime = new Date();
        if (this.parentLauncher == null && this.getExecutedEntity() instanceof Reportable) {
            this.sendTrackingActivity();
        }
        if (this.getStatus() == LauncherStatus.TERMINATED) {
            return;
        }
        this.waitForLoggingFinished();
        if (!(this.getExecutedEntity() instanceof Reportable)) {
            return;
        }
        if (this.reachMaxFailedTestThreshold()) {
            this.printMessageReachFailedThreshold();
        }
        try {
            this.setStatus(LauncherStatus.PREPARE_REPORT);
            this.isTestSuiteCompleted = this.isTestSuiteCompleted();
            this.suiteLogRecord = this.prepareReport();
            if (this.suiteLogRecord != null) {
                this.suiteLogRecord.setStatus(this.isTestSuiteCompleted);
                this.uploadReportToIntegratingProduct(this.suiteLogRecord);
                this.sendReport(this.suiteLogRecord, this.getRunConfig().getOverridingGlobalVariables());
            }
        }
        catch (Exception e) {
            this.writeError(MessageFormat.format(StringConstants.LAU_RPT_ERROR_TO_GENERATE_REPORT, e.getMessage()));
            LogUtil.printAndLogError((Throwable)e);
        }
        if (!this.reachMaxFailedTestThreshold() || this.reachMaxFailedTestThreshold() && this.isTestSuiteCompleted) {
            this.fireTestSuiteExecutionEvent("KATALON_EXECUTION/TEST_SUITE_FINISHED");
        }
        if (this.getExecutedEntity() instanceof TestSuiteExecutedEntity) {
            TestSuiteExecutedEntity executedEntity = (TestSuiteExecutedEntity)this.getExecutedEntity();
            testSuite = (TestSuiteEntity)executedEntity.getEntity();
            ExecutionBundleActivator.getInstance().getEventBroker().post("TESTSUITE/FINISHED", (Object)testSuite);
        }
        if (this.needToRerun() && !this.reachMaxFailedTestThreshold()) {
            this.updateThresholdWhenRetryAll();
            Rerunable rerun = (Rerunable)this.getExecutedEntity();
            testSuite = this.getTestSuite();
            String strRetryFailedExecutionsTcBindings = this.getRetryFailedExecutionsOnlyTcBindings();
            HashMap<String, String> customTcBindings = new HashMap<String, String>();
            customTcBindings.put("retryFailedExecutionsOnlyTcBinding", strRetryFailedExecutionsTcBindings);
            try {
                TestSuiteExecutedEntity newTestSuiteExecutedEntity = ExecutionUtil.getRerunExecutedEntity((TestSuiteExecutedEntity)this.getExecutedEntity(), this.getResult());
                this.writeLine("\n");
                this.writeLine(MessageFormat.format(StringConstants.LAU_RPT_RERUN_TEST_SUITE, this.getExecutedEntity().getSourceId(), String.valueOf(rerun.getPreviousRerunTimes() + 1)));
                IRunConfiguration newConfig = this.getRunConfig().cloneConfig();
                if (this.getRunConfig() instanceof AbstractRunConfiguration && newConfig instanceof AbstractRunConfiguration) {
                    ((AbstractRunConfiguration)newConfig).setExecutionProfile((ExecutionProfileEntity)this.getRunConfig().getExecutionProfile());
                    ((AbstractRunConfiguration)newConfig).setOverridingGlobalVariables(this.getRunConfig().getOverridingGlobalVariables());
                    ((AbstractRunConfiguration)newConfig).setTestSuiteAdditionalData(customTcBindings);
                    ((AbstractRunConfiguration)newConfig).setExecutionSessionId(this.getRunConfig().getExecutionSessionId());
                    ((AbstractRunConfiguration)newConfig).setDebugLaunchMode(RunConfiguration.isRunningDebugMode());
                }
                newConfig.build((FileEntity)testSuite, (IExecutedEntity)newTestSuiteExecutedEntity);
                ReportableLauncher rerunLauncher = this.clone(newConfig);
                rerunLauncher.configureToLazilyRebuildRunConfigDriverConnector(this.runConfigContributor, this.projectDir, this.runConfigurationDescription);
                if (this.isRunningInTestSuiteCollection()) {
                    rerunLauncher.setTestSuiteCollectionEntity(this.getTestSuiteCollectionEntity());
                }
                rerunLauncher.getManager().addLauncher(rerunLauncher);
            }
            catch (Exception e) {
                this.writeError(MessageFormat.format(StringConstants.MSG_RP_ERROR_TO_RERUN_TEST_SUITE, ExceptionUtils.getStackTrace((Throwable)e)));
                LogUtil.logError((Throwable)e);
            }
        }
    }

    @Override
    public void setStatus(LauncherStatus status) {
        super.setStatus(status);
        if (LauncherStatus.DONE == status || LauncherStatus.TERMINATED == status) {
            this.fireInternalTestSuiteEvent("EXECUTE/EXECUTE_TEST_SUITE_ENDED");
        }
    }

    private String getRetryFailedExecutionsOnlyTcBindings() {
        File testCaseBindingFile = new File(this.getRunConfig().getExecutionSetting().getFolderPath(), "testCaseBinding");
        try {
            List currentTcBindings = FileUtils.readLines((File)testCaseBindingFile);
            ArrayList<String> currentFailedTcBindings = new ArrayList<String>();
            List<IExecutedEntity> prevTestCaseExecutedEntities = ((TestSuiteExecutedEntity)this.getExecutedEntity()).getExecutedItems();
            TestStatus.TestStatusValue[] prevResultValues = this.getResult().getResultValues();
            int rsIdx = 0;
            for (IExecutedEntity prevExecutedItem : prevTestCaseExecutedEntities) {
                TestCaseExecutedEntity prevExecutedTC = null;
                if (prevExecutedItem instanceof TestCaseExecutedEntity) {
                    prevExecutedTC = (TestCaseExecutedEntity)prevExecutedItem;
                }
                if (prevExecutedItem instanceof TestCaseBindingExecutedEntity) {
                    TestCaseBindingExecutedEntity prevExecutedBindingTC = (TestCaseBindingExecutedEntity)prevExecutedItem;
                    prevExecutedTC = (TestCaseExecutedEntity)prevExecutedBindingTC.getExecutedItems().get(0);
                }
                int i = rsIdx;
                while (i < rsIdx + prevExecutedTC.getLoopTimes()) {
                    if (prevResultValues[i] == TestStatus.TestStatusValue.FAILED || prevResultValues[i] == TestStatus.TestStatusValue.ERROR) {
                        currentFailedTcBindings.add((String)currentTcBindings.get(i));
                    }
                    ++i;
                }
                rsIdx += prevExecutedTC.getLoopTimes();
            }
            return String.join((CharSequence)"\n", currentFailedTcBindings);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public boolean needToRerun() {
        Rerunable rerun = (Rerunable)this.getExecutedEntity();
        if (rerun.isRerunImmediately()) {
            return false;
        }
        if (this.getResult().getNumErrors() + this.getResult().getNumFailures() > 0 && this.getExecutedEntity() instanceof Rerunable) {
            return rerun.getRemainingRerunTimes() > 0;
        }
        return false;
    }

    public boolean isTestSuiteCompleted() throws Exception {
        return this.getExecutedEntity() instanceof TestSuiteExecutedEntity && this.getResult().getTotalTestCases() == this.getResult().getExecutedTestCases();
    }

    public boolean reachMaxFailedTestThreshold() {
        if (this.getExecutedEntity() instanceof TestSuiteExecutedEntity) {
            TestSuiteExecutedEntity entity = (TestSuiteExecutedEntity)this.getExecutedEntity();
            int threshold = entity.getFailedThreshold();
            int numOfErrorAndFailure = this.getResult().getNumErrors() + this.getResult().getNumFailures() + this.getResult().getNumRetryErrorsAndFailures();
            if (threshold <= 0) {
                return false;
            }
            if (numOfErrorAndFailure >= threshold) {
                return true;
            }
        }
        return false;
    }

    private void waitForLoggingFinished() {
        try {
            long startTime = System.currentTimeMillis();
            while (!this.loggingFinished && System.currentTimeMillis() - startTime < TimeUnit.MINUTES.toMillis(1L)) {
                Thread.sleep(200L);
            }
        }
        catch (Exception exception) {}
    }

    private void sendReport(TestSuiteLogRecord testSuiteLogRecord, Map<String, Object> overridingParameters) {
        try {
            this.sendReportEmail(testSuiteLogRecord, overridingParameters);
            this.setAreEmailsSent(true);
        }
        catch (Exception e) {
            this.writeError(MessageFormat.format(StringConstants.MSG_RP_ERROR_TO_EMAIL_REPORT, ExceptionUtils.getStackTrace((Throwable)e)));
            this.setAreEmailsSent(false);
            LogUtil.logError((Throwable)e);
        }
    }

    private void sendReportEmail(TestSuiteLogRecord testSuiteLogRecord, Map<String, Object> overridingParameters) throws Exception {
        if (!(this.getExecutedEntity() instanceof TestSuiteExecutedEntity)) {
            return;
        }
        EmailConfig emailConfig = ((TestSuiteExecutedEntity)this.getExecutedEntity()).getEmailConfig(ProjectController.getInstance().getCurrentProject());
        if (emailConfig == null || !emailConfig.canSend()) {
            return;
        }
        FileEntity fileEntity = ((TestSuiteExecutedEntity)this.getExecutedEntity()).getEntity();
        if (fileEntity instanceof TestSuiteEntity) {
            TestSuiteEntity ts = (TestSuiteEntity)fileEntity;
            emailConfig.addRecipients(ts.getMailRecipient());
        }
        if (this.isRunningInTestSuiteCollection() && emailConfig.isSendTestSuiteCollectionReportEnabled() && emailConfig.isSkipInvidiualTestSuiteReport()) {
            return;
        }
        if (!emailConfig.isSendTestSuiteReportEnabled()) {
            return;
        }
        if (emailConfig.isSendReportTestFailedOnly() && testSuiteLogRecord.getStatus() != null && testSuiteLogRecord.getTotalFailedTestCases() <= 0) {
            return;
        }
        this.setStatus(LauncherStatus.SENDING_REPORT, StringConstants.LAU_MESSAGE_SENDING_EMAIL);
        this.writeLine(MessageFormat.format(StringConstants.LAU_PRT_SENDING_EMAIL_RPT_TO, Arrays.toString(emailConfig.getTos())));
        ExecutionProfileEntity executionProfile = null;
        executionProfile = testSuiteLogRecord.getTestSuiteCollectionId() == null || testSuiteLogRecord.getTestSuiteCollectionId().isEmpty() ? ExecutionProfileStore.getInstance().getSelectedProfile() : (ExecutionProfileEntity)this.runConfig.getExecutionProfile();
        Map<String, Object> variables = EmailVariableBinding.getVariablesForTestSuiteEmail(testSuiteLogRecord, (ExecutionProfileEntity)this.getRunConfig().getExecutionProfile(), emailConfig, this.getFailureAnalysisService());
        variables.putAll(overridingParameters);
        MailUtil.sendSummaryMailForTestSuite(emailConfig, testSuiteLogRecord, variables, executionProfile);
        this.writeLine(StringConstants.LAU_PRT_EMAIL_SENT);
    }

    private IFailureAnalysisService getFailureAnalysisService() {
        try {
            BundleContext bundleContext = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
            if (bundleContext != null) {
                IEclipseContext eclipseContext = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
                return (IFailureAnalysisService)eclipseContext.get(IFailureAnalysisService.class);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private boolean isRunningInTestSuiteCollection() {
        return this.testSuiteCollectionEntity != null;
    }

    protected void updateLastRun(Date startTime) throws Exception {
    }

    protected TestSuiteLogRecord prepareReport() {
        try {
            File reportFolder = this.getReportFolder();
            if (this.isRunningInTestSuiteCollection()) {
                ReportWriterUtil.writeTestSuiteCollectionIdToFile((String)this.testSuiteCollectionEntity.getIdForDisplay(), (File)reportFolder);
            }
            this.setStatus(LauncherStatus.PREPARE_REPORT, ExecutionMessageConstants.MSG_PREPARE_GENERATE_REPORT);
            TestSuiteLogRecord suiteLog = ReportWriterUtil.parseCollectionSuiteLog((String)this.getRunConfig().getExecutionSetting().getFolderPath());
            if (suiteLog != null) {
                this.setStatus(LauncherStatus.PREPARE_REPORT, ExecutionMessageConstants.MSG_PREPARE_REPORT_UUID);
                try {
                    LogUtil.logInfo((String)("Start writing execution.uuid file to folder: " + reportFolder.getAbsolutePath()));
                    ReportUtil.writeExecutionUUIDToFile((String)this.getExecutionUUID(), (File)reportFolder);
                }
                catch (IOException | URISyntaxException exception) {
                    LogUtil.logError((String)"Failed to write execution uuid");
                }
                this.setStatus(LauncherStatus.PREPARE_REPORT, ExecutionMessageConstants.MSG_PREPARE_REPORT_JUNIT);
                try {
                    LogUtil.logInfo((String)("Start generating JUnit report folder at: " + reportFolder.getAbsolutePath() + "..."));
                    ReportUtil.writeJUnitReport((TestSuiteLogRecord)suiteLog, (File)reportFolder);
                    LogUtil.logInfo((String)"JUnit report were generated");
                }
                catch (IOException | JAXBException e) {
                    LogUtil.logError((String)("Failed to generate JUnit report, error: " + e.getMessage()));
                }
                boolean genereteHTML = true;
                try {
                    genereteHTML = this.reportSettingStore.useGenerateHTML();
                }
                catch (IOException iOException) {}
                if (genereteHTML) {
                    this.setStatus(LauncherStatus.PREPARE_REPORT, ExecutionMessageConstants.MSG_PREPARE_REPORT_HTML);
                    try {
                        ReportSettings settings = this.reportSettingStore.getSettings();
                        LogUtil.logInfo((String)("Start generating HTML report at folder: " + String.valueOf(reportFolder) + "..."));
                        if (this.getRunConfig() != null) {
                            ExecutionProfileEntity executionProfile = (ExecutionProfileEntity)this.getRunConfig().getExecutionProfile();
                            suiteLog.setExecutionProfile(executionProfile != null ? executionProfile.getName() : "default");
                        }
                        ReportWriterUtil.writeHTMLReport((ReportWriterUtil.SuiteReportGenerationOptions)((ReportWriterUtil.SuiteReportGenerationOptionsBuilder)((ReportWriterUtil.SuiteReportGenerationOptionsBuilder)ReportWriterUtil.SuiteReportGenerationOptionsBuilder.create().suiteLogRecord(suiteLog).settings(settings)).reportDir(reportFolder)).build());
                        this.addReportGenerationType("HTML");
                        LogUtil.logInfo((String)"HTML report generated");
                    }
                    catch (IOException | URISyntaxException e) {
                        LogUtil.logError((String)("Failed to generate HTML report, error: " + e.getMessage()));
                    }
                }
                boolean genereteCSV = true;
                try {
                    genereteCSV = this.reportSettingStore.useGenerateCSV();
                }
                catch (IOException iOException) {}
                if (genereteCSV) {
                    this.setStatus(LauncherStatus.PREPARE_REPORT, ExecutionMessageConstants.MSG_PREPARE_REPORT_CSV);
                    try {
                        LogUtil.logInfo((String)("Start generating CSV report folder at: " + String.valueOf(reportFolder) + "..."));
                        ReportWriterUtil.writeCSVReport((TestSuiteLogRecord)suiteLog, (File)new File(reportFolder.getAbsolutePath()));
                        this.addReportGenerationType("CSV");
                        LogUtil.logInfo((String)"CSV report generated");
                    }
                    catch (IOException e) {
                        LogUtil.logError((String)("Failed to generate CSV report, error: " + e.getMessage()));
                    }
                }
                boolean generetePDF = false;
                try {
                    generetePDF = this.reportSettingStore.useGeneratePDF();
                }
                catch (IOException iOException) {}
                if (generetePDF) {
                    this.setStatus(LauncherStatus.PREPARE_REPORT, ExecutionMessageConstants.MSG_PREPARE_REPORT_PDF);
                    try {
                        LogUtil.logInfo((String)("Start generating PDF report folder at: " + String.valueOf(reportFolder) + "..."));
                        ReportWriterUtil.writePdfReport((TestSuiteLogRecord)suiteLog, (File)new File(reportFolder.getAbsolutePath()));
                        this.addReportGenerationType("PDF");
                        LogUtil.logInfo((String)"PDF report generated");
                    }
                    catch (JasperReportException | IOException e) {
                        LogUtil.logError((String)("Failed to generate PDF report, error: " + e.getMessage()));
                    }
                }
                if (this.generateConsoleLog) {
                    this.setStatus(LauncherStatus.PREPARE_REPORT, ExecutionMessageConstants.MSG_PREPARE_REPORT_CONSOLE_LOG);
                    this.addReportGenerationType("console log");
                }
                this.prepareIntegrationReport(suiteLog);
                this.copyReport();
            }
            return suiteLog;
        }
        catch (Exception e) {
            LogUtil.printAndLogError((Throwable)e);
            return null;
        }
    }

    private boolean isContributorEligibleForGeneratingReport(ReportIntegrationContribution contribution, String contributorName) {
        if (contribution == null) {
            return false;
        }
        if (!contribution.isAllowedGenerateReport(this.getTestSuite())) {
            if (contributorName.equals("Katalon TestOps")) {
                contribution.printIntegrateMessage();
            }
            return false;
        }
        if (contributorName.equals("Katalon TestOps") && !contribution.isIntegrationEnabled()) {
            return false;
        }
        if (this.reachMaxFailedTestThreshold() && !this.isTestSuiteCompleted && !contribution.shouldUploadReportWhenIncomplete()) {
            return false;
        }
        return !this.isRunningInTestSuiteCollection() || contribution.isAllowedGenerateTestSuiteReportWhenRunningTestSuiteCollection();
    }

    private void prepareIntegrationReport(TestSuiteLogRecord suiteLog) throws Exception {
        if (!(this.getExecutedEntity() instanceof Reportable)) {
            return;
        }
        for (Map.Entry<String, ReportIntegrationContribution> reportContributorEntry : ReportIntegrationFactory.getInstance().getIntegrationContributorMap().entrySet()) {
            String contributorName = reportContributorEntry.getKey();
            ReportIntegrationContribution contribution = reportContributorEntry.getValue();
            if (!this.isRunningInTestSuiteCollection() && contributorName.equals("Katalon TestOps") && !contribution.isIntegrationEnabled()) {
                this.writeLine(StringConstants.MSG_RP_TEST_OPS_ADMIN_REPORT_DISABLED);
                continue;
            }
            if (!this.isContributorEligibleForGeneratingReport(contribution, contributorName)) continue;
            this.setStatus(LauncherStatus.PREPARE_INTEGRATION_REPORT, MessageFormat.format(ExecutionMessageConstants.ReportableLauncher_MSG_PREPARING_INTEGRATION_REPORT, contributorName));
            if (contributorName.equals(GlobalStringConstants.QTEST_NAME)) {
                suiteLog.addBuildData(this.getRunConfig().getAdditionalInfo());
            }
            try {
                this.writeLine(MessageFormat.format(ExecutionMessageConstants.ReportableLauncher_MSG_PREPARING_INTEGRATION_REPORT, contributorName));
                contribution.generateIntegrationReportForTestSuite(suiteLog);
                this.writeLine(MessageFormat.format(ExecutionMessageConstants.ReportableLauncher_MSG_DONE_PREPARING_INTEGRATION_REPORT, contributorName));
            }
            catch (Exception e) {
                this.writeError(MessageFormat.format(ExecutionMessageConstants.ReportableLauncher_MSG_UNABLE_TO_GENERATE_INTEGRATION_REPORT, contributorName, contribution.extractIntegrationExceptionMessage(e)));
                LogUtil.logError((Throwable)e);
            }
        }
    }

    protected void copyReport() {
        try {
            ReportLocationSetting reportLocSetting = ((Reportable)this.getExecutedEntity()).getReportLocationSetting();
            if (reportLocSetting == null || !reportLocSetting.isReportFolderPathSet()) {
                return;
            }
            File userReportFolder = this.getUserReportFolder(reportLocSetting);
            if (userReportFolder != null) {
                this.writeLine(MessageFormat.format(StringConstants.LAU_PRT_COPYING_RPT_TO_USR_RPT_FOLDER, userReportFolder.getAbsolutePath()));
                if (reportLocSetting.isCleanReportFolderFlagActive()) {
                    this.writeLine(StringConstants.LAU_PRT_CLEANING_USR_RPT_FOLDER);
                    FileUtils.cleanDirectory((File)userReportFolder);
                }
                File[] fileArray = this.getReportFolder().listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File reportChildSourceFile = fileArray[n2];
                    String fileName = FilenameUtils.getBaseName((String)reportChildSourceFile.getName());
                    String fileExtension = FilenameUtils.getExtension((String)reportChildSourceFile.getName());
                    if (!fileExtension.equalsIgnoreCase("lck")) {
                        if (fileExtension.equalsIgnoreCase("csv") || fileExtension.equalsIgnoreCase("html")) {
                            fileName = reportLocSetting.getReportFileName();
                        }
                        if (reportChildSourceFile.isFile()) {
                            FileUtils.copyFile((File)reportChildSourceFile, (File)new File(userReportFolder, fileName + "." + fileExtension));
                        } else if (reportChildSourceFile.isDirectory()) {
                            File newCoppiedFolder = new File(userReportFolder, fileName);
                            newCoppiedFolder.mkdirs();
                            FileUtils.copyDirectory((File)reportChildSourceFile, (File)newCoppiedFolder);
                        }
                    }
                    ++n2;
                }
            }
        }
        catch (IOException ex) {
            LogUtil.logError((Throwable)ex);
        }
    }

    private boolean isRunningDebugMode() {
        String filePath = Paths.get(this.suiteLogRecord.getLogFolder(), ReportController.EXECUTION_SETTING_FILE_NAME).toString();
        RunConfiguration.setExecutionSettingFile((String)filePath);
        return RunConfiguration.isRunningDebugMode();
    }

    private boolean isContributorEligibleForUploadingReport(ReportIntegrationContribution contribution, String contributorName) {
        if (!this.isContributorEligibleForGeneratingReport(contribution, contributorName)) {
            return false;
        }
        if (this.isRunningDebugMode() && contributorName.equals("Katalon TestOps")) {
            return false;
        }
        if (!contribution.isIntegrationActive(this.getTestSuite())) {
            contribution.printIntegrateMessage();
            return false;
        }
        return true;
    }

    private void uploadReportToIntegratingProduct(TestSuiteLogRecord suiteLogRecord) throws Exception {
        if (!(this.getExecutedEntity() instanceof Reportable)) {
            return;
        }
        for (Map.Entry<String, ReportIntegrationContribution> reportContributorEntry : ReportIntegrationFactory.getInstance().getIntegrationContributorMap().entrySet()) {
            String contributorName = reportContributorEntry.getKey();
            ReportIntegrationContribution contribution = reportContributorEntry.getValue();
            if (!this.isContributorEligibleForUploadingReport(contribution, contributorName)) continue;
            this.setStatus(LauncherStatus.UPLOAD_REPORT, MessageFormat.format(StringConstants.LAU_MESSAGE_UPLOADING_RPT, contributorName));
            if (contributorName.equals(GlobalStringConstants.AZURE_DEVOPS_NAME)) {
                suiteLogRecord.addBuildData(this.getRunConfig().getAdditionalInfo());
            }
            try {
                this.writeLine(MessageFormat.format(StringConstants.LAU_PRT_SENDING_RPT_TO, contributorName));
                contribution.uploadTestSuiteResult(suiteLogRecord);
                this.writeLine(MessageFormat.format(StringConstants.LAU_PRT_REPORT_SENT, contributorName));
            }
            catch (Exception e) {
                String causeMessage = TestOpsErrorResponse.getFromException((Exception)e) == TestOpsErrorResponse.TEST_RESULT_QUOTA_EXCEEDED ? StringConstants.MSG_RP_TEST_OPS_ERROR_RESULT_QUOTA_EXCEEDED : contribution.extractIntegrationExceptionMessage(e);
                this.writeError(MessageFormat.format(StringConstants.MSG_RP_ERROR_TO_SEND_INTEGRATION_REPORT, contributorName, causeMessage));
                LogUtil.printAndLogError((Throwable)e);
            }
        }
    }

    private File getUserReportFolder(ReportLocationSetting rpLocSetting) {
        if (!rpLocSetting.isReportFolderPathSet()) {
            return null;
        }
        File reportFolder = new File(PathUtil.relativeToAbsolutePath((String)rpLocSetting.getReportFolderPath(), (String)this.getTestSuite().getProject().getFolderLocation()));
        if (reportFolder != null && !reportFolder.exists()) {
            reportFolder.mkdirs();
        }
        return reportFolder;
    }

    public TestSuiteEntity getTestSuite() {
        try {
            return TestSuiteController.getInstance().getTestSuiteByDisplayId(this.getRunConfig().getExecutionSetting().getExecutedEntity().getSourceId(), ProjectController.getInstance().getCurrentProject());
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            return null;
        }
    }

    protected IExecutedEntity getExecutedEntity() {
        return this.getRunConfig().getExecutionSetting().getExecutedEntity();
    }

    protected File getReportFolder() {
        return new File(this.getRunConfig().getExecutionSetting().getFolderPath());
    }

    protected List<Object[]> collectSummaryData(List<String> csvReports) throws Exception {
        ArrayList<Object[]> newDatas = new ArrayList<Object[]>();
        ArrayList<Object[]> suitesSummaryForEmail = new ArrayList<Object[]>();
        int suiteIndex = 0;
        while (suiteIndex < csvReports.size()) {
            String file = csvReports.get(suiteIndex);
            File csvReportFile = new File(file);
            if (csvReportFile.isFile()) {
                CSVReader csvReader = new CSVReader(file, CSVSeparator.COMMA, true);
                ArrayDeque datas = new ArrayDeque();
                datas.addAll(csvReader.getData());
                List suiteRow = (List)datas.pollFirst();
                String suiteName = suiteIndex + 1 + "." + (String)suiteRow.get(0);
                String browser = (String)suiteRow.get(1);
                String hostName = this.getRunConfig().getHostConfiguration().getHostName();
                String os = this.getRunConfig().getHostConfiguration().getOS();
                Object[] arrSuitesSummaryForEmail = new Object[]{suiteRow.get(0), 0, 0, 0, 0, hostName, os, browser};
                suitesSummaryForEmail.add(arrSuitesSummaryForEmail);
                int testIndex = 0;
                while (datas.size() > 0) {
                    List row = (List)datas.pollFirst();
                    boolean isEmptyLine = true;
                    for (String col : row) {
                        if (col == null || col.trim().equals("")) continue;
                        isEmptyLine = false;
                        break;
                    }
                    if (!isEmptyLine || datas.isEmpty()) continue;
                    List testRow = (List)datas.pollFirst();
                    String testName = ++testIndex + "." + (String)testRow.get(0);
                    newDatas.add(ArrayUtils.addAll((Object[])new String[]{suiteName, testName, browser}, (Object[])Arrays.copyOfRange(testRow.toArray(new String[0]), 2, testRow.size())));
                    String testStatus = (String)testRow.get(6);
                    if (TestStatus.TestStatusValue.PASSED.toString().equals(testStatus)) {
                        arrSuitesSummaryForEmail[1] = (Integer)arrSuitesSummaryForEmail[1] + 1;
                        continue;
                    }
                    if (TestStatus.TestStatusValue.FAILED.toString().equals(testStatus)) {
                        arrSuitesSummaryForEmail[2] = (Integer)arrSuitesSummaryForEmail[2] + 1;
                        continue;
                    }
                    if (TestStatus.TestStatusValue.ERROR.toString().equals(testStatus)) {
                        arrSuitesSummaryForEmail[3] = (Integer)arrSuitesSummaryForEmail[3] + 1;
                        continue;
                    }
                    if (!TestStatus.TestStatusValue.INCOMPLETE.toString().equals(testStatus)) continue;
                    arrSuitesSummaryForEmail[4] = (Integer)arrSuitesSummaryForEmail[4] + 1;
                }
            }
            ++suiteIndex;
        }
        File csvSummaryFile = new File(System.getProperty("java.io.tmpdir") + "Summary.csv");
        if (csvSummaryFile.exists()) {
            csvSummaryFile.delete();
        }
        CsvWriter.writeArraysToCsv((String[])CsvWriter.SUMMARY_HEADER, newDatas, (File)csvSummaryFile);
        return suitesSummaryForEmail;
    }

    public ReportEntity getReportEntity() {
        try {
            if (this.reportEntity == null) {
                this.reportEntity = ReportController.getInstance().getReportEntity(this.getTestSuite(), this.getId(), this.getRunConfig().getExecutionSessionId());
            }
            return this.reportEntity;
        }
        catch (Exception e) {
            LogUtil.logError((Throwable)e);
            return null;
        }
    }

    @Override
    protected void onStartExecutionComplete() {
        super.onStartExecutionComplete();
    }

    public void setReportEntity(ReportEntity reportEntity) {
        this.reportEntity = reportEntity;
    }

    protected TestSuiteExecutionEvent fireTestSuiteExecutionEvent(String eventName) {
        if (this.executedEntity instanceof TestSuiteExecutedEntity) {
            TestSuiteExecutionContextImpl executionContext = this.buildTestSuiteExecutionContext();
            TestSuiteExecutionEvent eventObject = new TestSuiteExecutionEvent(eventName, executionContext);
            ExecutionBundleActivator.getInstance().getEventBroker().send(eventName, (Object)eventObject);
        }
        return null;
    }

    private void fireInternalTestSuiteEvent(String eventName) {
        if (this.executedEntity instanceof TestSuiteExecutedEntity) {
            TestSuiteExecutionContextImpl executionContext = this.buildTestSuiteExecutionContext();
            TestSuiteExecutionEvent eventObject = new TestSuiteExecutionEvent(eventName, executionContext);
            ExecutionBundleActivator.getInstance().getEventBroker().send(eventName, (Object)eventObject);
        }
    }

    public TestSuiteExecutionContextImpl buildTestSuiteExecutionContext() {
        if (!(this.executedEntity instanceof TestSuiteExecutedEntity)) {
            return null;
        }
        TestSuiteExecutedEntity testSuiteEx = (TestSuiteExecutedEntity)this.executedEntity;
        ArrayList<TestCaseExecutionContext> testCaseContexts = new ArrayList<TestCaseExecutionContext>();
        int iterationIndex = 0;
        int index = 0;
        while (index < testSuiteEx.getExecutedItems().size()) {
            IExecutedEntity testCaseExecutedEntity = testSuiteEx.getExecutedItems().get(index);
            int times = 0;
            if (testCaseExecutedEntity instanceof TestCaseExecutedEntity) {
                times = ((TestCaseExecutedEntity)testCaseExecutedEntity).getLoopTimes();
            } else if (testCaseExecutedEntity instanceof TestCaseBindingExecutedEntity) {
                times = ((TestCaseBindingExecutedEntity)testCaseExecutedEntity).getTestCaseExecutedEntity().getLoopTimes();
            }
            int loopTime = 0;
            while (loopTime < times) {
                TestStatus testStatus = this.getResult().getStatuses()[iterationIndex];
                Date tcStartTime = testStatus.getStartTime();
                Date tcEndTime = testStatus.getEndTime();
                testCaseContexts.add(TestCaseExecutionContextImpl.Builder.create(testCaseExecutedEntity.getSourceId(), testCaseExecutedEntity.getSourceId()).withTestCaseStatus(testStatus.getStatusValue().name()).withStartTime(tcStartTime != null ? tcStartTime.getTime() : 0L).withEndTime(tcEndTime != null ? tcEndTime.getTime() : 0L).withMessage(testStatus.getStackTrace()).build());
                ++iterationIndex;
                ++loopTime;
            }
            ++index;
        }
        TestSuiteExecutionContextImpl.Builder builder = TestSuiteExecutionContextImpl.Builder.create(this.getId(), testSuiteEx.getSourceId(), testSuiteEx.getEntity().getProject().getFolderLocation()).withReportId(this.getReportEntity().getIdForDisplay()).withTestCaseContext(testCaseContexts).withStartTime(this.startTime != null ? this.startTime.getTime() : 0L).withEndTime(this.endTime != null ? this.endTime.getTime() : 0L);
        if (this.suiteLogRecord != null) {
            builder.withHostName(this.suiteLogRecord.getHostName()).withOs(this.suiteLogRecord.getOs()).withBrowser(this.suiteLogRecord.getBrowser()).withDeviceId(this.suiteLogRecord.getDeviceId()).withDeviceName(this.suiteLogRecord.getDeviceName()).withSuiteName(this.suiteLogRecord.getName()).withExecutionProfile(this.suiteLogRecord.getRunData() != null ? this.suiteLogRecord.getRunData().getOrDefault("executionProfile", "") : "");
        }
        TestSuiteExecutionContextImpl executionContext = builder.build();
        return executionContext;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        if (this.endTime == null) {
            this.endTime = new Date();
        }
        return this.endTime;
    }

    public TestSuiteLogRecord getTestSuiteLogRecord() {
        return this.suiteLogRecord;
    }

    protected String getRetryStrategy() {
        if (this.runConfig.getExecutionSetting().getExecutedEntity() instanceof TestSuiteExecutedEntity) {
            TestSuiteExecutedEntity testSuiteExecutedEntity = (TestSuiteExecutedEntity)this.runConfig.getExecutionSetting().getExecutedEntity();
            return String.valueOf((Object)testSuiteExecutedEntity.getRetryStrategy());
        }
        return "";
    }

    protected int getNumberOfRetry() {
        if (this.runConfig.getExecutionSetting().getExecutedEntity() instanceof TestSuiteExecutedEntity) {
            TestSuiteExecutedEntity testSuiteExecutedEntity = (TestSuiteExecutedEntity)this.runConfig.getExecutionSetting().getExecutedEntity();
            return testSuiteExecutedEntity.getPreviousRerunTimes() + testSuiteExecutedEntity.getRemainingRerunTimes();
        }
        return 0;
    }

    protected int getNumTestSteps() {
        if (this.suiteLogRecord == null) {
            this.suiteLogRecord = new TestSuiteLogRecord(this.getName(), this.getRunConfig().getExecutionSetting().getFolderPath());
        }
        return ExecutionUtil.countNumTestSteps(this.suiteLogRecord.getChildRecords());
    }

    protected Map<String, Object> getIntegratedContributionsTrackingData() {
        if (this.testSuiteCollectionEntity != null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, ReportIntegrationContribution> contributions = ReportIntegrationFactory.getInstance().getIntegrationContributorMap();
        for (Map.Entry<String, ReportIntegrationContribution> element : contributions.entrySet()) {
            ReportIntegrationContribution contribution = element.getValue();
            if (contribution == null || !contribution.isNeededTrackingData()) continue;
            result.putAll(contribution.getTrackingProperties());
        }
        return result;
    }

    private void printMessageReachFailedThreshold() {
        this.writeLine(MessageFormat.format(ExecutionMessageConstants.LAU_MESSAGE_REACH_FAILED_TEST_THRESHOLD, this.getName(), this.getExecutedEntity().getFailedThreshold()));
    }

    private void updateThresholdWhenRetryAll() {
        if (this.getExecutedEntity() instanceof TestSuiteExecutedEntity) {
            TestSuiteExecutedEntity entity = (TestSuiteExecutedEntity)this.getExecutedEntity();
            int threshold = entity.getFailedThreshold();
            if (threshold <= 0) {
                return;
            }
            int numOfErrorAndFailure = this.getResult().getNumErrors() + this.getResult().getNumFailures() + this.getResult().getNumRetryErrorsAndFailures();
            if (!this.isRunningInTestSuiteCollection()) {
                entity.setFailedThreshold(threshold - numOfErrorAndFailure);
            }
        }
    }

    public String getTestCloudRunConfiguration() {
        if (this.runConfig.getAdditionalInfo().containsKey(ExecutionMessageConstants.TEST_CLOUD_RUN_CONFIGURATION_KEY)) {
            return (String)this.runConfig.getAdditionalInfo().get(ExecutionMessageConstants.TEST_CLOUD_RUN_CONFIGURATION_KEY);
        }
        return "";
    }

    protected Map<String, Object> getProtectedGlobalVariables() {
        List globalVariableEntities;
        ExecutionProfileEntity executionEntity;
        HashMap<String, Object> protectedGlobalVariables = new HashMap<String, Object>();
        ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
        ExecutionProfileEntity defaultExecutionEntity = null;
        try {
            List globalVariableEntities2;
            defaultExecutionEntity = GlobalVariableController.getInstance().getDefaultExecutionProfile(currentProject);
            if (defaultExecutionEntity != null && !(globalVariableEntities2 = defaultExecutionEntity.getGlobalVariableEntities()).isEmpty()) {
                protectedGlobalVariables.putAll(globalVariableEntities2.stream().filter(entry -> entry.isProtected()).filter(entry -> entry.getName() != null && entry.getValue() != null).collect(Collectors.toMap(GlobalVariableEntity::getName, GlobalVariableEntity::getValue)));
            }
        }
        catch (ControllerException controllerException) {}
        if ((executionEntity = (ExecutionProfileEntity)this.runConfig.getExecutionProfile()) != null && !executionEntity.isDefaultProfile() && !(globalVariableEntities = executionEntity.getGlobalVariableEntities()).isEmpty()) {
            protectedGlobalVariables.putAll(globalVariableEntities.stream().filter(entry -> entry.isProtected()).filter(entry -> entry.getName() != null && entry.getValue() != null).collect(Collectors.toMap(GlobalVariableEntity::getName, GlobalVariableEntity::getValue)));
        }
        return protectedGlobalVariables;
    }

    protected Map<String, Object> getOverridingGlobalVariables() {
        Map overridingGlobalVariables = this.runConfig.getOverridingGlobalVariables();
        return overridingGlobalVariables;
    }

    protected Map<String, Object> getOverridingProtectedGlobalVariables() {
        Map overridingProtectedGlobalVariables = this.runConfig.getOverridingProtectedGlobalVariables();
        return overridingProtectedGlobalVariables;
    }

    protected String convertMapToString(Map<String, Object> map, boolean encrypted) throws JsonProcessingException, UnsupportedEncodingException, GeneralSecurityException {
        String mapString = new ObjectMapper().writeValueAsString(map);
        if (encrypted) {
            CryptoUtil.CrytoInfo cryptoInfo = CryptoUtil.getDefault((String)mapString);
            mapString = CryptoUtil.encode((CryptoUtil.CrytoInfo)cryptoInfo);
        }
        return mapString;
    }

    protected boolean isUseGenerateConsoleLog() {
        return this.generateConsoleLog;
    }
}

