/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.launcher.process;

import com.kms.katalon.execution.launcher.process.ILaunchProcess;
import com.kms.katalon.execution.logging.IOutputStream;
import com.kms.katalon.execution.logging.VerificationOutputStreamHandler;

public class VerificationProcess
implements ILaunchProcess {
    private String testObjectId;
    private Process fSystemProcess;
    private VerificationOutputStreamHandler fOutputStreamHandler;
    private VerificationOutputStreamHandler fErrorStreamHandler;

    public VerificationProcess(String testObjectId, Process systemProcess) {
        this.fSystemProcess = systemProcess;
        this.testObjectId = testObjectId;
        this.buildStreamHandler(systemProcess);
    }

    private void buildStreamHandler(Process systemProcess) {
        this.fOutputStreamHandler = VerificationOutputStreamHandler.outputHandlerFrom(this.testObjectId, systemProcess.getInputStream());
        this.fOutputStreamHandler.start();
        this.fErrorStreamHandler = VerificationOutputStreamHandler.errorHandlerFrom(this.testObjectId, systemProcess.getErrorStream());
        this.fErrorStreamHandler.start();
    }

    @Override
    public int getExitValue() {
        return this.fSystemProcess.exitValue();
    }

    @Override
    public void terminate() {
        this.fSystemProcess.destroy();
    }

    @Override
    public boolean isTerminated() {
        try {
            this.getExitValue();
            return true;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return false;
        }
    }

    @Override
    public IOutputStream getOutputStreamHandler() {
        return this.fOutputStreamHandler;
    }

    @Override
    public IOutputStream getErrorStreamHandler() {
        return this.fErrorStreamHandler;
    }
}

