/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.execution.setting;

import com.kms.katalon.core.logging.model.ILogRecord;
import com.kms.katalon.core.logging.model.TestCaseLogRecord;
import com.kms.katalon.core.logging.model.TestStatus;
import com.kms.katalon.core.logging.model.TestSuiteCollectionLogRecord;
import com.kms.katalon.core.logging.model.TestSuiteLogRecord;
import com.kms.katalon.core.reporting.newreport.NewReportModelMapper;
import com.kms.katalon.core.reporting.newreport.analyzer.FailureAnalyzer;
import com.kms.katalon.core.reporting.service.IFailureAnalysisService;
import com.kms.katalon.core.util.internal.DateUtil;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.testsuite.TestSuiteCollectionEntity;
import com.kms.katalon.entity.testsuite.TestSuiteEntity;
import com.kms.katalon.execution.entity.EmailConfig;
import com.kms.katalon.report.core.models.entities.ExecutedTestEntity;
import com.kms.katalon.report.core.models.entities.ExecutedTestSuite;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class EmailVariableBinding {
    private static final String PASSED_COLOR = "#1D7931";
    private static final String PASSED_BG = "#D4EFDA";
    private static final String FAILED_COLOR = "#B5001B";
    private static final String FAILED_BG = "#FBE5E9";
    private static final String ERROR_COLOR = "#dd334d";
    private static final String INCOMPLETE_COLOR = "#5d585f";
    private static final String SKIPPED_COLOR = "#0067c7";
    private static final String EXCEPTION_PREFIX = "Exception:";
    private static final String NO_FAILURES = "No failures reported";
    public static final String AI_BADGE_ICON_URL = "<img src='https://raw.githubusercontent.com/katalon-studio/katalon-studio/master/katalon-start-page/Badge.png' alt='AI Icon' style='width: 16px; height: 14px; vertical-align: middle; margin-left: 2px; margin-bottom: 2px'/>";
    private static final List<TestStatus.TestStatusValue> MINOR_STATUSES = List.of(TestStatus.TestStatusValue.FAILED, TestStatus.TestStatusValue.ERROR, TestStatus.TestStatusValue.INCOMPLETE);

    public static Map<String, Object> getVariablesForTestSuiteEmail(TestSuiteLogRecord log, ExecutionProfileEntity profile, EmailConfig emailConfig, IFailureAnalysisService failureAnalysisService) {
        HashMap<String, Object> binding = new HashMap<String, Object>();
        String browser = Optional.ofNullable(log.getBrowser()).orElse("");
        String device = Optional.ofNullable(log.getMobileDeviceName()).orElse("");
        boolean cloud = browser.contains("TestCloud") || device.contains("TestCloud");
        String[] browserParts = browser.split("-");
        String[] deviceParts = device.split("-");
        binding.put("hostName", log.getHostName());
        binding.put("os", log.getOs());
        binding.put("suiteId", log.getId());
        binding.put("suiteName", log.getName());
        binding.put("deviceId", log.getDeviceId());
        binding.put("deviceName", log.getDeviceName());
        binding.put("projectName", log.getProjectName());
        binding.put("executedBy", log.getUserFullName());
        long start = log.getStartTime();
        long end = log.getLastTestCaseLogRecord().getEndTime();
        binding.put("startTime", DateUtil.getDateTimeFormatted((long)start));
        binding.put("duration", DateUtil.getElapsedTime((long)start, (long)end).replace("-", ""));
        binding.put("totalPassed", log.getTotalPassedTestCases());
        binding.put("totalFailed", log.getTotalFailedTestCases());
        binding.put("totalError", log.getTotalErrorTestCases());
        binding.put("totalTestCases", log.getTotalTestCases());
        binding.put("totalIncomplete", log.getTotalIncompleteTestCases());
        binding.put("totalSkipped", log.getTotalSkippedTestCases());
        binding.put("executionProfile", profile.getName());
        binding.put("test_case_result_table", EmailVariableBinding.buildTestCaseTable(log, false));
        binding.put("test_case_result_table_minimal", EmailVariableBinding.buildTestCaseTable(log, true));
        binding.put("browser", browserParts.length > 1 ? browserParts[browserParts.length - 1] : browser);
        TestStatus.TestStatusValue status = log.getStatus().getStatusValue();
        binding.put("status", status);
        binding.put("status_color", EmailVariableBinding.isPassed(status) ? PASSED_COLOR : FAILED_COLOR);
        binding.put("status_bg_color", EmailVariableBinding.isPassed(status) ? PASSED_BG : FAILED_BG);
        binding.put("failedReason", EmailVariableBinding.buildFailedReasonContent(log, status, emailConfig, failureAnalysisService));
        Object platform = "";
        if (browserParts.length > 1) {
            platform = cloud ? "TestCloud | " + browserParts[1] : browserParts[0];
        } else if (deviceParts.length > 1) {
            platform = cloud ? "TestCloud | " + deviceParts[1] + " | " + deviceParts[2] : deviceParts[0] + " | " + deviceParts[1];
        }
        binding.put("platform", platform);
        return binding;
    }

    private static String buildFailedReasonContent(TestSuiteLogRecord logRecord, TestStatus.TestStatusValue status, EmailConfig emailConfig, IFailureAnalysisService failureAnalysisService) {
        if (!EmailVariableBinding.isErrorOrFailed(status) || StringUtils.isBlank((CharSequence)logRecord.getErrorMessage())) {
            return NO_FAILURES;
        }
        if (emailConfig != null && emailConfig.isSendTestSuiteReportEnabled() && failureAnalysisService != null) {
            ExecutedTestSuite executedTestSuite = EmailVariableBinding.fromLogRecord(logRecord);
            if (executedTestSuite == null) {
                return EmailVariableBinding.extractFailureReason(logRecord.getErrorMessage(), status);
            }
            boolean isAnalyzeFailedReasonByAIEnabled = emailConfig.isAnalyzeFailedReasonByAI() && failureAnalysisService != null && failureAnalysisService.canExecute();
            FailureAnalyzer failureAnalyzer = new FailureAnalyzer(isAnalyzeFailedReasonByAIEnabled, failureAnalysisService);
            failureAnalyzer.analyzeAndEnrich((ExecutedTestEntity)executedTestSuite, (ILogRecord)logRecord);
            return isAnalyzeFailedReasonByAIEnabled ? "<img src='https://raw.githubusercontent.com/katalon-studio/katalon-studio/master/katalon-start-page/Badge.png' alt='AI Icon' style='width: 16px; height: 14px; vertical-align: middle; margin-left: 2px; margin-bottom: 2px'/> " + executedTestSuite.failedReason : executedTestSuite.failedReason;
        }
        return EmailVariableBinding.extractFailureReason(logRecord.getErrorMessage(), status);
    }

    private static String buildTestCaseTable(TestSuiteLogRecord log, boolean minimal) {
        String title = minimal ? "Test Issues" : "Test case result";
        List rows = log.getAllTestCaseLogRecords().stream().filter(tc -> !minimal || MINOR_STATUSES.contains(tc.getStatus().getStatusValue())).collect(Collectors.toList());
        StringBuilder table = EmailVariableBinding.initTable(title, false);
        if (minimal && rows.isEmpty()) {
            table.append("<tr><td colspan='3' style='text-align:center;'>All test cases passed successfully</td></tr>");
        }
        int index = 1;
        for (TestCaseLogRecord testCase : rows) {
            TestStatus.TestStatusValue status = testCase.getStatus().getStatusValue();
            table.append("<tr style='border-bottom: 1px solid #D1D0D1;'><td style='width:10%;'>").append(index++).append("</td><td>").append(testCase.getTestCaseNameWithIteration()).append("</td><td style='width: 16%; color:").append(EmailVariableBinding.getColor(status)).append(";'>").append(EmailVariableBinding.getLabel(status)).append("</td></tr>");
        }
        return table.append("</table>").toString();
    }

    public static Map<String, Object> getVariablesForTestSuiteCollectionEmail(TestSuiteCollectionLogRecord log) {
        List suites = log.getTestSuiteRecords();
        if (suites.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> binding = new HashMap<String, Object>();
        TestSuiteLogRecord firstSuite = (TestSuiteLogRecord)suites.get(0);
        binding.put("hostName", firstSuite.getHostName());
        binding.put("os", firstSuite.getOs());
        binding.put("projectName", firstSuite.getProjectName());
        binding.put("executedBy", firstSuite.getUserFullName());
        binding.put("startTime", DateUtil.getDateTimeFormatted((long)log.getStartTime()));
        binding.put("duration", DateUtil.getElapsedTime((long)log.getStartTime(), (long)log.getEndTime()));
        binding.put("suiteCollectionName", log.getName());
        binding.put("totalTestSuites", suites.size());
        Map<TestStatus.TestStatusValue, Long> counts = suites.stream().collect(Collectors.groupingBy(s -> s.getStatus().getStatusValue(), Collectors.counting()));
        binding.put("totalPassed", counts.getOrDefault(TestStatus.TestStatusValue.PASSED, 0L));
        binding.put("totalFailed", counts.getOrDefault(TestStatus.TestStatusValue.FAILED, 0L));
        binding.put("totalError", counts.getOrDefault(TestStatus.TestStatusValue.ERROR, 0L));
        binding.put("totalIncomplete", counts.getOrDefault(TestStatus.TestStatusValue.INCOMPLETE, 0L));
        binding.put("totalSkipped", counts.getOrDefault(TestStatus.TestStatusValue.SKIPPED, 0L));
        binding.put("test_suite_result_table", EmailVariableBinding.buildSuiteTable(log));
        TestStatus.TestStatusValue status = log.getStatus();
        binding.put("status", status);
        binding.put("status_color", EmailVariableBinding.isPassed(status) ? PASSED_COLOR : FAILED_COLOR);
        binding.put("status_bg_color", EmailVariableBinding.isPassed(status) ? PASSED_BG : FAILED_BG);
        binding.put("failedReason", EmailVariableBinding.extractFailureReason(suites.stream().map(TestSuiteLogRecord::getErrorMessage).filter(StringUtils::isNotBlank).findFirst().orElse(NO_FAILURES), status));
        binding.put("tsc_case_result_table", EmailVariableBinding.buildTestCaseTable(log, false));
        binding.put("tsc_case_result_table_minimal", EmailVariableBinding.buildTestCaseTable(log, true));
        return binding;
    }

    private static String buildTestCaseTable(TestSuiteCollectionLogRecord log, boolean minimal) {
        String title = minimal ? "Test Issues" : "Test case result";
        StringBuilder table = EmailVariableBinding.initTable(title, true);
        int index = 1;
        for (TestSuiteLogRecord suite : log.getTestSuiteRecords()) {
            List<TestCaseLogRecord> filteredTestCases = EmailVariableBinding.getFilteredTestCases(suite, minimal);
            for (TestCaseLogRecord testCase : filteredTestCases) {
                TestStatus.TestStatusValue status = testCase.getStatus().getStatusValue();
                table.append("<tr style='border-bottom: 1px solid #D1D0D1;'><td style='width:10%;'>").append(index++).append("</td><td>").append(suite.getName()).append("</td><td>").append(testCase.getTestCaseNameWithIteration()).append("</td><td style='width: 16%; color:").append(EmailVariableBinding.getColor(status)).append(";'>").append(EmailVariableBinding.getLabel(status)).append("</td></tr>");
            }
        }
        if (minimal && index == 1) {
            table.append("<tr><td colspan='4' style='text-align:center;'>All test cases passed successfully</td></tr>");
        }
        return table.append("</table>").toString();
    }

    private static List<TestCaseLogRecord> getFilteredTestCases(TestSuiteLogRecord suite, boolean minimal) {
        if (!minimal) {
            return suite.getAllTestCaseLogRecords();
        }
        return suite.getAllTestCaseLogRecords().stream().filter(tc -> MINOR_STATUSES.contains(tc.getStatus().getStatusValue())).collect(Collectors.toList());
    }

    private static String buildSuiteTable(TestSuiteCollectionLogRecord log) {
        StringBuilder table = EmailVariableBinding.initTable("Test suite result", false);
        int index = 1;
        for (TestSuiteLogRecord suite : log.getTestSuiteRecords()) {
            TestStatus.TestStatusValue status = suite.getStatus().getStatusValue();
            table.append("<tr style='border-bottom: 1px solid #D1D0D1;'><td style='width:10%;'>").append(index++).append("</td><td>").append(suite.getName()).append("</td><td style='width: 16%; color:").append(EmailVariableBinding.getColor(status)).append(";'>").append(EmailVariableBinding.getLabel(status)).append("</td></tr>");
        }
        return table.append("</table>").toString();
    }

    private static StringBuilder initTable(String heading, boolean hasTestSuiteColumn) {
        StringBuilder table = new StringBuilder();
        table.append("<h3>").append(heading).append("</h3>").append("<table cellpadding='10' cellspacing='0' style='width:100%;text-align:left;border-collapse:collapse;'>");
        ArrayList<String> columns = new ArrayList<String>();
        columns.add("<th style='border-bottom-left-radius: 5px; border-top-left-radius: 5px;'>No.</th>");
        if (hasTestSuiteColumn) {
            columns.add("<th>TEST SUITE ID</th>");
        }
        columns.add("<th>TEST CASE ID</th>");
        columns.add("<th style='border-bottom-right-radius: 5px; border-top-right-radius: 5px;'>Status</th>");
        table.append("<tr style='background-color:#f2f2f2;'>").append(String.join((CharSequence)"", columns)).append("</tr>");
        return table;
    }

    private static boolean isPassed(TestStatus.TestStatusValue status) {
        return status == TestStatus.TestStatusValue.PASSED;
    }

    private static String getColor(TestStatus.TestStatusValue status) {
        return switch (status) {
            case TestStatus.TestStatusValue.PASSED -> PASSED_COLOR;
            case TestStatus.TestStatusValue.FAILED -> FAILED_COLOR;
            case TestStatus.TestStatusValue.ERROR -> ERROR_COLOR;
            case TestStatus.TestStatusValue.INCOMPLETE -> INCOMPLETE_COLOR;
            case TestStatus.TestStatusValue.SKIPPED -> SKIPPED_COLOR;
            default -> "#000000";
        };
    }

    private static String getLabel(TestStatus.TestStatusValue status) {
        return switch (status) {
            case TestStatus.TestStatusValue.PASSED -> "Passed";
            case TestStatus.TestStatusValue.FAILED -> "Failed";
            case TestStatus.TestStatusValue.ERROR -> "Error";
            case TestStatus.TestStatusValue.INCOMPLETE -> "Incomplete";
            case TestStatus.TestStatusValue.SKIPPED -> "Skipped";
            default -> "Unknown";
        };
    }

    private static String extractFailureReason(String message, TestStatus.TestStatusValue testStatus) {
        int newLineIndex;
        if (!EmailVariableBinding.isErrorOrFailed(testStatus) || StringUtils.isBlank((CharSequence)message)) {
            return NO_FAILURES;
        }
        int exceptionIndex = message.indexOf(EXCEPTION_PREFIX);
        if (exceptionIndex >= 0 && (newLineIndex = (message = message.substring(exceptionIndex + EXCEPTION_PREFIX.length()).trim()).indexOf(10)) > 0) {
            message = message.substring(0, newLineIndex).trim();
        }
        return message;
    }

    public static Map<String, Object> getTestEmailVariables() {
        HashMap<String, Object> binding = new HashMap<String, Object>();
        binding.put("projectName", "Demo");
        binding.put("hostName", "localhost");
        binding.put("os", "Windows 10");
        binding.put("browser", "Chrome 130.0");
        binding.put("suiteId", "Test Suites/Sample Suite");
        binding.put("suiteName", "Sample Suite");
        binding.put("suiteCollectionName", "Sample Suite Collection");
        binding.put("deviceName", "My device");
        binding.put("deviceId", "------");
        binding.put("startTime", DateUtil.getDateTimeFormatted((long)Calendar.getInstance().getTimeInMillis()));
        binding.put("duration", "10s");
        binding.put("status", "PASSED");
        binding.put("status_color", PASSED_COLOR);
        binding.put("status_bg_color", PASSED_BG);
        binding.put("totalPassed", 1);
        binding.put("totalFailed", 0);
        binding.put("totalError", 0);
        binding.put("totalIncomplete", 0);
        binding.put("totalSkipped", 0);
        binding.put("totalTestCases", 1);
        binding.put("totalTestSuites", 1);
        binding.put("executionProfile", "default");
        binding.put("executedBy", "Katalon");
        binding.put("platform", "");
        binding.put("failedReason", NO_FAILURES);
        binding.put("test_case_result_table", "<h3>Test case result</h3><table cellpadding='10' cellspacing='0' style=\"width: 100%; text-align: left; border-collapse: collapse;\"><tr style=\"background-color: #f2f2f2;\"><th style=\"border-bottom-left-radius: 5px; border-top-left-radius: 5px;\">No.</th><th>TEST CASE ID</th><th style=\"border-bottom-right-radius: 5px; border-top-right-radius: 5px;\">STATUS</th></tr><tr style=\"border-bottom: 1px solid #D1D0D1;\"><td style=\"width: 10%;\">1</td><td>Test Cases/Sample test case</td><td style=\"width: 16%; color:#1D7931;\">Passed</td></tr></table>");
        binding.put("test_suite_result_table", "<h3>Test suite result</h3><table cellpadding='10' cellspacing='0' style=\"width: 100%; text-align: left; border-collapse: collapse;\"><tr style=\"background-color: #f2f2f2;\"><th style=\"border-bottom-left-radius: 5px; border-top-left-radius: 5px;\">No.</th><th>TEST SUITE ID</th><th style=\"border-bottom-right-radius: 5px; border-top-right-radius: 5px;\">STATUS</th></tr><tr style=\"border-bottom: 1px solid #D1D0D1;\"><td style=\"width: 10%;\">1</td><td>Test Suites/Sample Suite</td><td style=\"width: 16%; color:#1D7931;\">Passed</td></tr></table>");
        binding.put("test_case_result_table_minimal", "<h3>Test Issues</h3><table cellpadding='10' cellspacing='0' style=\"width: 100%; text-align: left; border-collapse: collapse;\"><tr style=\"background-color: #f2f2f2;\"><th style=\"border-bottom-left-radius: 5px; border-top-left-radius: 5px;\">No.</th><th>TEST CASE ID</th><th style=\"border-bottom-right-radius: 5px; border-top-right-radius: 5px;\">STATUS</th></tr><tr style=\"border-bottom: 1px solid #D1D0D1;\"><td colspan=\"3\" style=\"text-align: center;\">All test cases passed successfully</td></tr></table>");
        return binding;
    }

    public static Map<String, Object> getVariablesForTestSuiteEmailSettings(TestSuiteEntity entity) {
        HashMap<String, Object> binding = new HashMap<String, Object>();
        binding.put("suiteId", entity.getId());
        binding.put("suiteName", entity.getName());
        binding.put("suiteCollectionName", "");
        return binding;
    }

    public static Map<String, Object> getVariablesForTestSuiteCollectionEmailSettings(TestSuiteCollectionEntity entity) {
        HashMap<String, Object> binding = new HashMap<String, Object>();
        binding.put("suiteCollectionId", entity.getId());
        binding.put("suiteCollectionName", entity.getName());
        binding.put("suiteName", "");
        binding.put("suiteId", "");
        binding.put("browser", "");
        binding.put("deviceName", "");
        binding.put("deviceId", "");
        binding.put("platform", "");
        binding.put("executionProfile", "");
        return binding;
    }

    private static boolean isErrorOrFailed(TestStatus.TestStatusValue status) {
        return status == TestStatus.TestStatusValue.FAILED || status == TestStatus.TestStatusValue.ERROR;
    }

    private static ExecutedTestSuite fromLogRecord(TestSuiteLogRecord logRecord) {
        NewReportModelMapper mapper = new NewReportModelMapper();
        try {
            return (ExecutedTestSuite)mapper.mapLogRecord((ILogRecord)logRecord, -1);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

