/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.machine.services;

import com.kms.katalon.common.ConsoleCommandExecutor;
import com.kms.katalon.machine.core.services.IMachineService;
import com.kms.katalon.machine.services.MachineService;
import java.io.IOException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinuxMachineService
extends MachineService
implements IMachineService {
    private Logger logger = LoggerFactory.getLogger(LinuxMachineService.class);
    private static final String[] LINUX_GET_MACHINE_ID_COMMAND_1 = new String[]{"cat", "/var/lib/dbus/machine-id"};
    public static final String[] LINUX_GET_MACHINE_ID_COMMAND_2 = new String[]{"cat", "/etc/machine-id"};

    @Override
    public String getMachineId() {
        String machineId;
        try {
            this.logger.info(String.format("Start getting machine ID on Linux", new Object[0]));
            machineId = LinuxMachineService.getMachineIdFromCmd();
            if (!StringUtils.equals((CharSequence)"N/A", (CharSequence)machineId)) {
                machineId = this.appendAdditionalSignatures(machineId);
            }
        }
        catch (IOException | InterruptedException e) {
            this.logger.error(e.getMessage());
            machineId = "N/A";
        }
        String result = LinuxMachineService.hash(machineId);
        this.logger.info(String.format("End getting machine ID on Linux %s", result));
        return result;
    }

    @Override
    public String getOsDependentUsername() {
        String username = "";
        try {
            Class<?> clazz = Class.forName("com.sun.security.auth.module.UnixSystem");
            Object o = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method method = clazz.getDeclaredMethod("getUsername", new Class[0]);
            username = (String)method.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            this.logger.info("OS username is empty");
            username = System.getProperty("user.name", "");
        }
        return username;
    }

    private static String getMachineIdFromCmd() throws IOException, InterruptedException {
        String machineId = ConsoleCommandExecutor.runConsoleCommandAndCollectFirstResult((String[])LINUX_GET_MACHINE_ID_COMMAND_1);
        if (StringUtils.length((CharSequence)machineId) != 32) {
            machineId = ConsoleCommandExecutor.runConsoleCommandAndCollectFirstResult((String[])LINUX_GET_MACHINE_ID_COMMAND_2);
        }
        return StringUtils.length((CharSequence)machineId) == 32 ? machineId : "N/A";
    }
}

