/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.machine.services;

import com.kms.katalon.common.ConsoleCommandExecutor;
import com.kms.katalon.machine.core.services.IMachineService;
import com.kms.katalon.machine.services.MachineService;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacMachineService
extends MachineService
implements IMachineService {
    private Logger logger = LoggerFactory.getLogger(MacMachineService.class);
    private static final String MAC_GET_MACHINE_ID_FIELD = "IOPlatformUUID";
    private static final String MAC_GET_MACHINE_ID_DELIMITER = "=";
    public static final String[] MAC_GET_MACHINE_ID_COMMAND = new String[]{"ioreg", "-rd1", "-c", "IOPlatformExpertDevice", "|", "grep", "IOPlatformUUID"};

    @Override
    public String getMachineId() {
        String machineId = "N/A";
        try {
            this.logger.info(String.format("Start getting machine ID on Mac", new Object[0]));
            machineId = MacMachineService.getMachineIdFromCmd();
            if (!StringUtils.equals((CharSequence)"N/A", (CharSequence)machineId)) {
                machineId = this.appendAdditionalSignatures(machineId);
            }
        }
        catch (IOException | InterruptedException e) {
            this.logger.error(e.getMessage());
        }
        String result = MacMachineService.hash(machineId);
        this.logger.info(String.format("End getting machine ID on Mac %s", result));
        return result;
    }

    @Override
    public String getOsDependentUsername() {
        String username = "";
        try {
            Class<?> clazz = Class.forName("com.sun.security.auth.module.UnixSystem");
            Object o = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Method method = clazz.getDeclaredMethod("getUsername", new Class[0]);
            username = (String)method.invoke(o, new Object[0]);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        if (StringUtils.isBlank((CharSequence)username)) {
            this.logger.info("OS username is empty");
            username = System.getProperty("user.name", "");
        }
        return username;
    }

    private static String getMachineIdFromCmd() throws IOException, InterruptedException {
        List commandLineResults = ConsoleCommandExecutor.runConsoleCommandAndCollectResults((String[])MAC_GET_MACHINE_ID_COMMAND);
        String commandLineResult = commandLineResults.stream().filter(result -> result.contains(MAC_GET_MACHINE_ID_FIELD)).findAny().orElse("N/A");
        return Arrays.asList(commandLineResult.split(MAC_GET_MACHINE_ID_DELIMITER)).stream().map(String::trim).map(result -> result.replace("\"", "")).map(String::toLowerCase).filter(result -> result.matches("[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}")).findAny().orElse("N/A");
    }
}

