/*
 * Decompiled with CFR 0.152.
 */
package ca.mestevens.ios.xcode.parser.utils;

import ca.mestevens.ios.xcode.parser.models.CommentedIdentifier;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectParser {
    private String body;

    public ObjectParser(String body) {
        this.body = body == null ? "" : body.trim();
        this.removeSurroundingComments();
    }

    public String parseNextObject() {
        this.removeSurroundingComments();
        int nestLevel = 0;
        String returnString = "";
        int index = 0;
        for (char c : this.body.toCharArray()) {
            returnString = returnString + c;
            ++index;
            if (c == ';' && nestLevel == 0) {
                this.body = this.body.substring(index).trim();
                return returnString.trim();
            }
            if (c == '{') {
                ++nestLevel;
            }
            if (c != '}') continue;
            --nestLevel;
        }
        return null;
    }

    public ObjectParser getNextNestedObjects() {
        this.removeSurroundingComments();
        int startIndex = this.body.indexOf(123);
        String newBody = this.body.substring(startIndex + 1).trim();
        return new ObjectParser(newBody);
    }

    private void removeSurroundingComments() {
        while (this.body.startsWith("/*")) {
            int indexOfCommentEnd = this.body.indexOf("*/");
            this.body = this.body.substring(indexOfCommentEnd + 2).trim();
        }
        while (this.body.endsWith("*/")) {
            while (!this.body.endsWith("/*")) {
                this.body = this.body.substring(0, this.body.length() - 1).trim();
            }
            this.body = this.body.substring(0, this.body.length() - 2).trim();
        }
    }

    public CommentedIdentifier getCommentedIdentifier(String value) {
        CommentedIdentifier commentedIdentifier = null;
        if (value.contains("/*")) {
            String valueValue = value.substring(0, value.indexOf("/*")).trim();
            String valueComment = value.substring(value.indexOf("/*") + 2).trim();
            valueComment = valueComment.substring(0, valueComment.indexOf("*/")).trim();
            commentedIdentifier = new CommentedIdentifier(valueValue, valueComment);
        } else {
            commentedIdentifier = new CommentedIdentifier(value, null);
        }
        return commentedIdentifier;
    }

    public List<String> getStringList(String value) {
        value = value.substring(1, value.indexOf(41));
        ArrayList<String> list = new ArrayList<String>();
        if (!value.trim().equals("")) {
            String[] values;
            for (String listValue : values = value.split(",")) {
                if ((listValue = listValue.trim()).equals("")) continue;
                list.add(listValue);
            }
        }
        return list;
    }

    public List<CommentedIdentifier> getIdentifierList(String value) {
        String commentPart = "";
        value = value.substring(1, value.indexOf(41));
        ArrayList<CommentedIdentifier> list = new ArrayList<CommentedIdentifier>();
        if (!value.trim().equals("")) {
            String[] values;
            for (String listValue : values = value.split(",")) {
                if ((listValue = listValue.trim()).equals("")) continue;
                if (listValue.contains("/*")) {
                    int commentStartIndex = listValue.indexOf("/*");
                    int commentEndIndex = listValue.indexOf("*/");
                    commentPart = listValue.substring(commentStartIndex + 2, commentEndIndex).trim();
                    listValue = listValue.substring(0, commentStartIndex).trim();
                }
                list.add(new CommentedIdentifier(listValue, commentPart));
            }
        }
        return list;
    }
}

