/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.steps.jdt.ui;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Platform;

public abstract class CucumberJavaPreferences {
    public static final String PREF_USE_STEP_DEFINITIONS_FILTERS = "cucumber.eclipse.steps.jdt.use_step_definitions_filters";
    public static final String PREF_ACTIVE_FILTERS_LIST = "cucumber.eclipse.steps.jdt.active_filters";
    public static final String PREF_INACTIVE_FILTERS_LIST = "cucumber.eclipse.steps.jdt.inactive_filters";

    public static boolean isUseStepDefinitionsFilters() {
        return Platform.getPreferencesService().getBoolean("cucumber.eclipse.steps.jdt", PREF_USE_STEP_DEFINITIONS_FILTERS, false, null);
    }

    public static String[] getStepDefinitionsFilters() {
        return CucumberJavaPreferences.parseList(Platform.getPreferencesService().getString("cucumber.eclipse.steps.jdt", PREF_ACTIVE_FILTERS_LIST, "", null));
    }

    public static String[] parseList(String listString) {
        ArrayList<String> list = new ArrayList<String>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            list.add(token);
        }
        return list.toArray(new String[list.size()]);
    }

    public static String serializeList(String[] list) {
        if (list == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < list.length) {
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(list[i]);
            ++i;
        }
        return buffer.toString();
    }
}

