/*
 * Decompiled with CFR 0.152.
 */
package com.katalon.platform.api.util;

import com.katalon.platform.api.network.ApplicationProxyPreference;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class ProxyUtils {
    private static final String JAVA_NET_USE_SYSTEM_PROXIES = "java.net.useSystemProxies";
    private static final List<NetworkInterface> NETWORK_INTERFACES;

    public static Proxy getApplicationProxy() throws URISyntaxException, IOException {
        return ProxyUtils.getProxy(ApplicationProxyPreference.getSystemProxyInformation());
    }

    public static Proxy getProxy(ApplicationProxyPreference.ProxyInformation proxyInfo) throws URISyntaxException, IOException {
        if (proxyInfo == null) {
            throw new IllegalArgumentException("proxyInfo cannot be null");
        }
        switch (ApplicationProxyPreference.ProxyOption.valueOf(proxyInfo.getProxyOption())) {
            case NO_PROXY: {
                return Proxy.NO_PROXY;
            }
            case USE_SYSTEM: {
                return ProxyUtils.getSystemProxy();
            }
            case MANUAL_CONFIG: {
                return ProxyUtils.getProxyForManualConfig(proxyInfo);
            }
        }
        return Proxy.NO_PROXY;
    }

    public static Proxy getSystemProxy() throws URISyntaxException, IOException {
        System.setProperty(JAVA_NET_USE_SYSTEM_PROXIES, "true");
        for (String ipAdress : ProxyUtils.getAllIpAddresses()) {
            List<Proxy> l = ProxySelector.getDefault().select(new URI("http://" + ipAdress));
            for (Proxy proxy : l) {
                InetSocketAddress addr = (InetSocketAddress)proxy.address();
                if (addr == null) continue;
                return proxy;
            }
        }
        return Proxy.NO_PROXY;
    }

    private static Proxy getProxyForManualConfig(final ApplicationProxyPreference.ProxyInformation proxyInfo) {
        System.setProperty(JAVA_NET_USE_SYSTEM_PROXIES, "false");
        Proxy proxy = new Proxy(ProxyUtils.getProxyTypeForManualConfig(proxyInfo), new InetSocketAddress(proxyInfo.getProxyServerAddress(), proxyInfo.getProxyServerPort()));
        if (StringUtils.isNotEmpty((CharSequence)proxyInfo.getUsername()) && StringUtils.isNotEmpty((CharSequence)proxyInfo.getPassword())) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxyInfo.getUsername(), proxyInfo.getPassword().toCharArray());
                }
            });
        }
        return proxy;
    }

    private static Proxy.Type getProxyTypeForManualConfig(ApplicationProxyPreference.ProxyInformation proxyInfo) {
        return ApplicationProxyPreference.ProxyServerType.valueOf(proxyInfo.getProxyServerType()) == ApplicationProxyPreference.ProxyServerType.SOCKS ? Proxy.Type.SOCKS : Proxy.Type.HTTP;
    }

    private static Collection<String> getAllIpAddresses() throws IOException {
        TreeSet<String> addresses = new TreeSet<String>();
        for (NetworkInterface ni : NETWORK_INTERFACES) {
            Enumeration<InetAddress> addressEnumeration = ni.getInetAddresses();
            while (addressEnumeration.hasMoreElements()) {
                InetAddress address = addressEnumeration.nextElement();
                if (address.isLoopbackAddress() || address.getHostAddress().contains(":")) continue;
                addresses.add(address.getHostAddress());
            }
        }
        if (addresses.isEmpty()) {
            throw new IOException("Failed to get non-loopback IP address!");
        }
        return addresses;
    }

    static {
        try {
            NETWORK_INTERFACES = Collections.list(NetworkInterface.getNetworkInterfaces());
        }
        catch (SocketException se) {
            throw new RuntimeException("Could not retrieve ethernet network interfaces.", se);
        }
    }
}

