/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.util;

import com.google.common.net.HostAndPort;
import io.netty.handler.codec.http.HttpRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Locale;

public class HttpUtil {
    public static String getHostFromRequest(HttpRequest httpRequest) {
        String host = null;
        if (HttpUtil.startsWithHttpOrHttps(httpRequest.getUri())) {
            try {
                URI uri = new URI(httpRequest.getUri());
                host = uri.getHost();
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        if (host == null || host.isEmpty()) {
            host = HttpUtil.parseHostHeader(httpRequest, false);
        }
        return host;
    }

    public static String getHostAndPortFromRequest(HttpRequest httpRequest) {
        if (HttpUtil.startsWithHttpOrHttps(httpRequest.getUri())) {
            try {
                return HttpUtil.getHostAndPortFromUri(httpRequest.getUri());
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return HttpUtil.parseHostHeader(httpRequest, true);
    }

    public static boolean startsWithHttpOrHttps(String uri) {
        if (uri == null) {
            return false;
        }
        String lowercaseUri = uri.toLowerCase(Locale.US);
        return lowercaseUri.startsWith("http://") || lowercaseUri.startsWith("https://");
    }

    public static String getHostAndPortFromUri(String uriString) throws URISyntaxException {
        URI uri = new URI(uriString);
        if (uri.getPort() == -1) {
            return uri.getHost();
        }
        return HostAndPort.fromParts((String)uri.getHost(), (int)uri.getPort()).toString();
    }

    private static String parseHostHeader(HttpRequest httpRequest, boolean includePort) {
        List hosts = httpRequest.headers().getAll("Host");
        if (!hosts.isEmpty()) {
            String hostAndPort = (String)hosts.get(0);
            if (includePort) {
                return hostAndPort;
            }
            HostAndPort parsedHostAndPort = HostAndPort.fromString((String)hostAndPort);
            return parsedHostAndPort.getHost();
        }
        return null;
    }
}

