/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.windows.driver;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.remote.DesiredCapabilities;

public class WindowsDesiredCapsBuilder {
    private static final String CAPS_AUTOMATION_NAME = "appium:automationName";
    private static final String CAPS_APP = "appium:app";
    private static final String CAPS_APP_WORKING_DIR = "appium:appWorkingDir";
    private static final String CAPS_APP_ARGS = "appium:appArguments";
    private static final String CAPS_APP_TOP_LEVEL_WINDOW = "appium:appTopLevelWindow";
    private static final String CAPS_APP_TOP_LEVEL_WINDOW_TITLE_MATCH = "appium:appTopLevelWindowTitleMatch";
    public static final String ROOT_APP = "Root";
    private DesiredCapabilities desiredCapabilities = new DesiredCapabilities();

    public WindowsDesiredCapsBuilder() {
        this.desiredCapabilities.setCapability(CAPS_AUTOMATION_NAME, "FlaUI");
    }

    public WindowsDesiredCapsBuilder withApp(String value) {
        this.desiredCapabilities.setCapability(CAPS_APP, value);
        return this;
    }

    public WindowsDesiredCapsBuilder withRootApp() {
        this.desiredCapabilities.setCapability(CAPS_APP, ROOT_APP);
        return this;
    }

    public WindowsDesiredCapsBuilder withAppWorkingDir(String value) {
        this.desiredCapabilities.setCapability(CAPS_APP_WORKING_DIR, value);
        return this;
    }

    public WindowsDesiredCapsBuilder withAppArguments(String value) {
        this.desiredCapabilities.setCapability(CAPS_APP_ARGS, value);
        return this;
    }

    public WindowsDesiredCapsBuilder withAppTopLevelWindow(String value) {
        this.desiredCapabilities.setCapability(CAPS_APP_TOP_LEVEL_WINDOW, value);
        return this;
    }

    public WindowsDesiredCapsBuilder withAppTopLevelWindowTitleMatch(String value) {
        this.desiredCapabilities.setCapability(CAPS_APP_TOP_LEVEL_WINDOW_TITLE_MATCH, value);
        return this;
    }

    public WindowsDesiredCapsBuilder merge(Map<String, Object> value) {
        this.desiredCapabilities.merge((Capabilities)new DesiredCapabilities(value));
        return this;
    }

    public WindowsDesiredCapsBuilder merge(DesiredCapabilities value) {
        this.desiredCapabilities.merge((Capabilities)value);
        return this;
    }

    public DesiredCapabilities build() {
        String app = (String)this.desiredCapabilities.getCapability(CAPS_APP);
        if (StringUtils.isBlank((CharSequence)app) || ROOT_APP.equalsIgnoreCase(app)) {
            this.desiredCapabilities.setCapability(CAPS_APP_ARGS, null);
            this.desiredCapabilities.setCapability(CAPS_APP_WORKING_DIR, null);
        } else if (app.endsWith("!App")) {
            this.desiredCapabilities.setCapability(CAPS_APP_WORKING_DIR, null);
        }
        return this.desiredCapabilities;
    }
}

