/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.google.genai.ApiClient;
import com.google.genai.ChatBase;
import com.google.genai.Models;
import com.google.genai.Transformers;
import com.google.genai.types.Candidate;
import com.google.genai.types.Content;
import com.google.genai.types.GenerateContentConfig;
import com.google.genai.types.GenerateContentResponse;
import java.util.ArrayList;
import java.util.List;

public final class Chat
extends ChatBase {
    private final ApiClient apiClient;
    private final Models models;
    private final String model;
    private final GenerateContentConfig config;

    Chat(ApiClient apiClient, String model, GenerateContentConfig config) {
        super(new ArrayList<Content>(), new ArrayList<Content>());
        this.apiClient = apiClient;
        this.models = new Models(apiClient);
        this.model = model;
        this.config = config;
    }

    public GenerateContentResponse sendMessage(String text, GenerateContentConfig config) {
        return this.privateSendMessage(Transformers.tContents(this.apiClient, text), config);
    }

    public GenerateContentResponse sendMessage(String text) {
        return this.privateSendMessage(Transformers.tContents(this.apiClient, text), null);
    }

    public GenerateContentResponse sendMessage(Content content, GenerateContentConfig config) {
        return this.privateSendMessage(Transformers.tContents(this.apiClient, content), config);
    }

    public GenerateContentResponse sendMessage(Content content) {
        return this.privateSendMessage(Transformers.tContents(this.apiClient, content), null);
    }

    public GenerateContentResponse sendMessage(List<Content> contents, GenerateContentConfig config) {
        return this.privateSendMessage(contents, config);
    }

    public GenerateContentResponse sendMessage(List<Content> contents) {
        return this.privateSendMessage(contents, null);
    }

    private GenerateContentResponse privateSendMessage(List<Content> contents, GenerateContentConfig config) {
        if (!this.validateContents(contents)) {
            throw new IllegalArgumentException("The content of the message is invalid.");
        }
        ArrayList<Content> requestContents = new ArrayList<Content>();
        requestContents.addAll(this.curatedHistory);
        requestContents.addAll(contents);
        if (this.config != null && config == null) {
            config = this.config;
        }
        GenerateContentResponse response = this.models.generateContent(this.model, requestContents, config);
        response.checkFinishReason();
        ArrayList<Content> responseContents = new ArrayList<Content>();
        for (Candidate candidate : response.candidates().get()) {
            responseContents.add(candidate.content().get());
        }
        ArrayList<Content> currentHistory = new ArrayList<Content>();
        currentHistory.addAll(contents);
        currentHistory.addAll(responseContents);
        this.recordHistory(currentHistory);
        return response;
    }
}

