/*
 * Decompiled with CFR 0.152.
 */
package com.google.genai;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.google.api.core.InternalApi;
import com.google.genai.errors.GenAiIOException;
import java.io.IOException;

public abstract class JsonSerializable {
    static final ObjectMapper objectMapper = new ObjectMapper();

    public String toJson() {
        return JsonSerializable.toJsonString(this);
    }

    static String toJsonString(Object object) {
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new GenAiIOException("Failed to serialize the object to JSON.", (IOException)((Object)e));
        }
    }

    static JsonNode toJsonNode(Object object) {
        return objectMapper.valueToTree(object);
    }

    @InternalApi
    protected static <T extends JsonSerializable> T fromJsonString(String jsonString, Class<T> clazz) {
        try {
            return (T)((JsonSerializable)objectMapper.readValue(jsonString, clazz));
        }
        catch (JsonProcessingException e) {
            throw new GenAiIOException("Failed to deserialize the JSON string.", (IOException)((Object)e));
        }
    }

    static <T extends JsonSerializable> T fromJsonNode(JsonNode jsonNode, Class<T> clazz) {
        try {
            return (T)((JsonSerializable)objectMapper.treeToValue((TreeNode)jsonNode, clazz));
        }
        catch (JsonProcessingException e) {
            throw new GenAiIOException("Failed to deserialize the JSON node.", (IOException)((Object)e));
        }
    }

    static JsonNode stringToJsonNode(String string) {
        try {
            return objectMapper.readTree(string);
        }
        catch (JsonProcessingException e) {
            throw new GenAiIOException("Failed to parse the JSON string.", (IOException)((Object)e));
        }
    }

    static {
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_ABSENT);
        objectMapper.registerModule((Module)new Jdk8Module());
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

