/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import com.kms.katalon.core.logging.logback.LogbackConfigurator;
import com.kms.katalon.logging.SystemStreams;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.core.services.log.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class LogConfigurator {
    public static final String CONFIG_PROPERTY_FILE = "log.properties";
    public static final String CONFIG_FOLDER = "Include/config";
    public static final String LOG_LEVEL_PROPERTY_PREFIX = "logging.level.";
    public static final String DEFAULT_CONFIG_FILE = "logback.xml";
    public static final String KRE_CONFIG_FILE = "logback-kre.xml";
    public static final String EXECUTION_CONFIG_FILE = "logback-execution.xml";

    public static void initialize(File defaultConfigFile, File customConfigFile) throws IOException {
        LogbackConfigurator.init(defaultConfigFile, customConfigFile);
        SystemStreams.getInstance().recaptureOriginals();
    }

    public static File getConfigFile(String fileName) throws IOException {
        Path path = new Path("/resources/logback/" + fileName);
        URL url = FileLocator.find((Bundle)FrameworkUtil.getBundle(LogConfigurator.class), (IPath)path, null);
        return FileUtils.toFile((URL)FileLocator.toFileURL((URL)url));
    }

    public static void setupEclipseE4LogAppender(Logger eclipseLogger) {
        LogbackConfigurator.setupEclipseE4LogAppender(eclipseLogger);
    }

    public static void setupEclipsePlatformFileAppender() {
        LogbackConfigurator.setupEclipsePlatformFileAppender();
    }

    public static void muteNonKsStderr() {
        LogbackConfigurator.muteNonKsStderr();
    }

    public static void muteStackTraceInConsole() {
        LogbackConfigurator.muteStackTraceInConsole();
    }

    public static void addLogFilter(Filter<ILoggingEvent> filter) {
        LogbackConfigurator.addLogFilter(filter);
    }

    public static void addConsoleLogEventConsumer(Consumer<ILoggingEvent> consumer) {
        LogbackConfigurator.addConsoleLogEventConsumer(consumer);
    }

    public static void removeConsoleLogEventConsumer(Consumer<ILoggingEvent> consumer) {
        LogbackConfigurator.removeConsoleLogEventConsumer(consumer);
    }
}

