/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.testops.core.model;

import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ExecutionReportScanResult {
    public List<NormalReportArtifact> normalArtifacts;
    public List<FutureReportArtifact> futureArtifacts;

    public ExecutionReportScanResult(List<NormalReportArtifact> paths, List<FutureReportArtifact> futurePaths) {
        this.normalArtifacts = paths;
        this.futureArtifacts = futurePaths;
    }

    public List<ReportArtifact> getAll() {
        return Stream.concat(this.futureArtifacts.stream(), this.normalArtifacts.stream()).collect(Collectors.toList());
    }

    public List<ReportArtifact> getNormalArtifacts() {
        return this.normalArtifacts.stream().collect(Collectors.toList());
    }

    public List<ReportArtifact> getFutureArtifacts() {
        return this.futureArtifacts.stream().collect(Collectors.toList());
    }

    public static class FutureReportArtifact
    extends ReportArtifact {
        public Future<Path> path;

        public FutureReportArtifact(Future<Path> path) {
            this.path = path;
        }

        @Override
        public Path get() {
            try {
                return this.path.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                return null;
            }
        }
    }

    public static class NormalReportArtifact
    extends ReportArtifact {
        public Path path;

        public NormalReportArtifact(Path path) {
            this.path = path;
        }

        @Override
        public Path get() {
            return this.path;
        }
    }

    public static abstract class ReportArtifact {
        public abstract Path get();
    }
}

