/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.integration.testcloud.configuration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.core.json.adapters.LocalDateTimeAdapter;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.entity.file.IFileEntity;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.testsuite.RunConfigurationDescription;
import com.kms.katalon.execution.configuration.contributor.IRunConfigurationContributor;
import com.kms.katalon.execution.console.entity.BooleanConsoleOption;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.console.entity.IntegerConsoleOption;
import com.kms.katalon.execution.console.entity.StringConsoleOption;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.webui.configuration.contributor.WebUIRunConfigurationContributor;
import com.kms.katalon.execution.webui.driver.RemoteWebDriverConnector;
import com.kms.katalon.testcloud.configuration.TestCloudRunConfiguration;
import com.kms.katalon.testcloud.core.constants.IntegrationTestCloudMessageConstants;
import com.kms.katalon.testcloud.core.model.APITestCloudMobileDevice;
import com.kms.katalon.testcloud.core.model.TestCloudApplication;
import com.kms.katalon.testcloud.core.model.TestCloudDesktopBrowser;
import com.kms.katalon.testcloud.core.model.TestCloudEntity;
import com.kms.katalon.testcloud.core.model.TestCloudEnvironment;
import com.kms.katalon.testcloud.core.model.TestCloudExecutionMode;
import com.kms.katalon.testcloud.core.model.TestCloudMobileCapability;
import com.kms.katalon.testcloud.core.model.TestCloudMobileDevice;
import com.kms.katalon.testcloud.core.model.TestCloudMobilePlatformName;
import com.kms.katalon.testcloud.core.model.TestCloudSessionType;
import com.kms.katalon.testcloud.core.model.TestCloudTunnel;
import com.kms.katalon.testcloud.core.model.exception.TestCloudException;
import com.kms.katalon.testcloud.core.service.ITestCloudController;
import com.kms.katalon.testcloud.driver.TestCloudDriverConnector;
import com.kms.katalon.testcloud.service.TestCloudService;
import com.kms.katalon.testcloud.util.TestCloudModelParser;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestCloudRunConfigurationContributor
extends WebUIRunConfigurationContributor
implements IRunConfigurationContributor {
    private static final Logger logger = LoggerFactory.getLogger(TestCloudService.class);
    private static final int PREFERRED_ORDER = 12;
    private static final String INLCUDING_ARGUMENT_KEY_REGEX = "^-\\w+=\\w+";
    private static final String TESTCLOUD_MOBILE_DEVICE_ID_OPTION = "testcloudMobileDeviceId";
    private static final String TESTCLOUD_MOBILE_DEVICE_ID_SECOND_OPTION = "testcloudMobileDeviceID";
    private static final String TESTCLOUD_MOBILE_ID_OPTION = "testcloudMobileId";
    private static final String TESTCLOUD_MOBILE_ID_SECOND_OPTION = "testcloudMobileID";
    private static final String TESTCLOUD_ENVIRONMENT_ID_OPTION = "testcloudEnvironmentId";
    private static final String TESTCLOUD_ENVIRONMENT_ID_SECOND_OPTION = "testcloudEnvironmentID";
    private static final String TESTCLOUD_TUNNEL_OPTION = "testcloudTunnel";
    private static final String TESTCLOUD_APPLICATION_ID_OPTION = "testcloudAppId";
    private static final String TESTCLOUD_OVERRIDE_TESTCLOUD_APPLICATION_OPTION = "overrideTestcloudAppId";
    private TestCloudEntity selectedEntity = new TestCloudEntity();
    @Inject
    IEclipseContext context;
    @Inject
    private ITestCloudController testCloudController;
    private String deviceId;
    private Boolean isMissingMobileIdArg;
    private String testcloudApplicationId;
    private boolean overrideApplicationId;
    private TestCloudSessionType testCloudSessionType;

    private void checkEmptyArgumentsForMobileExecution(String argumentValue) throws ExecutionException {
        if (StringUtils.isEmpty((CharSequence)this.deviceId)) {
            throw new ExecutionException(IntegrationTestCloudMessageConstants.MSG_ERR_TESTCLOUD_DEVICE_MOBILE_ID_EMPTY);
        }
        if (StringUtils.isEmpty((CharSequence)argumentValue)) {
            throw new ExecutionException(IntegrationTestCloudMessageConstants.MSG_ERR_TESTCLOUD_MOBILE_ID_EMPTY);
        }
        this.isMissingMobileIdArg = false;
    }

    private void checkMissingMobileArguments() throws ExecutionException {
        if (this.isMissingMobileIdArg != null && this.isMissingMobileIdArg.booleanValue()) {
            throw new ExecutionException(IntegrationTestCloudMessageConstants.MSG_ERR_TESTCLOUD_MOBILE_ID_EMPTY);
        }
    }

    private void checkTestCloudMobile(APITestCloudMobileDevice selectedDevice, String testCloudMobileId) throws ExecutionException {
        if (selectedDevice == null) {
            throw new ExecutionException(MessageFormat.format(IntegrationTestCloudMessageConstants.MSG_ERR_TESTCLOUD_MOBILE_ID_NOT_FOUND, testCloudMobileId));
        }
    }

    private void checkTestCloudMobileDevice(Optional<TestCloudMobileCapability> selectedMobileOpt) throws ExecutionException {
        if (!selectedMobileOpt.isPresent()) {
            throw new ExecutionException(MessageFormat.format(IntegrationTestCloudMessageConstants.MSG_ERR_TESTCLOUD_MOBILE_DEVICE_ID_NOT_FOUND, this.deviceId));
        }
    }

    public List<ConsoleOption<?>> getConsoleOptionList() {
        return Arrays.asList(this.getTestCloudEnvironmentIdOption(0), this.getTestCloudEnvironmentIdSecondOption(0), this.getTestCloudMobileDeviceIdOption(""), this.getTestCloudMobileDeviceIdSecondOption(""), this.getTestCloudMobileIdOption(""), this.getTestCloudMobileIdSecondOption(""), this.getTestCloudTunnelOption(false), this.getTestCloudApplicationIdOption(""), this.getTestcloudOverrideApplicationIdOption(false));
    }

    public List<ConsoleOption<?>> getConsoleOptions(RunConfigurationDescription description) {
        TestCloudMobileDevice mobile = (TestCloudMobileDevice)JsonUtil.fromJson((String)((String)description.getRunConfigurationData().get("testCloudMobileDevice")), TestCloudMobileDevice.class);
        TestCloudDesktopBrowser environment = (TestCloudDesktopBrowser)JsonUtil.fromJson((String)((String)description.getRunConfigurationData().get("testCloudDesktopBrowser")), TestCloudDesktopBrowser.class);
        TestCloudSessionType sessionType = TestCloudSessionType.valueOf((String)((String)description.getRunConfigurationData().get("testCloudSessionType")));
        if (environment != null) {
            return Arrays.asList(this.getTestCloudEnvironmentIdOption(environment.getId()), this.getTestCloudTunnelOption(environment.isUsingTunnel()));
        }
        if (TestCloudSessionType.MOBILE_BROWSER.equals((Object)sessionType)) {
            return Arrays.asList(this.getTestCloudMobileDeviceIdOption(mobile.getMobileDeviceId()), this.getTestCloudMobileIdOption(mobile.getId()), this.getTestCloudTunnelOption(mobile.isUsingTunnel()));
        }
        if (description.getRunConfigurationData().containsKey("testCloudOverrideMobileApplication")) {
            String applicationJson = (String)description.getRunConfigurationData().get("testCloudOverrideMobileApplication");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{applicationJson})) {
                Gson gson = new GsonBuilder().registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeAdapter()).create();
                TestCloudApplication testCloudApplication = (TestCloudApplication)gson.fromJson(applicationJson, TestCloudApplication.class);
                StringConsoleOption mobileApplicationId = this.getTestCloudApplicationIdOption(testCloudApplication.getId());
                return Arrays.asList(this.getTestCloudMobileDeviceIdOption(mobile.getMobileDeviceId()), this.getTestCloudMobileIdOption(mobile.getId()), this.getTestCloudTunnelOption(mobile.isUsingTunnel()), this.getTestcloudOverrideApplicationIdOption(true), mobileApplicationId);
            }
        }
        return Arrays.asList(this.getTestCloudMobileDeviceIdOption(mobile.getMobileDeviceId()), this.getTestCloudMobileIdOption(mobile.getId()), this.getTestCloudTunnelOption(mobile.isUsingTunnel()), this.getTestcloudOverrideApplicationIdOption(false));
    }

    public String getId() {
        return WebUIDriverType.TESTCLOUD_DRIVER.toString();
    }

    public int getPreferredOrder() {
        return 12;
    }

    public IRunConfiguration getRunConfiguration(String projectDir) throws IOException, ExecutionException, URISyntaxException, TestCloudException, InterruptedException {
        if (this.selectedEntity instanceof TestCloudDesktopBrowser || this.selectedEntity instanceof TestCloudMobileDevice) {
            return this.getTestCloudConfiguration(projectDir, null, this.selectedEntity);
        }
        this.checkMissingMobileArguments();
        return new TestCloudRunConfiguration(projectDir);
    }

    public IRunConfiguration getRunConfiguration(String projectDir, RunConfigurationDescription runConfigurationDescription) throws IOException, ExecutionException, InterruptedException, URISyntaxException, TestCloudException {
        TestCloudEntity testCloudEntity;
        IRunConfiguration runConfiguration = super.getRunConfiguration(projectDir, runConfigurationDescription);
        if (this.selectedEntity instanceof TestCloudDesktopBrowser || this.selectedEntity instanceof TestCloudMobileDevice) {
            try {
                return this.getTestCloudConfiguration(projectDir, runConfiguration, this.selectedEntity);
            }
            catch (ExecutionException | TestCloudException | IOException | URISyntaxException e) {
                logger.error(e.getMessage());
            }
        }
        this.checkMissingMobileArguments();
        Map runConfigurationData = runConfigurationDescription.getRunConfigurationData();
        if (runConfigurationData == null) {
            return null;
        }
        TestCloudSessionType testCloudSessionType = TestCloudSessionType.DESKTOP_BROWSER;
        String sessionTypeString = (String)runConfigurationData.get("testCloudSessionType");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{sessionTypeString})) {
            testCloudSessionType = TestCloudSessionType.valueOf((String)sessionTypeString);
        }
        if (Objects.isNull(testCloudEntity = this.getTestCloudEntity(runConfigurationData))) {
            return null;
        }
        try {
            String applicationJson;
            TestCloudRunConfiguration testCloudRunConfiguration = (TestCloudRunConfiguration)this.testCloudController.buildRunConfiguration(testCloudEntity, testCloudSessionType, TestCloudExecutionMode.QUEUE);
            IFileEntity iFileEntity = runConfiguration.getExecutionProfile();
            if (iFileEntity instanceof ExecutionProfileEntity) {
                ExecutionProfileEntity profile = (ExecutionProfileEntity)iFileEntity;
                testCloudRunConfiguration.setExecutionProfile(profile);
            }
            if (StringUtils.isNotBlank((CharSequence)(applicationJson = (String)runConfigurationData.get("testCloudOverrideMobileApplication")))) {
                TestCloudDriverConnector testCloudDriverConnector = testCloudRunConfiguration.getTestCloudDriverConnector();
                Map desiredCapabilities = testCloudDriverConnector.getUserConfigProperties();
                desiredCapabilities.put("testCloudOverrideMobileApplication", applicationJson);
            }
            return testCloudRunConfiguration;
        }
        catch (TestCloudException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private IRunConfiguration getTestCloudConfiguration(String projectDir, IRunConfiguration runConfiguration, TestCloudEntity selectedEntity) throws IOException, ExecutionException, URISyntaxException, TestCloudException, InterruptedException {
        IFileEntity iFileEntity;
        TestCloudRunConfiguration testCloudRunConfiguration = null;
        if (runConfiguration != null) {
            testCloudRunConfiguration = (TestCloudRunConfiguration)runConfiguration;
        } else {
            testCloudRunConfiguration = (TestCloudRunConfiguration)this.testCloudController.buildRunConfiguration(selectedEntity, this.testCloudSessionType, TestCloudExecutionMode.QUEUE);
            if (!TestCloudSessionType.MOBILE_NATIVE.equals((Object)this.testCloudSessionType) || !this.overrideApplicationId) {
                return testCloudRunConfiguration;
            }
            if (this.testcloudApplicationId != null && this.overrideApplicationId) {
                TestCloudApplication testCloudApplication = this.testCloudController.requestTestCloudApplication(this.testcloudApplicationId);
                if (testCloudApplication != null) {
                    RemoteWebDriverConnector remoteDriverConnector = testCloudRunConfiguration.getRemoteDriverConnector();
                    Map desiredCapabilities = remoteDriverConnector.getUserConfigProperties();
                    Gson gson = new GsonBuilder().registerTypeAdapter(LocalDateTime.class, (Object)new LocalDateTimeAdapter()).create();
                    desiredCapabilities.put("testCloudOverrideMobileApplication", gson.toJson((Object)testCloudApplication));
                } else {
                    throw new ExecutionException(MessageFormat.format("The application with id {0} not found!", this.testcloudApplicationId));
                }
            }
        }
        if (runConfiguration != null && (iFileEntity = runConfiguration.getExecutionProfile()) instanceof ExecutionProfileEntity) {
            ExecutionProfileEntity profile = (ExecutionProfileEntity)iFileEntity;
            testCloudRunConfiguration.setExecutionProfile(profile);
        }
        return testCloudRunConfiguration;
    }

    private TestCloudEntity getTestCloudEntity(Map<String, String> runConfigurationData) {
        if (runConfigurationData == null) {
            return null;
        }
        String desktopBrowserEntityJson = runConfigurationData.get("testCloudDesktopBrowser");
        if (StringUtils.isNotBlank((CharSequence)desktopBrowserEntityJson)) {
            return (TestCloudEntity)JsonUtil.fromJson((String)desktopBrowserEntityJson, TestCloudDesktopBrowser.class);
        }
        String mobileDeviceEntityJson = runConfigurationData.get("testCloudMobileDevice");
        if (StringUtils.isNotBlank((CharSequence)mobileDeviceEntityJson)) {
            return (TestCloudEntity)JsonUtil.fromJson((String)mobileDeviceEntityJson, TestCloudMobileDevice.class);
        }
        String environmentEntityJson = runConfigurationData.get("testCloudEnvironment");
        if (StringUtils.isNotBlank((CharSequence)environmentEntityJson)) {
            return (TestCloudEntity)JsonUtil.fromJson((String)environmentEntityJson, TestCloudDesktopBrowser.class);
        }
        String mobileEntityJson = runConfigurationData.get("testCloudMobile");
        if (StringUtils.isNotBlank((CharSequence)mobileEntityJson)) {
            TestCloudEntity testCloudEntity = (TestCloudEntity)JsonUtil.fromJson((String)mobileEntityJson, TestCloudMobileDevice.class);
            if (Objects.isNull(testCloudEntity.getPlatformName())) {
                TestCloudMobilePlatformName platformName = TestCloudMobilePlatformName.valueOf((String)testCloudEntity.getOs().toUpperCase());
                testCloudEntity.setPlatformName(platformName);
            }
            return testCloudEntity;
        }
        return null;
    }

    private IntegerConsoleOption getTestCloudEnvironmentIdOption(final int initValue) {
        return new IntegerConsoleOption(){

            public String getOption() {
                return TestCloudRunConfigurationContributor.TESTCLOUD_ENVIRONMENT_ID_OPTION;
            }

            public Integer getValue() {
                return initValue;
            }

            public boolean isRequired() {
                return false;
            }
        };
    }

    private IntegerConsoleOption getTestCloudEnvironmentIdSecondOption(final int initValue) {
        return new IntegerConsoleOption(){

            public String getOption() {
                return TestCloudRunConfigurationContributor.TESTCLOUD_ENVIRONMENT_ID_SECOND_OPTION;
            }

            public Integer getValue() {
                return initValue;
            }

            public boolean isRequired() {
                return false;
            }
        };
    }

    private StringConsoleOption getTestCloudMobileDeviceIdOption(final String initValue) {
        return new StringConsoleOption(){

            public String getOption() {
                return TestCloudRunConfigurationContributor.TESTCLOUD_MOBILE_DEVICE_ID_OPTION;
            }

            public String getValue() {
                return initValue;
            }

            public boolean isRequired() {
                return false;
            }
        };
    }

    private StringConsoleOption getTestCloudMobileDeviceIdSecondOption(final String initValue) {
        return new StringConsoleOption(){

            public String getOption() {
                return TestCloudRunConfigurationContributor.TESTCLOUD_MOBILE_DEVICE_ID_SECOND_OPTION;
            }

            public String getValue() {
                return initValue;
            }

            public boolean isRequired() {
                return false;
            }
        };
    }

    private StringConsoleOption getTestCloudMobileIdOption(final String initValue) {
        return new StringConsoleOption(){

            public String getOption() {
                return TestCloudRunConfigurationContributor.TESTCLOUD_MOBILE_ID_OPTION;
            }

            public String getValue() {
                return initValue;
            }

            public boolean isRequired() {
                return false;
            }
        };
    }

    private StringConsoleOption getTestCloudMobileIdSecondOption(final String initValue) {
        return new StringConsoleOption(){

            public String getOption() {
                return TestCloudRunConfigurationContributor.TESTCLOUD_MOBILE_ID_SECOND_OPTION;
            }

            public String getValue() {
                return initValue;
            }

            public boolean isRequired() {
                return false;
            }
        };
    }

    private BooleanConsoleOption getTestCloudTunnelOption(final boolean initValue) {
        return new BooleanConsoleOption(){

            public String getOption() {
                return TestCloudRunConfigurationContributor.TESTCLOUD_TUNNEL_OPTION;
            }

            public Boolean getValue() {
                return initValue;
            }

            public boolean isRequired() {
                return false;
            }
        };
    }

    private StringConsoleOption getTestCloudApplicationIdOption(final String initValue) {
        return new StringConsoleOption(){

            public String getOption() {
                return TestCloudRunConfigurationContributor.TESTCLOUD_APPLICATION_ID_OPTION;
            }

            public String getValue() {
                return initValue;
            }

            public boolean isRequired() {
                return false;
            }
        };
    }

    private BooleanConsoleOption getTestcloudOverrideApplicationIdOption(final boolean initValue) {
        return new BooleanConsoleOption(){

            public String getOption() {
                return TestCloudRunConfigurationContributor.TESTCLOUD_OVERRIDE_TESTCLOUD_APPLICATION_OPTION;
            }

            public Boolean getValue() {
                return initValue;
            }

            public boolean isRequired() {
                return false;
            }
        };
    }

    public void setArgumentValue(ConsoleOption<?> consoleOption, String argumentValue) throws Exception {
        switch (consoleOption.getOption()) {
            case "testcloudEnvironmentID": 
            case "testcloudEnvironmentId": {
                int testCloudEnvironmentId = Integer.valueOf(argumentValue);
                TestCloudEnvironment[] availableEnvironments = this.testCloudController.getEnvironments();
                Optional<TestCloudEnvironment> selectedEnvironmentOpt = Arrays.asList(availableEnvironments).stream().filter(e -> e.getId() == testCloudEnvironmentId).findAny();
                if (!selectedEnvironmentOpt.isPresent()) {
                    throw new ExecutionException(MessageFormat.format(IntegrationTestCloudMessageConstants.MSG_ERR_TESTCLOUD_ENVIRONMENT_NOT_FOUND, testCloudEnvironmentId));
                }
                TestCloudDesktopBrowser entity = TestCloudModelParser.parseAPITestCloudEnvironmentToTestCloudBrowser((TestCloudEnvironment)selectedEnvironmentOpt.get());
                entity.setUsingTunnel(this.selectedEntity.isUsingTunnel());
                entity.setTimeout(this.testCloudController.getOSTimeout(entity.getOs()));
                this.selectedEntity = entity;
                this.testCloudSessionType = TestCloudSessionType.DESKTOP_BROWSER;
                break;
            }
            case "testcloudMobileDeviceID": 
            case "testcloudMobileDeviceId": {
                this.validateArgumentValue(argumentValue, IntegrationTestCloudMessageConstants.MSG_ERR_TESTCLOUD_DEVICE_MOBILE_ID_EMPTY);
                this.deviceId = argumentValue;
                this.isMissingMobileIdArg = true;
                this.testCloudSessionType = TestCloudSessionType.MOBILE_BROWSER;
                break;
            }
            case "testcloudMobileID": 
            case "testcloudMobileId": {
                this.validateArgumentValue(argumentValue, IntegrationTestCloudMessageConstants.MSG_ERR_TESTCLOUD_MOBILE_ID_EMPTY);
                this.checkEmptyArgumentsForMobileExecution(argumentValue);
                String testCloudMobileId = argumentValue;
                List<APITestCloudMobileDevice> availableMobileDevice = Arrays.asList(this.testCloudController.getMobileDevices());
                APITestCloudMobileDevice selectedDevice = null;
                Optional<TestCloudMobileCapability> selectedMobileOpt = Optional.empty();
                for (APITestCloudMobileDevice device : availableMobileDevice) {
                    if (!StringUtils.equals((CharSequence)device.getId(), (CharSequence)argumentValue)) continue;
                    selectedDevice = device;
                    selectedMobileOpt = device.getCapabilities().stream().filter(d -> StringUtils.equals((CharSequence)d.getDeviceId(), (CharSequence)this.deviceId)).findAny();
                    break;
                }
                this.checkTestCloudMobile(selectedDevice, testCloudMobileId);
                this.checkTestCloudMobileDevice(selectedMobileOpt);
                TestCloudMobileDevice mobile = TestCloudModelParser.parseAPITestCloudMobileDeviceToTestCloudMobileDevice((APITestCloudMobileDevice)selectedDevice, (TestCloudMobileCapability)selectedMobileOpt.get(), (boolean)this.selectedEntity.isUsingTunnel(), (int)this.testCloudController.getOSTimeout(argumentValue));
                this.selectedEntity = mobile;
                this.testCloudSessionType = TestCloudSessionType.MOBILE_BROWSER;
                break;
            }
            case "testcloudTunnel": {
                boolean usingTunnel = Boolean.valueOf(argumentValue);
                if (!usingTunnel) {
                    this.selectedEntity.setUsingTunnel(usingTunnel);
                    break;
                }
                TestCloudTunnel[] availableTunnels = this.testCloudController.getTunnels();
                if (availableTunnels == null || availableTunnels.length <= 0) {
                    throw new ExecutionException("No available TestCloud tunnel");
                }
                this.selectedEntity.setUsingTunnel(usingTunnel);
                break;
            }
            case "overrideTestcloudAppId": {
                this.overrideApplicationId = Boolean.valueOf(argumentValue);
                this.validateTestCloudApplicationId(IntegrationTestCloudMessageConstants.MSG_ERR_TESTCLOUD_APPLICATION_ID_EMPTY);
                this.testCloudSessionType = TestCloudSessionType.MOBILE_NATIVE;
                break;
            }
            case "testcloudAppId": {
                this.testcloudApplicationId = argumentValue;
                break;
            }
        }
    }

    private void validateArgumentValue(String argumentValue, String errMsg) throws ExecutionException {
        Pattern pattern = Pattern.compile(INLCUDING_ARGUMENT_KEY_REGEX, 2);
        Matcher matcher = pattern.matcher(argumentValue.trim());
        if (matcher.find()) {
            throw new ExecutionException(errMsg);
        }
    }

    private void validateTestCloudApplicationId(String errMsg) throws ExecutionException {
        if (this.overrideApplicationId) {
            if (this.testcloudApplicationId == null) {
                throw new ExecutionException(errMsg);
            }
            this.validateArgumentValue(this.testcloudApplicationId, errMsg);
        }
    }
}

