/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.dialog;

import com.kms.katalon.application.constants.ApplicationMessageConstants;
import com.kms.katalon.composer.components.impl.dialogs.AbstractDialog;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.constants.MessageConstants;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class IdleTimeoutDialog
extends AbstractDialog {
    public static final int DEACTIVATE_ID = 16;
    private long popupTimeout;
    private long maxContinuousIdleSessions;
    private DateFormat formatter = new SimpleDateFormat("HH:mm, MMMM dd, yyyy");

    public IdleTimeoutDialog(Shell parentShell, long popupTimeout, long maxContinuousIdleSessions) {
        super(parentShell, false);
        this.setShellStyle(16480);
        this.popupTimeout = popupTimeout;
        this.maxContinuousIdleSessions = maxContinuousIdleSessions;
    }

    protected void registerControlModifyListeners() {
        DialogUtil.activateShell((Shell)this.getShell());
    }

    protected void setInput() {
    }

    public String getDialogTitle() {
        return ApplicationMessageConstants.TITLE_KS_NOTIFICATION;
    }

    protected Control createDialogContainer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Calendar now = Calendar.getInstance();
        long logOutTime = now.getTimeInMillis() + this.popupTimeout;
        Label lblText = new Label(composite, 0);
        if (this.maxContinuousIdleSessions < 0L) {
            lblText.setText(MessageFormat.format(MessageConstants.MSG_IDLE_TIMEOUT, this.formatter.format(new Date(logOutTime))));
        } else if (this.maxContinuousIdleSessions == 0L) {
            lblText.setText(MessageFormat.format(MessageConstants.MSG_IDLE_TIMEOUT_AND_BYPASS_REACH, this.formatter.format(new Date(logOutTime))));
        } else {
            lblText.setText(MessageFormat.format(MessageConstants.MSG_IDLE_TIMEOUT_AND_BYPASS, this.formatter.format(new Date(logOutTime)), this.maxContinuousIdleSessions));
        }
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        boolean maxContinuousIdleSessionsReached = this.maxContinuousIdleSessions == 0L;
        this.createButton(parent, 16, GlobalMessageConstants.LOG_OUT, maxContinuousIdleSessionsReached);
        if (!maxContinuousIdleSessionsReached) {
            this.createButton(parent, 0, MessageConstants.BTN_CONTINUE, true);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 16) {
            this.closeWithCodeDeactivate();
            return;
        }
        super.buttonPressed(buttonId);
    }

    private void closeWithCodeDeactivate() {
        if (this.isOpened()) {
            this.setReturnCode(16);
            this.close();
        }
    }

    public boolean close() {
        return super.close();
    }

    public boolean forceClose() {
        this.setReturnCode(7);
        return this.close();
    }

    public boolean isOpened() {
        return this.getShell() != null && !this.getShell().isDisposed();
    }
}

