/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.activation.dialog;

import com.kms.katalon.activation.dialog.BaseModernDialog;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.session.core.model.AuthenticationRequest;
import com.kms.katalon.session.core.model.AuthenticationResponse;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class LoginBrowserDialog
extends BaseModernDialog {
    Browser browser;
    AuthenticationRequest authenticationRequest;
    AuthenticationResponse authenticationResponse;

    public LoginBrowserDialog(Shell parentShell) {
        super(parentShell);
    }

    public void setAuthenticationRequest(AuthenticationRequest authenticationRequest) {
        this.authenticationRequest = authenticationRequest;
        this.browser.setUrl(authenticationRequest.getAuthenticationUrl());
    }

    @Override
    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setMinimumSize(this.applyZoom(500), this.applyZoom(780));
    }

    @Override
    protected boolean isResizable() {
        return true;
    }

    @Override
    protected Point getContainerMargin() {
        return new Point(0, 0);
    }

    @Override
    protected boolean useButtonBar() {
        return true;
    }

    @Override
    protected void createContent(Composite container) {
        this.browser = (Browser)ComponentBuilder.browser((Composite)container, (int)327688).fill().build();
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                String location = event.location;
                if (!location.startsWith(LoginBrowserDialog.this.authenticationRequest.getRedirectUri() + "?")) {
                    return;
                }
                event.doit = false;
                LoginBrowserDialog.this.handleCallbackUrl(location);
            }

            public void changed(LocationEvent event) {
            }
        });
    }

    @Override
    protected void createButtons(Composite parent) {
        Point margin = new Point(ComponentUtil.applyZoom((int)30), ComponentUtil.applyZoom((int)10));
        ComponentUtil.setMargin((Composite)parent, (int)margin.x, (int)margin.y);
        ComponentUtil.gridFillVertical((Control)parent, (boolean)false);
        Composite container = (Composite)ComponentBuilder.gridContainer((Composite)parent).marginBottom(this.applyZoom(4)).fill().center().color(ColorUtil.GRAY_BADGE_COLOR).build();
        ComponentBuilder.label((Composite)container, (int)0).linkButtonWithCustomDisabledColor(ColorUtil.themeColor((Color)ColorUtil.getTextBlackColor(), (Color)ColorUtil.getTextWhiteColor())).text("Cancel ").fontSize(10).cursorPointer().onClick(event -> {
            boolean bl = this.close();
        }).build();
    }

    private void handleCallbackUrl(String location) {
        HashMap pairs = new HashMap();
        String redirectUrl = this.authenticationRequest.getRedirectUri();
        Arrays.stream(location.substring(redirectUrl.length() + 1).split("&")).forEach(pair -> {
            String[] keyValue = pair.split("=");
            if (keyValue.length == 2) {
                pairs.put(keyValue[0], keyValue[1]);
            }
        });
        String code = StringUtils.removeEnd((String)((String)pairs.get("code")), (String)"#");
        String idpType = (String)pairs.get("idp_type");
        String subDomain = (String)pairs.get("sub_domain");
        String actionContext = (String)pairs.get("context");
        if (StringUtils.isNotBlank((String)code)) {
            this.authenticationResponse = new AuthenticationResponse(code, idpType, subDomain, actionContext);
        }
        this.setReturnCode(0);
        this.close();
    }

    public AuthenticationResponse getAuthenticationReponse() {
        return this.authenticationResponse;
    }
}

