/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.session.core.model.SessionExpireSchedule;
import com.kms.katalon.session.core.services.ISessionManager;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeactivateHandler {
    private static DeactivateHandler instance;
    private Logger logger = LoggerFactory.getLogger(DeactivateHandler.class);
    @Inject
    IEventBroker eventBroker;
    @Inject
    ISessionManager sessionManager;

    public static DeactivateHandler getInstance() {
        if (Objects.isNull(instance)) {
            instance = new DeactivateHandler();
            BundleContext bundleContext = FrameworkUtil.getBundle(DeactivateHandler.class).getBundleContext();
            IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)bundleContext);
            ContextInjectionFactory.inject((Object)instance, (IEclipseContext)context);
        }
        return instance;
    }

    public void execute() {
        this.execute(null);
    }

    public void execute(SessionExpireSchedule.Reason expireReason) {
        boolean confirmed;
        if (expireReason != null) {
            this.sessionManager.setLastExpireReason(expireReason);
        } else {
            this.sessionManager.clearRememberedCredential();
        }
        BooleanSupplier closingHook = ProjectController.getInstance().getClosingHook();
        if (closingHook != null && !(confirmed = closingHook.getAsBoolean())) {
            return;
        }
        try {
            ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon.composer.project");
            store.setValue("project.latestOpened", "");
            ((IPersistentPreferenceStore)store).save();
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
        this.eventBroker.send("LOGOUT", null);
    }
}

