/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.composer.components.ComponentBundleActivator;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.constants.StringConstants;
import cucumber.eclipse.editor.editors.GherkinColors;
import org.codehaus.groovy.eclipse.GroovyPlugin;
import org.codehaus.groovy.eclipse.editor.GroovyColorManager;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.model.application.ui.menu.MDirectMenuItem;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;

public class SwitchThemeHandler {
    @Execute
    public void switchTheme(MDirectMenuItem directMenuItem, Shell activeShell) {
        IThemeEngine engine = ComponentBundleActivator.getThemeEngine((Display)activeShell.getDisplay());
        if (directMenuItem.getElementId().contains("light")) {
            engine.setTheme("com.kms.katalon.theme.default", true);
        } else {
            engine.setTheme("org.eclipse.e4.ui.css.theme.e4_dark", true);
        }
        ColorUtil.notifyThemeChange();
        this.changeGroovyEditorColor();
        this.changeCucumberEditorColor();
        if (MessageDialog.openQuestion((Shell)activeShell, (String)StringConstants.INFO, (String)"Katalon Studio requires restart to take fully effect. Would you like to restart now?")) {
            PlatformUI.getWorkbench().restart(true);
        }
    }

    private void changeGroovyEditorColor() {
        IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"java_keyword");
        PreferenceConverter.setValue((IPreferenceStore)this.getGroovyPreferenceStore(), (String)"groovy.editor.highlight.gjdk.color", (RGB)rgb);
        PreferenceConverter.setValue((IPreferenceStore)this.getGroovyPreferenceStore(), (String)"groovy.editor.highlight.groovykeywords.color", (RGB)rgb);
        PreferenceConverter.setValue((IPreferenceStore)this.getGroovyPreferenceStore(), (String)"groovy.editor.highlight.javatypes.color", (RGB)rgb);
        PreferenceConverter.setValue((IPreferenceStore)this.getGroovyPreferenceStore(), (String)"groovy.editor.highlight.javakeywords.color", (RGB)rgb);
        rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"java_string");
        PreferenceConverter.setValue((IPreferenceStore)this.getGroovyPreferenceStore(), (String)"groovy.editor.highlight.strings.color", (RGB)rgb);
        rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"java_bracket");
        PreferenceConverter.setValue((IPreferenceStore)this.getGroovyPreferenceStore(), (String)"groovy.editor.highlight.bracket.color", (RGB)rgb);
        rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"java_operator");
        PreferenceConverter.setValue((IPreferenceStore)this.getGroovyPreferenceStore(), (String)"groovy.editor.highlight.operator.color", (RGB)rgb);
        rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"java_annotation");
        PreferenceConverter.setValue((IPreferenceStore)this.getGroovyPreferenceStore(), (String)"groovy.editor.highlight.annotation.color", (RGB)rgb);
        rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"java_keyword_return");
        PreferenceConverter.setValue((IPreferenceStore)this.getGroovyPreferenceStore(), (String)"groovy.editor.highlight.return.color", (RGB)rgb);
        rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"java_default");
        PreferenceConverter.setValue((IPreferenceStore)this.getGroovyPreferenceStore(), (String)"groovy.editor.highlight.default.color", (RGB)rgb);
        GroovyColorManager colorManager = GroovyPlugin.getDefault().getTextTools().getColorManager();
        colorManager.uninitialize();
        colorManager.initialize();
    }

    private void changeCucumberEditorColor() {
        ITheme currentTheme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
        ColorRegistry registry = currentTheme.getColorRegistry();
        registry.put(GherkinColors.DEFAULT.COLOR_PREFERENCE_ID, ColorUtil.getTextColor().getRGB());
        registry.put(GherkinColors.COMMENT.COLOR_PREFERENCE_ID, ColorUtil.getCucumberCommentColor().getRGB());
    }

    private IPreferenceStore getGroovyPreferenceStore() {
        return GroovyPlugin.getDefault().getPreferenceStore();
    }
}

