/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.handlers;

import com.kms.katalon.session.core.model.AuthenticationResponse;
import com.kms.katalon.webserver.CustomHttpHandler;
import com.kms.katalon.webserver.CustomRequest;
import jakarta.inject.Inject;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;

public class SystemBrowserLoginHandler
extends CustomHttpHandler {
    @Inject
    private IEventBroker eventBroker;
    private final String SSO_AUTHENTICATED_IMG = "/sso/authenticated.png";

    @Override
    public void customHandle(CustomRequest req) throws IOException {
        String context = req.query("context");
        if (StringUtils.equalsAny((CharSequence)context, (CharSequence[])new CharSequence[]{"LOGIN", "REGISTER,LOGIN"})) {
            this.handleLogin(req);
        }
    }

    private void handleLogin(CustomRequest req) throws IOException {
        String message = "Authenticate successfully.\r\nYou can close this page and return to Katalon Studio IDE.";
        String html = this.generateCallbackPage(message, "LOGIN");
        req.send(200, html);
        req.end();
        String code = StringUtils.removeEnd((String)req.query("code"), (String)"#");
        String idpType = req.query("idp_type");
        String subDomain = req.query("sub_domain");
        String actionContext = req.query("context");
        if (StringUtils.isNotBlank((CharSequence)code)) {
            AuthenticationResponse authenticationResponse = new AuthenticationResponse(code, idpType, subDomain, actionContext);
            this.eventBroker.post("AUTHENTICATION_RESPONSE_GRABBED", (Object)authenticationResponse);
        }
    }

    private String generateCallbackPage(String message, String context) {
        String html = "<body>\n    <style>\n    .auth-container {\n        position: fixed;\n        width: 100%;\n        height: 100%;\n        left: 0;\n        top: 0;\n        display: flex;\n        justify-content: center;\n        align-items: center;\n        flex-direction: column;\n        margin-top: -5%;\n    }\n    .auth-image {\n        width: 10rem;\n    }\n    .auth-message {\n        font-family: sans-serif;\n        font-size: 1.7rem;\n        white-space: pre-wrap;\n        text-align: center;\n        margin-top: 3rem;\n    }\n    </style>\n    <div class=\"auth-container\">\n        <img src=\"{image}\" class=\"auth-image\">\n        <div class=\"auth-message\">{message}</div>\n    </div>\n    <script>\n        window.close();\n        var url = new URL(location.href);\n        var simpleUrl = `${url.origin}${url.pathname}?context={context}`;\n        history.replaceState(null, \"\", simpleUrl);\n    </script>\n</body>\n".replace("{message}", message).replace("{image}", "/sso/authenticated.png").replace("{context}", context);
        return html;
    }
}

