/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.intro;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class FunctionsIntroductionDialogSizeCalculator {
    private Shell currentShell;
    private double ratio;
    private Point expectedSize;

    public FunctionsIntroductionDialogSizeCalculator(Shell currentShell, Point expectedSize, double ratio) {
        this.currentShell = currentShell;
        this.ratio = ratio;
        this.expectedSize = expectedSize;
    }

    private Monitor getCurrentMonitor() {
        Monitor[] monitors;
        Point location = this.currentShell.getLocation();
        Monitor[] monitorArray = monitors = this.currentShell.getDisplay().getMonitors();
        int n = monitors.length;
        int n2 = 0;
        while (n2 < n) {
            Monitor monitor = monitorArray[n2];
            if (monitor.getClientArea().contains(location)) {
                return monitor;
            }
            ++n2;
        }
        return monitors.length > 0 ? monitors[0] : null;
    }

    public Point getBestSize() {
        Monitor currentMonitor = this.getCurrentMonitor();
        if (currentMonitor == null) {
            return null;
        }
        Rectangle monitorClientArea = currentMonitor.getClientArea();
        return new Point(Math.min(this.expectedSize.x, (int)((double)monitorClientArea.width * this.ratio)), Math.min(this.expectedSize.y, (int)((double)monitorClientArea.height * this.ratio)));
    }

    public void computeDialogSize(Composite fixedComposite) {
        Point shellSize = this.currentShell.getSize();
        Point fixedCompositeOldSize = fixedComposite.getSize();
        int remainX = shellSize.x - fixedCompositeOldSize.x;
        int remainY = shellSize.y - fixedCompositeOldSize.y;
        fixedComposite.setSize(this.getBestSize());
        Point fixedCompositeNewize = fixedComposite.getSize();
        this.currentShell.setSize(remainX + fixedCompositeNewize.x, fixedCompositeNewize.y + remainY);
    }
}

