/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.parts;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.kms.katalon.application.helper.UserProfileHelper;
import com.kms.katalon.application.userprofile.UserProfile;
import com.kms.katalon.common.About;
import com.kms.katalon.composer.components.impl.control.ScrollableComposite;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.ComponentUtil;
import com.kms.katalon.composer.components.util.ControlUtil;
import com.kms.katalon.composer.parts.WelcomeLeftPart;
import com.kms.katalon.composer.parts.WelcomeRightPart;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.core.util.EncodingUtil;
import com.kms.katalon.core.util.TimeUtil;
import com.kms.katalon.core.util.internal.Base64;
import com.kms.katalon.core.webservice.common.HttpUtil;
import com.kms.katalon.core.webservice.exception.SendRequestException;
import com.kms.katalon.discovery.core.model.ServerType;
import com.kms.katalon.discovery.core.services.IDiscoveryManager;
import com.kms.katalon.network.core.model.Authentication;
import com.kms.katalon.network.core.model.BearerAuthentication;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.model.exception.InvalidRequestException;
import com.kms.katalon.network.core.model.exception.ServerErrorException;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import com.kms.katalon.session.core.model.AuthenticationToken;
import com.kms.katalon.session.core.model.ProductFeature;
import com.kms.katalon.session.core.model.Session;
import com.kms.katalon.session.core.services.IFeatureController;
import com.kms.katalon.session.core.services.ISessionController;
import com.kms.katalon.testops.core.services.ITestOpsController;
import com.kms.katalon.webserver.WebViewController;
import com.kms.katalon.webserver.dto.RemoteFileServerResponse;
import com.kms.katalon.webserver.dto.StudioAppState;
import com.kms.katalon.webserver.dto.WebPageRequest;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class WelcomePart2 {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    @Inject
    private ISessionController sessionController;
    @Inject
    private ITestOpsController testOpsController;
    @Inject
    INetworkPreferences networkPreferences;
    @Inject
    private IDiscoveryManager discoveryController;
    private ObjectMapper objectMapper = new ObjectMapper();
    @Inject
    private IHttpClient httpClient;
    @Inject
    private IThemeEngine themeEngine;
    @Inject
    private IFeatureController featureController;
    private MPart part;
    private Composite mainComposite;
    private Browser webview;
    private boolean isOnlineStartPageContent;
    private final String TIMESTAMP_FORMAT = "HH:mm:ss - dd/MM/yyyy";
    private static final long FOUR_WEEKS = 28L;
    private Throwable remoteWebAssetServerError = null;
    private Optional<Boolean> isIntegrateWithKatalonSaas;
    private RemoteFileServerResponse remoteFileServerResponse;

    @PostConstruct
    public void initialize(Composite parent, MPart part) {
        this.isIntegrateWithKatalonSaas = Optional.empty();
        this.remoteFileServerResponse = null;
        this.part = part;
        WebViewController.getInstance().ensureStarted();
        this.registerEventListeners(parent);
        if (this.sessionController.isActivated()) {
            this.createControls(parent);
        }
    }

    private void showThisPart() {
        IPreferenceStore prefStore = PlatformUI.getPreferenceStore();
        if (!prefStore.contains("general.showHelpAtStartUp")) {
            prefStore.setDefault("general.showHelpAtStartUp", true);
        }
        if (!prefStore.getBoolean("general.showHelpAtStartUp")) {
            this.partService.hidePart(this.part);
        }
    }

    private void registerEventListeners(final Composite parent) {
        this.eventBroker.subscribe("PROJECT/OPENED", new EventHandler(){

            public void handleEvent(Event event) {
                WelcomePart2.this.showThisPart();
            }
        });
        this.eventBroker.subscribe("ACTIVATION/WEBVIEW_PAGE", new EventHandler(){

            public void handleEvent(Event event) {
                UISynchronizeService.asyncExec(() -> {
                    WelcomePart2.this.createControls(parent);
                    parent.layout(true, true);
                });
            }
        });
        this.eventBroker.subscribe("DEACTIVATION/WEBVIEW_PAGE", new EventHandler(){

            public void handleEvent(Event event) {
                UISynchronizeService.asyncExec(() -> WelcomePart2.this.disposeControls());
            }
        });
        this.eventBroker.subscribe("START_PAGE/RELOAD", new EventHandler(){

            public void handleEvent(Event event) {
                if (!WelcomePart2.this.isOnlineStartPageContent) {
                    return;
                }
                UISynchronizeService.asyncExec(() -> {
                    if (parent.isDisposed()) {
                        return;
                    }
                    WelcomePart2.this.createControls(parent);
                    parent.layout(true, true);
                });
            }
        });
        this.eventBroker.subscribe("INTRODUCE_GENAI", new EventHandler(){

            public void handleEvent(Event event) {
            }
        });
        this.isOnlineStartPageContent = false;
    }

    private void createControls(Composite parent) {
        this.configureExternalStartPage();
        this.createOnlineControls(parent);
        this.setFirstTimeUserLogin();
        TimeUtil.setTimeout(() -> {
            if (!this.checkOnline()) {
                UISynchronizeService.asyncExec(() -> {
                    if (ControlUtil.isDisposed((Widget)this.mainComposite)) {
                        return;
                    }
                    this.mainComposite.dispose();
                    this.createOfflineControls(parent);
                    parent.requestLayout();
                });
                this.isOnlineStartPageContent = false;
            }
        }, (long)1000L);
        this.isOnlineStartPageContent = true;
    }

    private void createOnlineControls(Composite parent) {
        this.disposeControls();
        this.mainComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent).build();
        String url = this.getUrlForStartPage();
        this.webview = (Browser)ComponentBuilder.browser((Composite)this.mainComposite).url(url).preventURLs(new String[]{"^https?://localhost.*", "^https?://127.0.0.1.*", "^https?://studio-cms.katalon.com.*", ".*embed.*", "res://.*", "file://.*"}).fill().build();
        this.webview.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent event) {
                event.doit = false;
            }
        });
        TimeUtil.setTimeout(() -> this.checkAndShowCreativeStartPage(), (long)3000L);
    }

    private void disposeControls() {
        if (!ControlUtil.isDisposed((Widget)this.mainComposite) && this.mainComposite != null) {
            this.mainComposite.dispose();
            this.mainComposite = null;
        }
        if (!ControlUtil.isDisposed((Widget)this.webview) && this.webview != null) {
            this.webview.dispose();
            this.webview = null;
        }
    }

    private void setFirstTimeUserLogin() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss - dd/MM/yyyy");
        UserProfile curUser = UserProfileHelper.getCurrentProfile();
        String currentDate = dateFormat.format(new Date());
        if (curUser.getFirstTimeActivate() == null) {
            curUser.setFirstTimeActivate(currentDate);
            UserProfileHelper.saveProfile((UserProfile)curUser);
        }
    }

    private boolean checkOnline() {
        return this.testOpsController.isOnline();
    }

    private void createOfflineControls(Composite parent) {
        this.disposeControls();
        FillLayout parentLayout = new FillLayout();
        parentLayout.marginHeight = 0;
        parentLayout.marginWidth = 0;
        parent.setLayout((Layout)parentLayout);
        final ScrollableComposite container = new ScrollableComposite(parent, 768);
        this.mainComposite = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)2).background(ColorUtil.getCompositeBackgroundColor()).backgroundMode(2).build();
        this.mainComposite.addListener(9, new Listener(){

            public void handleEvent(org.eclipse.swt.widgets.Event event) {
                Point size = WelcomePart2.this.mainComposite.computeSize(-1, -1);
                if (container.getMinHeight() < size.y) {
                    container.setMinHeight(size.y);
                }
            }
        });
        container.setContent((Control)this.mainComposite);
        container.setMinSize(new Point(900, 1300));
        container.setExpandHorizontal(true);
        container.setExpandVertical(true);
        WelcomeLeftPart leftComposite = new WelcomeLeftPart(this.mainComposite, 0);
        leftComposite.setLayoutData(new GridData(16384, 4, false, true));
        Composite rightComposite = new Composite(this.mainComposite, 0);
        GridLayout glRightComposite = new GridLayout(3, false);
        glRightComposite.marginHeight = 0;
        glRightComposite.marginWidth = 0;
        glRightComposite.marginTop = 40;
        glRightComposite.horizontalSpacing = 0;
        glRightComposite.verticalSpacing = 0;
        rightComposite.setLayout((Layout)glRightComposite);
        rightComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        WelcomePart2.addSpacer(rightComposite);
        WelcomeRightPart startPageContent = new WelcomeRightPart(rightComposite, 0, StringConstants.PA_WELCOME_RIGHT_PART_LINK);
        GridData gdStartPageContent = new GridData(4, 4, true, true);
        gdStartPageContent.minimumWidth = 600;
        startPageContent.setLayoutData(gdStartPageContent);
        WelcomePart2.addSpacer(rightComposite);
    }

    private String getUrlForStartPage() {
        String query = this.getTourParams();
        if (this.allowShowStartPageContents()) {
            String fallbackUrl = WebViewController.getInstance().getPage("StartPage.html" + query);
            if (this.shouldFetchPageFromRemote()) {
                try {
                    String remotePage = WebViewController.getInstance().getRemotePage(query);
                    return remotePage;
                }
                catch (URISyntaxException e) {
                    LoggerSingleton.logError((Throwable)e, (String)e.getMessage());
                }
            }
            return fallbackUrl;
        }
        return WebViewController.getInstance().getPage("CreativeStartPage.html" + query);
    }

    private boolean shouldFetchPageFromRemote() {
        return WebViewController.getInstance().isRemoteAssetServerStarted() && this.remoteWebAssetServerError == null && this.isIntegrateWithKatalonSaas.orElse(false) != false;
    }

    private int getPageId(UserProfile userProfile) {
        int id = 1;
        if (userProfile == null) {
            return id;
        }
        if (userProfile.getFirstTimeActivate() != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss - dd/MM/yyyy");
            String currentDate = dateFormat.format(new Date());
            try {
                long diffInDays = TimeUnit.DAYS.convert(dateFormat.parse(currentDate).getTime() - dateFormat.parse(userProfile.getFirstTimeActivate()).getTime(), TimeUnit.MILLISECONDS);
                if (diffInDays > 28L) {
                    id = 3;
                }
            }
            catch (ParseException e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
        return id;
    }

    private boolean allowShowStartPageContents() {
        boolean allowShowStartPageContents;
        ScopedPreferenceStore prefStore = PreferenceStoreManager.getPreferenceStore((String)"com.kms.katalon");
        boolean bl = allowShowStartPageContents = prefStore.contains("general.showStartPageContents") ? prefStore.getBoolean("general.showStartPageContents") : true;
        if (this.featureController.canUse(ProductFeature.CONFIGURE_SHOW_START_PAGE_CONTENTS)) {
            return allowShowStartPageContents;
        }
        return true;
    }

    private void checkAndShowCreativeStartPage() {
        HttpGet request = new HttpGet(StringConstants.PA_WELCOME_PART_SPECIAL_START_PAGE);
        try {
            HttpResponse response = HttpUtil.sendRequest((HttpUriRequest)request);
            String body = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            Type listType = new TypeToken<List<SpecialEvent>>(){}.getType();
            Gson gson = new GsonBuilder().setDateFormat("d-M-yyyy").create();
            List events = (List)gson.fromJson(body, listType);
            List activeEvents = events.stream().filter(event -> {
                Date now = new Date();
                return now.after(event.getStartDate()) && now.before(event.getEndDate());
            }).collect(Collectors.toList());
            if (!activeEvents.isEmpty()) {
                SpecialEvent firstActiveEvent = (SpecialEvent)activeEvents.get(0);
                String encodedContent = Base64.encode((String)firstActiveEvent.getContent());
                String encodedURIContent = EncodingUtil.encodeURIComponent((String)encodedContent);
                if (StringUtils.startsWithIgnoreCase((CharSequence)firstActiveEvent.getContent(), (CharSequence)"http")) {
                    ComponentUtil.preventUrls((Browser)this.webview, (String[])new String[]{".*" + firstActiveEvent.getContent()});
                }
                UISynchronizeService.syncExec(() -> {
                    if (ControlUtil.isDisposed((Widget)this.webview)) {
                        return;
                    }
                    this.webview.setUrl(WebViewController.getInstance().getPage("CreativeStartPage.html?content=" + encodedURIContent));
                });
            }
        }
        catch (SendRequestException | IOException | IllegalArgumentException | org.apache.http.ParseException error) {
            LoggerSingleton.logError((Throwable)error);
        }
    }

    private static void addSpacer(Composite rightComposite) {
        Label spacer = new Label(rightComposite, 0);
        spacer.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    @PreDestroy
    public void onClosed() {
        this.disposeControls();
    }

    private void configureExternalStartPage() {
        if (this.isIntegrateWithKatalonSaas.isEmpty() && this.sessionController.isActivated()) {
            String testOpsUrl = Optional.ofNullable(this.discoveryController.getServerUrl(ServerType.TESTOPS)).orElseGet(() -> "").toLowerCase();
            boolean isOnPrem = !testOpsUrl.endsWith(".katalon.com") && !testOpsUrl.endsWith(".katalon.io");
            boolean isOffline = this.sessionController.getSession().getLicense().isOffline();
            this.isIntegrateWithKatalonSaas = Optional.of(!isOnPrem && !isOffline);
            if (this.isIntegrateWithKatalonSaas.get().booleanValue() && this.remoteFileServerResponse == null) {
                try {
                    this.remoteFileServerResponse = this.getRemoteDomainApi();
                    URL url = new URL(this.remoteFileServerResponse.getWebpage().getUrl());
                    WebViewController.getInstance().setRemoteServerForWebAssetReverseProxy(url);
                    WebViewController.getInstance().startRemoteAssetServer();
                }
                catch (JsonProcessingException | HttpException | MalformedURLException | URISyntaxException e) {
                    this.remoteWebAssetServerError = e;
                    LoggerSingleton.logError((Throwable)e, (String)"Start Proxy web server fails");
                }
            }
        }
    }

    private String getTourParams() {
        UserProfile userProfile = UserProfileHelper.getCurrentProfile();
        int pageId = this.getPageId(userProfile);
        return MessageFormat.format("?id={0}", pageId);
    }

    private Map<String, String> generateHeaders() {
        Session session = this.sessionController.getSession();
        session.getUser();
        String appVersion = About.releaseVersion();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("X-KS-Version", StringUtils.defaultString((String)appVersion));
        headers.put("X-Account-Id", String.valueOf(session.getAccount().getId()));
        headers.put("X-Organization-Id", String.valueOf(session.getOrganization().getId()));
        headers.put("X-KS-Edition", session.getKatalonEdition().getName());
        return headers;
    }

    private RemoteFileServerResponse getRemoteDomainApi() throws HttpException, URISyntaxException, JsonProcessingException, MalformedURLException {
        String baseUrl = this.discoveryController.getServerUrl(ServerType.PLATFORM);
        URIBuilder uriBuilder = new URIBuilder(baseUrl).setPath("v1/user-engagement/start-page/web-url");
        URI uri = uriBuilder.build();
        AuthenticationToken katOneToken = this.sessionController.getSession().getKatOneToken();
        WebPageRequest request = new WebPageRequest();
        StudioAppState studioAppState = new StudioAppState();
        studioAppState.setLocalApiServerUrl(WebViewController.getInstance().getLocalApiServerUrl());
        studioAppState.setCurrentTheme(Optional.ofNullable(this.themeEngine.getActiveTheme().getLabel()).orElse(""));
        request.setAuthToken(katOneToken);
        request.setStudioAppState(studioAppState);
        String body = this.objectMapper.writeValueAsString((Object)request);
        Map<String, String> headers = this.generateHeaders();
        BearerAuthentication authenticate = Authentication.BearerAuthentication((String)katOneToken.getAccessToken());
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).authentication((Authentication)authenticate).proxy(proxyConfig).build();
        com.kms.katalon.network.core.model.HttpResponse response = null;
        response = this.httpClient.jsonPost(uri, body, httpOptions);
        int statusCode = response.getStatusCode();
        if (statusCode >= 400 && statusCode < 500) {
            this.handleError(statusCode, response.getBody());
        } else if (statusCode >= 500 && statusCode < 600) {
            this.handleServerError(statusCode, response.getBody());
        }
        RemoteFileServerResponse serverResponse = (RemoteFileServerResponse)response.json(RemoteFileServerResponse.class);
        return serverResponse;
    }

    private void handleError(int statusCode, String responseBody) throws HttpException {
        throw new InvalidRequestException(this.extractErrorMessage(responseBody), statusCode);
    }

    private void handleServerError(int statusCode, String responseBody) throws HttpException {
        throw new ServerErrorException(this.extractErrorMessage(responseBody), statusCode);
    }

    private String extractErrorMessage(String responseBody) {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode rootNode = objectMapper.readTree(responseBody);
            String message = rootNode.path("message").asText(null);
            if (message != null) {
                return message;
            }
            message = rootNode.path("error_description").asText(null);
            if (message != null) {
                return message;
            }
            return responseBody;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e, (String)"Can not extract error message");
            return responseBody;
        }
    }

    private static class SpecialEvent {
        private String title;
        private String content;
        private Date startDate;
        private Date endDate;

        private SpecialEvent() {
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public void setStartDate(Date startDate) {
            this.startDate = startDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public void setEndDate(Date endDate) {
            this.endDate = endDate;
        }
    }
}

