/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.parts;

import com.kms.katalon.composer.components.event.EventBrokerSingleton;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.parts.WelcomeOnlineRightPart;
import com.kms.katalon.constants.ImageConstants;
import com.kms.katalon.constants.MessageConstants;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class WelcomeRightPart
extends Composite
implements EventHandler {
    private static final Color BACKGROUND_COLOR = ColorUtil.getColor((String)"#FAFAFA");
    private static final Color BLUE_COLOR = ColorUtil.getColor((String)"#00A9FF");
    private static final Color TEXT_COLOR = ColorUtil.getTextBlackColor();
    private static final Color STEP_DESCRIPTION_COLOR = ColorUtil.getColor((String)"#212121");
    private static final String KEY_CONTENT = "CONTENT";
    private static final int FONT_SIZE_SMALL = 10;
    private IEventBroker eventBroker = EventBrokerSingleton.getInstance().getEventBroker();
    private Composite gettingStartedContent = this;
    private Composite testingTypeTabGroup;
    private StackLayout testingTypeStackLayout;
    private CLabel selectedTestingTypeTab;
    private CLabel tabWebUi;
    private CLabel tabMobile;
    private CLabel tabApi;
    private CLabel tabScripting;
    private Composite webUiTabContent;
    private Composite mobileTabContent;
    private Composite apiTabContent;
    private Composite scriptingTabContent;
    private static final SelectionAdapter linkSelectionAdapter = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Program.launch((String)e.text);
        }
    };

    public WelcomeRightPart(Composite parent, int style, String contentLink) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout());
        this.createGettingStatedTabContent();
        this.eventBroker.subscribe("PROJECT/OPENED", (EventHandler)this);
        this.eventBroker.subscribe("WORKSPACE/CREATED", (EventHandler)this);
    }

    private void createControls(String contentLink) {
        try {
            new WelcomeOnlineRightPart(this.gettingStartedContent, contentLink);
        }
        catch (Exception exception) {
            this.createGettingStatedTabContent();
        }
    }

    private void createGettingStatedTabContent() {
        this.createTestingTypeTabHeader();
        this.createTabContentForTestingTypes();
        this.setExtraDataToTestingTypeTabs();
        this.registerListenersForTestingTypeTabs();
        this.setDefaultTestingTypeTabByProjectType();
    }

    private void setDefaultTestingTypeTabByProjectType() {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project != null && project.getType() == ProjectType.WEBSERVICE) {
            this.handleSelectingTestingTypeTab(this.tabApi);
        } else {
            this.handleSelectingTestingTypeTab(this.tabWebUi);
        }
    }

    private void createTestingTypeTabHeader() {
        Composite wrapper = new Composite(this.gettingStartedContent, 0);
        GridLayout glWrapper = new GridLayout(1, false);
        glWrapper.marginTop = 2;
        glWrapper.marginBottom = 2;
        wrapper.setLayout((Layout)glWrapper);
        wrapper.setLayoutData((Object)new GridData(4, 128, true, false));
        this.testingTypeTabGroup = new Composite(wrapper, 0);
        GridLayout glTabGroup = new GridLayout();
        glTabGroup.marginHeight = 0;
        this.testingTypeTabGroup.setLayout((Layout)glTabGroup);
        this.testingTypeTabGroup.setLayoutData((Object)new GridData(0x1000000, 128, true, false));
        this.testingTypeTabGroup.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                Point size = WelcomeRightPart.this.testingTypeTabGroup.getSize();
                gc.setLineWidth(3);
                gc.drawLine(0, size.y, size.x, size.y);
            }
        });
        this.tabWebUi = this.createTestingTypeTab(MessageConstants.TAB_LBL_WEB_UI);
        this.tabApi = this.createTestingTypeTab(MessageConstants.TAB_LBL_API);
        this.tabMobile = this.createTestingTypeTab(MessageConstants.TAB_LBL_MOBILE);
        this.tabScripting = this.createTestingTypeTab(MessageConstants.TAB_LBL_SCRIPTING);
    }

    private CLabel createTestingTypeTab(String text) {
        ++((GridLayout)this.testingTypeTabGroup.getLayout()).numColumns;
        CLabel tabButton = new CLabel(this.testingTypeTabGroup, 0);
        tabButton.setText(text);
        tabButton.setLeftMargin(15);
        tabButton.setRightMargin(15);
        tabButton.setBottomMargin(8);
        tabButton.setCursor(Display.getCurrent().getSystemCursor(21));
        ControlUtils.setFontSize((Control)tabButton, (int)10);
        tabButton.setForeground(ColorUtil.getTextColor());
        return tabButton;
    }

    private void createTabContentForTestingTypes() {
        this.testingTypeStackLayout = new StackLayout();
        Composite contentHolder = new Composite(this.gettingStartedContent, 0);
        contentHolder.setLayout((Layout)this.testingTypeStackLayout);
        contentHolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.webUiTabContent = this.createWebUiTabContent(contentHolder);
        this.mobileTabContent = this.createMobileTabContent(contentHolder);
        this.apiTabContent = this.createApiTabContent(contentHolder);
        this.scriptingTabContent = this.createScriptingTabContent(contentHolder);
    }

    private void setExtraDataToTestingTypeTabs() {
        this.tabWebUi.setData(KEY_CONTENT, (Object)this.webUiTabContent);
        this.tabMobile.setData(KEY_CONTENT, (Object)this.mobileTabContent);
        this.tabApi.setData(KEY_CONTENT, (Object)this.apiTabContent);
        this.tabScripting.setData(KEY_CONTENT, (Object)this.scriptingTabContent);
    }

    private void registerListenersForTestingTypeTabs() {
        this.registerListenersForTestingTypeTab(this.tabWebUi);
        this.registerListenersForTestingTypeTab(this.tabMobile);
        this.registerListenersForTestingTypeTab(this.tabApi);
        this.registerListenersForTestingTypeTab(this.tabScripting);
    }

    private void registerListenersForTestingTypeTab(final CLabel tab) {
        tab.addListener(3, e -> this.handleSelectingTestingTypeTab(tab));
        tab.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                if (tab == WelcomeRightPart.this.selectedTestingTypeTab) {
                    Point size = tab.getSize();
                    tab.setForeground(BLUE_COLOR);
                    gc.setLineWidth(3);
                    gc.drawLine(0, size.y, size.x, size.y);
                } else {
                    Point size = tab.getSize();
                    tab.setForeground(ColorUtil.getTextColor());
                    gc.setLineWidth(3);
                    gc.drawLine(0, size.y, size.x, size.y);
                }
            }
        });
    }

    private void handleSelectingTestingTypeTab(CLabel tab) {
        this.selectedTestingTypeTab = tab;
        Control[] controlArray = this.testingTypeTabGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control testingTypeTab = controlArray[n2];
            testingTypeTab.setForeground(ColorUtil.getTextColor());
            ControlUtils.setFontStyle((Control)testingTypeTab, (int)0, (int)-1);
            testingTypeTab.redraw();
            ++n2;
        }
        tab.setForeground(BLUE_COLOR);
        ControlUtils.setFontToBeBold((Control)tab);
        this.testingTypeStackLayout.topControl = (Composite)tab.getData(KEY_CONTENT);
        this.gettingStartedContent.layout(true, true);
        tab.layout();
    }

    private Composite createWebUiTabContent(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        this.createIntroLink(content, StringConstants.PA_URL_GETTING_STARTED);
        Composite main = new Composite(content, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        main.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.addGettingStartedStep(main, ImageConstants.IMG_STEP_1, MessageConstants.URL_COMMON_STEP_RECORD, ImageConstants.IMG_SCREENSHOT_SCREEN_SHOT_RECORD);
        this.addGettingStartedStep(main, ImageConstants.IMG_STEP_2, MessageConstants.URL_COMMON_STEP_RUN, ImageConstants.IMG_SCREENSHOT_SCREEN_SHOT_RUN);
        this.addGettingStartedStep(main, ImageConstants.IMG_STEP_3, MessageConstants.URL_COMMON_STEP_VIEW_LOGGER, ImageConstants.IMG_SCREENSHOT_SCREEN_SHOT_LOG_VIEWER);
        return content;
    }

    private Composite createMobileTabContent(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        content.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.createIntroLink(content, StringConstants.PA_URL_GETTING_STARTED);
        Composite main = new Composite(content, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        main.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.addGettingStartedStep(main, ImageConstants.IMG_STEP_1, MessageConstants.URL_MOBILE_RECORD, ImageConstants.IMG_SCREEN_SHOT_MOBILE_RECORD);
        if (Platform.getOS().equals("macosx")) {
            this.addGettingStartedStep(main, ImageConstants.IMG_STEP_2, MessageConstants.URL_MOBILE_CONFIG_AND_RECORD_STEP_MAC, ImageConstants.IMG_SCREEN_SHOT_MOBILE_CONFIG_AND_RECORD_STEP);
        } else {
            this.addGettingStartedStep(main, ImageConstants.IMG_STEP_2, MessageConstants.URL_MOBILE_CONFIG_AND_RECORD_STEP_WINDOWS, ImageConstants.IMG_SCREEN_SHOT_MOBILE_CONFIG_AND_RECORD_STEP);
        }
        this.addGettingStartedStep(main, ImageConstants.IMG_STEP_3, MessageConstants.URL_COMMON_STEP_RUN, ImageConstants.IMG_SCREENSHOT_SCREEN_SHOT_RUN);
        this.addGettingStartedStep(main, ImageConstants.IMG_STEP_4, MessageConstants.URL_COMMON_STEP_VIEW_LOGGER, ImageConstants.IMG_SCREEN_SHOT_MOBILE_LOG_VIEWER);
        return content;
    }

    private Composite createApiTabContent(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        content.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.createIntroLink(content, StringConstants.PA_URL_GETTING_STARTED);
        Composite main = new Composite(content, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        main.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.addGettingStartedStep(main, ImageConstants.IMG_STEP_1, MessageConstants.URL_USE_DRAFT_REQUEST, ImageConstants.IMG_SCREEN_SHOT_USE_DRAFT_REQUEST);
        this.addGettingStartedStep(main, ImageConstants.IMG_STEP_2, MessageConstants.URL_SAVE_DRAFT_REQUEST, ImageConstants.IMG_SCREEN_SHOT_SAVE_DRAFT_REQUEST);
        this.addGettingStartedStep(main, ImageConstants.IMG_STEP_3, MessageConstants.URL_USE_WEB_SERVICE_IN_TEST_CASE, ImageConstants.IMG_SCREEN_SHOT_ADD_REQUEST_TO_TEST_CASE);
        this.addGettingStartedStep(main, ImageConstants.IMG_STEP_4, MessageConstants.URL_API_EXECUTE_TEST_CASE, ImageConstants.IMG_SCREENSHOT_SCREEN_SHOT_RUN);
        this.addGettingStartedStep(main, ImageConstants.IMG_STEP_5, MessageConstants.URL_COMMON_STEP_VIEW_LOGGER, ImageConstants.IMG_SCREEN_SHOT_API_LOG_VIEWER);
        return content;
    }

    private Composite createScriptingTabContent(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        content.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.createIntroLink(content, StringConstants.PA_URL_GETTING_STARTED);
        Composite main = new Composite(content, 0);
        main.setLayout((Layout)new GridLayout(1, false));
        main.setLayoutData((Object)new GridData(0x1000000, 4, true, true));
        this.addGettingStartedStep(main, ImageConstants.IMG_SCRIPT_BULLET, MessageConstants.URL_SCRIPT_NEW_TEST_CASE, ImageConstants.IMG_SCREEN_SHOT_SCRIPT_NEW_TEST_CASE);
        this.addGettingStartedStep(main, ImageConstants.IMG_SCRIPT_BULLET, MessageConstants.URL_ADD_OR_IMPORT_KEYWORDS, ImageConstants.IMG_SCREEN_SHOT_ADD_OR_IMPORT_KEYWORDS);
        this.addGettingStartedStep(main, ImageConstants.IMG_SCRIPT_BULLET, MessageConstants.URL_CREATE_TEST_LISTENER, ImageConstants.IMG_SCREEN_SHOT_CREATE_TEST_LISTENER);
        this.addGettingStartedStep(main, ImageConstants.IMG_SCRIPT_BULLET, MessageConstants.URL_BUILD_CMD, ImageConstants.IMG_SCREEN_SHOT_BUILD_CMD);
        return content;
    }

    private void createIntroLink(Composite parent, String link) {
        Link introText = new Link(parent, 0);
        introText.setText(link);
        introText.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        introText.setForeground(TEXT_COLOR);
        introText.setLinkForeground(TEXT_COLOR);
        ControlUtils.setFontStyle((Control)introText, (int)2, (int)10);
        introText.addSelectionListener((SelectionListener)linkSelectionAdapter);
    }

    private void addGettingStartedStep(Composite parent, Image stepNumberImage, String text, Image stepDetailsImage) {
        Composite c = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.marginTop = 25;
        c.setLayout((Layout)gl);
        c.setLayoutData((Object)new GridData(4, 128, true, false));
        Label stepNumber = new Label(c, 0);
        stepNumber.setImage(stepNumberImage);
        stepNumber.setLayoutData((Object)new GridData(4, 0x1000000, false, true));
        Link stepText = new Link(c, 0);
        stepText.setText(text);
        stepText.setForeground(STEP_DESCRIPTION_COLOR);
        stepText.setLinkForeground(BLUE_COLOR);
        stepText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        ControlUtils.setFontStyle((Control)stepText, (int)0, (int)12);
        stepText.addSelectionListener((SelectionListener)linkSelectionAdapter);
        Label stepDetails = new Label(parent, 0);
        stepDetails.setImage(stepDetailsImage);
        GridData ldStepDetails = new GridData(4, 4, true, false);
        ldStepDetails.verticalIndent = 10;
        stepDetails.setLayoutData((Object)ldStepDetails);
    }

    protected void checkSubclass() {
    }

    public void handleEvent(Event event) {
        switch (event.getTopic()) {
            case "PROJECT/OPENED": {
                this.setDefaultTestingTypeTabByProjectType();
                break;
            }
        }
    }

    public void onPartClosed() {
        this.eventBroker.unsubscribe((EventHandler)this);
    }
}

