/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.quickstart;

import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.StyleContext;
import com.kms.katalon.composer.quickstart.BaseQuickStartDialog;
import com.kms.katalon.tracking.service.Trackings;
import com.kms.katalon.util.CommandUtil;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class WelcomeBackDialog
extends BaseQuickStartDialog {
    public WelcomeBackDialog(Shell parentShell) {
        super(parentShell);
    }

    @Override
    protected void createContent(Composite container) {
        Composite content = (Composite)ComponentBuilder.gridContainer((Composite)container).margin(30, 60, 30).gridVerticalSpacing(5).build();
        this.createTitle(content);
        this.createInstructionComposite(content);
        Trackings.trackQuickStartWelcomeBack();
    }

    private void createTitle(Composite parent) {
        ComponentBuilder.label((Composite)parent).marginBottom(30).text("Great to have you back!").fillHorizontal().center().fontSize(16).bold().build();
    }

    private void createInstructionComposite(Composite parent) {
        Composite actions = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)3).fillHorizontal().center().marginTop(20).marginBottom(30).gridHorizontalSpacing(40).build();
        Listener openProjectHandler = event -> {
            this.okPressed();
            CommandUtil.autoHandleExecuteCommand("com.kms.katalon.composer.project.command.open", "Unable to open Project Browser dialog!");
            Trackings.trackQuickStartWelcomeBackOpenProject();
        };
        Listener cloneProjectHandler = event -> {
            this.okPressed();
            CommandUtil.autoHandleExecuteCommand("com.kms.katalon.composer.integration.git.command.clone", "Unable to open Clone Project dialog!");
            Trackings.trackQuickStartWelcomeBackCloneProject();
        };
        Listener createProjectHandler = event -> {
            this.okPressed();
            CommandUtil.autoHandleExecuteCommand("com.kms.katalon.composer.project.command.add", "Unable to open New Project dialog!");
            Trackings.trackQuickStartWelcomeBackNewProject();
        };
        this.createAction(actions, "Open Existing Project", "quick_start/welcome_back_open_project.png", openProjectHandler);
        this.createAction(actions, "Clone Project from Git", "quick_start/welcome_back_clone_project.png", cloneProjectHandler);
        this.createAction(actions, "Create New Project", "quick_start/welcome_back_create_project.png", createProjectHandler);
    }

    private void createAction(Composite parent, String text, String imageKey, Listener onClick) {
        Composite box = (Composite)ComponentBuilder.gridContainer((Composite)parent).marginTop(40).build();
        ComponentBuilder.image((Composite)box, (String)imageKey, (int)100).center().cursorPointer().onClick(onClick).build();
        ComponentBuilder.button((Composite)box).text(text).fillHorizontal().center().primaryButton().color(StyleContext.getColor()).background(ColorUtil.getColor((String)"#F5F5F5")).border().marginTop(20).onClick(onClick).build();
    }

    @Override
    protected boolean canHandleShellCloseEvent() {
        return true;
    }

    @Override
    protected void handleShellCloseEvent() {
        this.okPressed();
    }
}

