/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.update.jobs;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.application.utils.VersionUtil;
import com.kms.katalon.composer.components.impl.util.PlatformUtil;
import com.kms.katalon.composer.update.UpdateComponent;
import com.kms.katalon.composer.update.UpdateException;
import com.kms.katalon.composer.update.UpdateManager;
import com.kms.katalon.composer.update.models.AppInfo;
import com.kms.katalon.composer.update.models.FileInfo;
import com.kms.katalon.composer.update.models.VersionInfo;
import com.kms.katalon.network.apache.services.ApacheHttpClient;
import com.kms.katalon.network.core.model.HttpOptions;
import com.kms.katalon.network.core.model.HttpResponse;
import com.kms.katalon.network.core.model.config.ProxyConfig;
import com.kms.katalon.network.core.model.config.ProxyType;
import com.kms.katalon.network.core.model.exception.HttpException;
import com.kms.katalon.network.core.services.IHttpClient;
import com.kms.katalon.network.core.services.INetworkPreferences;
import com.kms.katalon.preferences.eclipse.service.EclipseNetworkPreferences;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class CheckForUpdatesJob
extends Job
implements UpdateComponent {
    private boolean silenceMode;
    private CheckForUpdateResult updateResult;
    IHttpClient httpClient = ApacheHttpClient.getInstance();
    INetworkPreferences networkPreferences = EclipseNetworkPreferences.getInstance();
    UpdateManager updateManager = this.getUpdateManager();

    public CheckForUpdatesJob(boolean silenceMode) {
        super("Checking for Updates...");
        this.silenceMode = silenceMode;
    }

    public CheckForUpdateResult getUpdateResult() {
        return this.updateResult;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (!this.updateManager.isKsNewVersionNotification()) {
            this.updateResult = this.createResultOfVersionIsControlled();
            return Status.OK_STATUS;
        }
        monitor.beginTask("Checking for Updates...", 100);
        if (VersionUtil.isStagingBuild() || VersionUtil.isDevelopmentBuild()) {
            this.updateResult = new CheckForUpdateResult();
            this.updateResult.setUpdateResult(UpdateResultValue.UP_TO_DATE);
            return Status.OK_STATUS;
        }
        VersionInfo lastestUpdateVersion = null;
        VersionInfo latestLocalVersion = null;
        try {
            lastestUpdateVersion = this.downloadLatestVersionInfo();
            latestLocalVersion = this.updateManager.getLocalLatestVersion();
        }
        catch (UpdateException | IOException exception) {
            this.updateResult = this.applyLegacyMechanism();
            return Status.OK_STATUS;
        }
        String latestVersion = lastestUpdateVersion.getLatestVersion();
        String currentVersion = ApplicationInfo.officialReleaseVersion();
        if (!VersionUtil.isNewer((String)latestVersion, (String)currentVersion) || this.isIgnoredInSilenceMode(lastestUpdateVersion, latestLocalVersion)) {
            this.updateResult = new CheckForUpdateResult();
            this.updateResult.setUpdateResult(UpdateResultValue.UP_TO_DATE);
            return Status.OK_STATUS;
        }
        if (!lastestUpdateVersion.isNewMechanism()) {
            this.updateResult = this.applyLegacyMechanism();
            return Status.OK_STATUS;
        }
        String appliedToUpdateVersions = lastestUpdateVersion.getAppliedVersions();
        if (!VersionUtil.isCurrentVersionAppliedToUpdate((String)currentVersion, (String)latestVersion, (String)appliedToUpdateVersions)) {
            this.updateResult = this.applyLegacyMechanism();
            return Status.OK_STATUS;
        }
        monitor.worked(40);
        try {
            monitor.setTaskName("Fetching new update info...");
            AppInfo latestAppInfo = this.downloadLatestAppInfo(lastestUpdateVersion);
            this.updateManager.saveAppInfo(latestAppInfo);
            monitor.setTaskName("Determining update size...");
            AppInfo currentAppInfo = this.updateManager.getCurrentVersionLocalAppInfo();
            List<FileInfo> newDownloadFiles = this.determineUpdateFiles(currentAppInfo, latestAppInfo);
            this.updateResult = new CheckForUpdateResult();
            this.updateResult.setUpdateResult(UpdateResultValue.NEW_UPDATE_FOUND);
            this.updateResult.setLatestAppInfo(latestAppInfo);
            this.updateResult.setCurrentAppInfo(currentAppInfo);
            this.updateResult.setUpdateFiles(newDownloadFiles);
            this.updateResult.setLatestVersionInfo(lastestUpdateVersion);
            monitor.worked(20);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        catch (InterruptedException interruptedException) {
            IStatus iStatus = Status.CANCEL_STATUS;
            return iStatus;
        }
        catch (UpdateException e) {
            Status status = new Status(4, "com.kms.katalon", "Unable to connect to katalon update server", (Throwable)e);
            return status;
        }
        catch (Exception e) {
            Status status = new Status(4, "com.kms.katalon", "Unable to connect to katalon update server", (Throwable)new UpdateException(e));
            return status;
        }
        finally {
            monitor.done();
        }
    }

    private CheckForUpdateResult applyLegacyMechanism() {
        CheckForUpdateResult updateResult = new CheckForUpdateResult();
        updateResult.setUpdateResult(UpdateResultValue.APPLIED_LEGACY_MECHANISM);
        return updateResult;
    }

    private CheckForUpdateResult createResultOfVersionIsControlled() {
        CheckForUpdateResult updateResult = new CheckForUpdateResult();
        updateResult.setUpdateResult(UpdateResultValue.VERSION_IS_CONTROLLED);
        return updateResult;
    }

    private boolean isIgnoredInSilenceMode(VersionInfo lastestUpdateVersion, VersionInfo localLatestVersion) {
        return this.silenceMode && this.isLatestVersionIgnored(lastestUpdateVersion, localLatestVersion);
    }

    private boolean isLatestVersionIgnored(VersionInfo lastestUpdateVersion, VersionInfo localLatestVersion) {
        return lastestUpdateVersion.getLatestVersion().equals(localLatestVersion.getLatestVersion()) && localLatestVersion.isLatestVersionIgnored();
    }

    private VersionInfo downloadLatestVersionInfo() throws UpdateException {
        String latestVersionUrl = this.updateManager.getLatestVersionUrl();
        HashMap headers = new HashMap();
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).proxy(proxyConfig).build();
        try {
            HttpResponse response = this.httpClient.get(new URI(latestVersionUrl), httpOptions);
            return (VersionInfo)response.json(VersionInfo.class);
        }
        catch (HttpException | URISyntaxException e) {
            throw new UpdateException((Exception)e);
        }
    }

    private AppInfo downloadLatestAppInfo(VersionInfo latestUpdateVersion) throws UpdateException, InterruptedException {
        String latestLocation = this.getLatestUpdateLocation(latestUpdateVersion);
        String latestVersionAppInfoUrl = this.updateManager.getAppInfoVersionUrl(latestLocation, PlatformUtil.getPlatform());
        HashMap headers = new HashMap();
        ProxyConfig proxyConfig = this.networkPreferences.getProxyConfig(ProxyType.AUTHENTICATION);
        HttpOptions httpOptions = new HttpOptions.Builder().headers(headers).proxy(proxyConfig).build();
        try {
            HttpResponse response = this.httpClient.get(new URI(latestVersionAppInfoUrl), httpOptions);
            return (AppInfo)response.json(AppInfo.class);
        }
        catch (HttpException | URISyntaxException e) {
            throw new UpdateException((Exception)e);
        }
    }

    public List<FileInfo> determineUpdateFiles(AppInfo currentAppInfo, AppInfo latestAppInfo) {
        Map<String, FileInfo> latestFileMap = latestAppInfo.getFiles().stream().collect(Collectors.toMap(FileInfo::getLocation, f -> f));
        currentAppInfo.getFiles().forEach(f -> {
            String location = f.getLocation();
            if (latestFileMap.containsKey(location) && f.getHash().equals(((FileInfo)latestFileMap.get(location)).getHash())) {
                latestFileMap.remove(location);
            }
        });
        return new ArrayList<FileInfo>(latestFileMap.values());
    }

    public class CheckForUpdateResult {
        private VersionInfo latestVersionInfo;
        private AppInfo currentAppInfo;
        private AppInfo latestAppInfo;
        private UpdateResultValue updateResult;
        private List<FileInfo> updateFiles;

        public UpdateResultValue getUpdateResult() {
            return this.updateResult;
        }

        private void setUpdateResult(UpdateResultValue updateResult) {
            this.updateResult = updateResult;
        }

        public AppInfo getLatestAppInfo() {
            return this.latestAppInfo;
        }

        private void setLatestAppInfo(AppInfo appInfo) {
            this.latestAppInfo = appInfo;
        }

        public List<FileInfo> getUpdateFiles() {
            return this.updateFiles;
        }

        private void setUpdateFiles(List<FileInfo> updateFiles) {
            this.updateFiles = updateFiles;
        }

        public AppInfo getCurrentAppInfo() {
            return this.currentAppInfo;
        }

        private void setCurrentAppInfo(AppInfo currentAppInfo) {
            this.currentAppInfo = currentAppInfo;
        }

        public VersionInfo getLatestVersionInfo() {
            return this.latestVersionInfo;
        }

        private void setLatestVersionInfo(VersionInfo latestVersion) {
            this.latestVersionInfo = latestVersion;
        }
    }

    public static enum UpdateResultValue {
        UP_TO_DATE,
        NEW_UPDATE_FOUND,
        APPLIED_LEGACY_MECHANISM,
        VERSION_IS_CONTROLLED;

    }
}

