/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver;

import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.logging.LogUtil;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.text.MessageFormat;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;

public class WebViewServer {
    private static final String HTTPS_KEY_PASS = "simulator";
    private static final String HTTPS_KEYSTORE_PATH = "/resources/https.keystore";
    public static final int THREAD_POOL_SIZE = 10;
    public static final int DEFAULT_PORT = 0;
    public static final String DEFAULT_HOST = "127.0.0.1";
    private HttpServer server;
    private InetSocketAddress address;
    private boolean started;

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetSocketAddress address) {
        this.address = address;
    }

    public HttpServer getServer() {
        return this.server;
    }

    public String getHost() {
        return MessageFormat.format("{0}:{1,number,#}", DEFAULT_HOST, this.server.getAddress().getPort());
    }

    public Integer getPort() {
        return this.server.getAddress().getPort();
    }

    public WebViewServer() {
        this(0);
    }

    public WebViewServer(int port) {
        this(new InetSocketAddress(port));
    }

    public WebViewServer(InetSocketAddress address) {
        this.address = address;
    }

    public WebViewServer create() throws IOException, NoSuchAlgorithmException, KeyStoreException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        if (this.address == null) {
            this.address = new InetSocketAddress(0);
        }
        this.server = this.createHttpServer(this.address);
        return this;
    }

    private HttpServer createHttpServer(InetSocketAddress address) throws IOException {
        HttpServer server = HttpServer.create(address, 0);
        server.setExecutor((ThreadPoolExecutor)Executors.newFixedThreadPool(10));
        return server;
    }

    private HttpsServer createHttpsServer(InetSocketAddress address) throws IOException, NoSuchAlgorithmException, KeyStoreException, CertificateException, UnrecoverableKeyException, KeyManagementException {
        HttpsServer server = HttpsServer.create(address, 0);
        server.setExecutor((ThreadPoolExecutor)Executors.newFixedThreadPool(10));
        SSLContext sslContext = SSLContext.getInstance("TLS");
        char[] password = HTTPS_KEY_PASS.toCharArray();
        KeyStore keyStore = KeyStore.getInstance("JKS");
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(HTTPS_KEYSTORE_PATH);
        keyStore.load(inputStream, password);
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        keyManagerFactory.init(keyStore, password);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        trustManagerFactory.init(keyStore);
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        server.setHttpsConfigurator(new HttpsConfigurator(sslContext){

            @Override
            public void configure(HttpsParameters params) {
                try {
                    SSLContext defaultContext = SSLContext.getDefault();
                    SSLEngine engine = defaultContext.createSSLEngine();
                    params.setNeedClientAuth(false);
                    params.setCipherSuites(engine.getEnabledCipherSuites());
                    params.setProtocols(engine.getEnabledProtocols());
                    SSLParameters defaultSSLParameters = defaultContext.getDefaultSSLParameters();
                    params.setSSLParameters(defaultSSLParameters);
                }
                catch (Exception error) {
                    LogUtil.logError((String)"Failed to create HTTPS server");
                    LogUtil.logError((Throwable)error);
                }
            }
        });
        return server;
    }

    public WebViewServer use(String path, HttpHandler handler) throws IOException, UnrecoverableKeyException, KeyManagementException, NoSuchAlgorithmException, KeyStoreException, CertificateException {
        if (this.server == null) {
            this.create();
        }
        if (this.server == null) {
            return this;
        }
        this.server.createContext(path, handler);
        return this;
    }

    public WebViewServer start() {
        this.server.start();
        this.started = true;
        LogUtil.logInfo((String)MessageFormat.format("WebView Server has been started on port {0,number,#}", this.server.getAddress().getPort()));
        return this;
    }

    public WebViewServer startAsync() {
        UISynchronizeService.asyncExec(() -> this.start());
        return this;
    }

    public WebViewServer stop() {
        this.server.stop(0);
        this.started = false;
        return this;
    }

    public WebViewServer stopAsync() {
        UISynchronizeService.asyncExec(() -> this.stop());
        return this;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void ensureStarted() {
        if (!this.isStarted()) {
            this.start();
        }
    }
}

