/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver.handlers;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.constants.StringConstants;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.webservice.common.HttpUtil;
import com.kms.katalon.core.webservice.exception.SendRequestException;
import com.kms.katalon.execution.preferences.ProxyPreferences;
import com.kms.katalon.webserver.CustomHttpHandler;
import com.kms.katalon.webserver.CustomRequest;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class KatalonContentHandler
extends CustomHttpHandler {
    @Override
    public void customHandle(CustomRequest req) throws IOException {
        if (this.handlePrefightRequestAndCORS(req)) {
            return;
        }
        String url = req.query("url");
        if (StringUtils.isNotBlank((CharSequence)url)) {
            try {
                String content = null;
                if (StringUtils.startsWith((CharSequence)url, (CharSequence)StringConstants.KATALON_FORUM_URL)) {
                    try {
                        content = this.fetchFromForum(url, false);
                    }
                    catch (URISyntaxException | GeneralSecurityException error) {
                        try {
                            content = this.fetchFromForum(url, true);
                        }
                        catch (URISyntaxException | GeneralSecurityException exception) {
                            LoggerSingleton.logError((Throwable)error);
                        }
                    }
                    req.setHeader("Content-Type", "application/json");
                } else {
                    content = this.fetch(url);
                }
                req.send(content);
            }
            catch (IOException error) {
                LoggerSingleton.logError((Throwable)error);
                req.end();
            }
        }
    }

    private String fetchFromForum(String url, boolean useProxy) throws URISyntaxException, MalformedURLException, IOException, GeneralSecurityException {
        URI uri = new URI(url);
        HttpGet httpPost = new HttpGet(uri);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-type", "application/json");
        httpPost.setHeader("Api-Key", StringConstants.KATALON_FORUM_TOKEN);
        httpPost.setHeader("Api-Username", StringConstants.KATALON_FORUM_USERNAME);
        ProxyInformation authProxy = ProxyPreferences.getAuthProxyInformation();
        return useProxy ? this.fetch((HttpUriRequest)httpPost, authProxy) : this.fetch((HttpUriRequest)httpPost);
    }

    private String fetch(String url) throws IOException {
        HttpGet request = new HttpGet(url);
        return this.fetch((HttpUriRequest)request);
    }

    private String fetch(HttpUriRequest request) throws IOException {
        return this.fetch(request, null);
    }

    private String fetch(HttpUriRequest request, ProxyInformation proxy) throws IOException {
        HttpResponse response;
        try {
            response = HttpUtil.sendRequest((HttpUriRequest)request, (ProxyInformation)proxy);
        }
        catch (SendRequestException error) {
            LoggerSingleton.logError((Throwable)error);
            return null;
        }
        return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
    }
}

