/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver.handlers;

import com.kms.katalon.ai.core.dto.StudioAssistRejectAnswerRequest;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.webserver.CustomHttpHandler;
import com.kms.katalon.webserver.CustomRequest;
import jakarta.inject.Inject;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioAssistChatRejectAnswerHandler
extends CustomHttpHandler {
    private final Logger logger = LoggerFactory.getLogger(StudioAssistChatRejectAnswerHandler.class);
    @Inject
    private IEventBroker eventBroker;

    @Override
    public void customHandle(CustomRequest req) throws IOException {
        String requestDataAsString = req.getRequestDataAsString();
        try {
            StudioAssistRejectAnswerRequest request = (StudioAssistRejectAnswerRequest)JsonUtil.fromJson((String)"EEE MMM dd HH:mm:ss zzz yyyy", (String)requestDataAsString, StudioAssistRejectAnswerRequest.class);
            if (!this.validate(req, request)) {
                this.logger.debug("validate failed | request = %s".formatted(JsonUtil.toJson((Object)request)));
                return;
            }
            this.eventBroker.post("ON_CHAT_REJECT_ANSWER", (Object)request);
            req.end();
        }
        catch (Exception e) {
            this.logger.error("Exception while handle reject answer | %s | %s".formatted(requestDataAsString, e.getMessage()), (Throwable)e);
            req.sendResponseHeaders(500, -1);
        }
    }

    private boolean validate(CustomRequest req, StudioAssistRejectAnswerRequest request) throws IOException {
        if (request == null || StringUtils.isBlank((CharSequence)request.getConversationId()) || StringUtils.isBlank((CharSequence)request.getQuestionMsgId()) || StringUtils.isBlank((CharSequence)request.getQuestionContent()) || StringUtils.isBlank((CharSequence)request.getAnswerContent())) {
            req.sendResponseHeaders(400, -1);
            return false;
        }
        return true;
    }
}

