/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.webserver.handlers;

import com.kms.katalon.ai.core.dto.StudioAssistToolCallRequest;
import com.kms.katalon.core.util.internal.JsonUtil;
import com.kms.katalon.webserver.CustomHttpHandler;
import com.kms.katalon.webserver.CustomRequest;
import jakarta.inject.Inject;
import java.io.IOException;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StudioAssistToolCallHandler
extends CustomHttpHandler {
    private static final Logger logger = LoggerFactory.getLogger(StudioAssistToolCallHandler.class);
    @Inject
    private IEventBroker eventBroker;

    @Override
    public void customHandle(CustomRequest req) throws IOException {
        try {
            StudioAssistToolCallRequest toolCallRequest = (StudioAssistToolCallRequest)JsonUtil.fromJson((String)req.getRequestDataAsString(), StudioAssistToolCallRequest.class);
            switch (toolCallRequest.getAction()) {
                case APPROVE_TOOL_CALL: {
                    this.eventBroker.post("ON_STUDIO_ASSIST_APPROVE_TOOL_CALL", (Object)toolCallRequest);
                    break;
                }
                case DENY_TOOL_CALL: {
                    this.eventBroker.post("ON_STUDIO_ASSIST_DENY_TOOL_CALL", (Object)toolCallRequest);
                    break;
                }
                case ACKNOWLEDGE_MAXED_TOOL_CALL: {
                    this.eventBroker.post("ON_STUDIO_ASSIST_ACKNOWLEDGE_MAXED_TOOL_CALL", (Object)toolCallRequest);
                    break;
                }
                case REJECT_MAXED_TOOL_CALL: {
                    this.eventBroker.post("ON_STUDIO_ASSIST_REJECT_MAXED_TOOL_CALL", (Object)toolCallRequest);
                    break;
                }
            }
            req.end();
        }
        catch (Exception e) {
            logger.error("Exception while handling tool call request | %s".formatted(e.getMessage()), (Throwable)e);
            req.sendResponseHeaders(400, -1);
        }
    }
}

