/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codebrowsing.fragments;

import java.util.Objects;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentFactory;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentKind;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.EmptyASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.FragmentVisitor;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.SimpleExpressionASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.selection.IsSameExpression;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;

public class PropertyExpressionFragment
implements IASTFragment {
    private final ASTFragmentKind kind;
    private final Expression expression;
    private final IASTFragment next;

    PropertyExpressionFragment(ASTFragmentKind kind, Expression expression, IASTFragment next) {
        this.kind = kind;
        this.expression = expression;
        this.next = Objects.requireNonNull(next);
    }

    @Override
    public Expression getAssociatedExpression() {
        return this.expression;
    }

    @Override
    public ASTNode getAssociatedNode() {
        return this.expression;
    }

    @Override
    public int getEnd() {
        return this.getNext().getEnd();
    }

    @Override
    public int getStart() {
        return this.expression.getStart();
    }

    @Override
    public int getLength() {
        return this.getEnd() - this.getStart();
    }

    @Override
    public int getTrimmedEnd(GroovyCompilationUnit unit) {
        return this.getNext().getTrimmedEnd(unit);
    }

    @Override
    public int getTrimmedLength(GroovyCompilationUnit unit) {
        return this.getTrimmedEnd(unit) - this.getStart();
    }

    public IASTFragment getNext() {
        return this.next;
    }

    @Override
    public boolean matches(IASTFragment that) {
        if (that == this) {
            return true;
        }
        if (that == null || !(that instanceof PropertyExpressionFragment)) {
            return false;
        }
        PropertyExpressionFragment propertyFragment = (PropertyExpressionFragment)that;
        return propertyFragment.kind() == this.kind && new IsSameExpression().isSame(this.expression, propertyFragment.getAssociatedExpression()) && this.next.matches(propertyFragment.getNext());
    }

    public String toString() {
        return this.print(0);
    }

    @Override
    public String print(int indentLvl) {
        return ASTFragmentFactory.spaces(indentLvl) + "(P) " + this.expression.toString() + "\n" + this.next.print(indentLvl + 1);
    }

    @Override
    public int fragmentLength() {
        return 1 + this.next.fragmentLength();
    }

    @Override
    public void accept(FragmentVisitor visitor) {
        if (visitor.previsit(this) && visitor.visit(this)) {
            this.next.accept(visitor);
        }
    }

    @Override
    public ASTFragmentKind kind() {
        return this.kind;
    }

    @Override
    public IASTFragment findMatchingSubFragment(IASTFragment other) {
        if (this.fragmentLength() < other.fragmentLength()) {
            return new EmptyASTFragment();
        }
        if (other.kind() == ASTFragmentKind.SIMPLE_EXPRESSION && new IsSameExpression().isSame(this.getAssociatedExpression(), other.getAssociatedExpression())) {
            return new SimpleExpressionASTFragment(this.expression);
        }
        if (other.kind() == this.kind()) {
            PropertyExpressionFragment toMatchBinary = (PropertyExpressionFragment)other;
            if (new IsSameExpression().isSame(this.getAssociatedExpression(), toMatchBinary.getAssociatedExpression())) {
                IASTFragment result = this.getNext().findMatchingSubFragment(toMatchBinary.getNext());
                if (result.kind() == ASTFragmentKind.EMPTY) {
                    return new EmptyASTFragment();
                }
                return new PropertyExpressionFragment(this.kind(), this.getAssociatedExpression(), result);
            }
        }
        return new EmptyASTFragment();
    }
}

