/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.codebrowsing.requestor;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.util.VisitCompleteException;
import org.eclipse.jdt.groovy.core.util.ArrayUtils;
import org.eclipse.jdt.groovy.core.util.DepthFirstVisitor;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;

public class ASTNodeFinder
extends DepthFirstVisitor {
    protected ModuleNode module;
    protected ASTNode result;
    protected Region sloc;
    private static final Pattern EXTENDS_ = Pattern.compile("\\bextends\\s+");
    private static final Pattern IMPLEMENTS_ = Pattern.compile("\\bimplements\\s+");
    private static final Pattern _IMPLEMENTS = Pattern.compile("\\s+implements\\b");

    public ASTNodeFinder(Region sloc) {
        this.sloc = sloc;
    }

    public ASTNode doVisit(ModuleNode node) {
        this.module = node;
        this.result = null;
        try {
            this.visitModule(node);
        }
        catch (VisitCompleteException visitCompleteException) {
            // empty catch block
        }
        return this.result;
    }

    public void visitPackage(PackageNode node) {
        super.visitPackage(node);
        this.check((ASTNode)node);
    }

    public void visitImport(ImportNode node) {
        if (node.getType() != null) {
            this.check((ASTNode)node.getType());
        }
        super.visitImport(node);
        this.check((ASTNode)node);
    }

    public void visitClass(ClassNode node) {
        if (node.getNameEnd() > 0) {
            this.checkNameRange((AnnotatedNode)node);
            this.checkHeader(node);
        }
        super.visitClass(node);
    }

    public void visitField(FieldNode node) {
        if (node.getNameEnd() > 0) {
            this.checkNameRange((AnnotatedNode)node);
        }
        super.visitField(node);
        int start = node.getStart();
        int annos = node.getAnnotations().size();
        if (annos > 0) {
            start = GroovyUtils.lastElement((AnnotationNode)((AnnotationNode)node.getAnnotations().get(annos - 1))).getEnd() + 1;
        }
        if (start > 0 && !node.isEnum()) {
            this.check((ASTNode)node.getType(), start, node.getEnd() - node.getName().length());
        }
    }

    public void visitMethod(MethodNode node) {
        if (node == this.runMethod) {
            return;
        }
        if (node.getEnd() > 0) {
            ClassNode returnType;
            if (ASTNodeFinder.isNotEmpty((Object[])node.getGenericsTypes())) {
                this.checkGenerics(node.getGenericsTypes());
            }
            if ((returnType = node.getReturnType()) != null) {
                int offset = -1;
                if (returnType.getEnd() < 1) {
                    ASTNode last = (ASTNode)ArrayUtils.lastElement((Object[])node.getGenericsTypes());
                    if (last != null) {
                        offset = last.getEnd() + 1;
                    } else if (!node.getAnnotations().isEmpty()) {
                        int i = node.getAnnotations().size() - 1;
                        while (i >= 0) {
                            int end = GroovyUtils.lastElement((AnnotationNode)((AnnotationNode)node.getAnnotations().get(i))).getEnd() + 1;
                            if (end > 0) {
                                offset = end;
                                break;
                            }
                            --i;
                        }
                    }
                }
                this.check((ASTNode)returnType, Math.max(offset, node.getStart()), node.getNameStart() - 1);
            }
            if (node.getNameEnd() > 0) {
                this.checkNameRange((AnnotatedNode)node);
            }
            this.checkTypes(node.getExceptions());
        }
        super.visitMethod(node);
    }

    public void visitArrayExpression(ArrayExpression expression) {
        if (expression.getEnd() > 0) {
            this.check((ASTNode)GroovyUtils.getBaseType((ClassNode)expression.getType()), expression.getNameStart(), expression.getNameEnd() + 1);
        }
        super.visitArrayExpression(expression);
    }

    public void visitCastExpression(CastExpression expression) {
        if (expression.getEnd() > 0) {
            this.check((ASTNode)expression.getType(), expression.getNameStart(), expression.getNameEnd());
        }
        super.visitCastExpression(expression);
    }

    public void visitClassExpression(ClassExpression expression) {
        if (expression.getEnd() > 0 && expression.getStart() == expression.getType().getStart()) {
            this.check((ASTNode)expression.getType());
        }
        super.visitClassExpression(expression);
    }

    public void visitConstantExpression(ConstantExpression expression) {
        if (expression instanceof AnnotationConstantExpression) {
            this.check((ASTNode)expression.getType());
        }
        super.visitConstantExpression(expression);
    }

    public void visitVariableExpression(VariableExpression expression) {
        if (expression == expression.getAccessedVariable() || expression.getName().charAt(0) == '$') {
            int until = expression.getStart() - 1;
            int start = Math.max(0, until - expression.getOriginType().getName().length() - 1);
            if (until > 0) {
                this.check((ASTNode)expression.getOriginType(), start, until);
            }
        }
        super.visitVariableExpression(expression);
    }

    public void visitDeclarationExpression(DeclarationExpression expression) {
        if (expression.isMultipleAssignmentDeclaration() && expression.getStart() < expression.getTupleExpression().getStart()) {
            this.visitAnnotations(expression.getAnnotations());
            this.check((ASTNode)expression.getType(), expression.getStart(), expression.getTupleExpression().getStart());
        }
        super.visitDeclarationExpression(expression);
    }

    public void visitConstructorCallExpression(ConstructorCallExpression call) {
        if (call.getEnd() > 0) {
            if (call.getNameStart() > 0) {
                if (call.isUsingAnonymousInnerClass()) {
                    this.check((ASTNode)call.getType().getUnresolvedSuperClass(false));
                    this.checkTypes(call.getType().getUnresolvedInterfaces(false));
                } else {
                    this.checkNameRange((AnnotatedNode)call);
                    this.checkGenerics(call.getType());
                }
            } else {
                try {
                    int start = call.getStart() + "new ".length();
                    int until = call.getArguments().getStart() - 1;
                    this.check((ASTNode)call.getType(), start, until);
                }
                catch (VisitCompleteException e) {
                    this.result = call;
                    throw e;
                }
            }
            if (call.getStart() == call.getType().getStart() && !call.isUsingAnonymousInnerClass()) {
                this.check((ASTNode)call.getType());
            }
        }
        super.visitConstructorCallExpression(call);
    }

    public void visitMethodCallExpression(MethodCallExpression call) {
        if (call.isUsingGenerics()) {
            this.checkGenerics(call.getGenericsTypes());
        }
        super.visitMethodCallExpression(call);
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression call) {
        if (call.getOwnerType() != call.getOwnerType().redirect()) {
            this.check((ASTNode)call.getOwnerType());
        }
        super.visitStaticMethodCallExpression(call);
    }

    public void visitArgumentlistExpression(ArgumentListExpression expression) {
        this.visitAnnotations(expression.getAnnotations());
        Iterator arguments = expression.iterator();
        if (arguments.hasNext()) {
            Expression first = (Expression)arguments.next();
            if (!(first instanceof MapExpression) || first.getEnd() != expression.getEnd()) {
                first.visit((GroovyCodeVisitor)this);
                first = null;
            }
            while (arguments.hasNext()) {
                ((Expression)arguments.next()).visit((GroovyCodeVisitor)this);
            }
            if (first != null) {
                first.visit((GroovyCodeVisitor)this);
            }
        }
        this.visitExpression((Expression)expression);
    }

    protected void visitAnnotation(AnnotationNode annotation) {
        if (this.sloc.regionIsCoveredByNode((ASTNode)annotation)) {
            this.check((ASTNode)annotation.getClassNode());
            int start = annotation.getClassNode().getEnd() + 1;
            for (Map.Entry pair : annotation.getMembers().entrySet()) {
                String name = (String)pair.getKey();
                Expression expr = (Expression)pair.getValue();
                Expression orig = (Expression)expr.getNodeMetaData((Object)"OriginalExpression");
                this.check((ASTNode)GroovyUtils.getAnnotationMethod((AnnotationNode)annotation, (String)name), start, (orig != null ? orig : expr).getStart() - 1);
                start = expr.getEnd() + 1;
            }
            super.visitAnnotation(annotation);
        }
    }

    protected void visitExpression(Expression expression) {
        super.visitExpression(expression);
        this.check((ASTNode)expression);
    }

    protected void visitParameter(Parameter parameter) {
        super.visitParameter(parameter);
        AnnotationNode ann = (AnnotationNode)parameter.getNodeMetaData((Object)"met@");
        if (ann != null) {
            this.visitAnnotation(ann);
        }
        if (parameter.getEnd() > 0) {
            this.checkNameRange((AnnotatedNode)parameter);
            int start = parameter.getStart();
            int until = parameter.getNameStart() - 1;
            this.check((ASTNode)parameter.getOriginType(), start, until);
        }
    }

    protected void visitStatement(Statement statement) {
        super.visitStatement(statement);
        if (!(statement instanceof BlockStatement) && !(statement instanceof ExpressionStatement)) {
            this.check((ASTNode)statement);
        }
    }

    protected void check(ASTNode node) {
        if (node instanceof ClassNode) {
            ClassNode type = (ClassNode)node;
            this.visitAnnotations(type.getTypeAnnotations());
            if (type.isArray()) {
                this.check((ASTNode)type.getComponentType(), node.getStart(), node.getEnd() - 2);
            } else if (!type.isGenericsPlaceHolder() && (type.isRedirectNode() || !type.isResolved() && !type.isPrimaryClassNode())) {
                this.checkGenerics(type);
            }
        }
        if (node.getEnd() > 0 && this.sloc.regionIsCoveredByNode(node)) {
            this.completeVisitation(node, null);
        }
    }

    protected void check(ASTNode node, int start, int until) {
        if (node != null && node.getEnd() > 0) {
            this.check(node);
        } else {
            if (node instanceof ClassNode) {
                ClassNode type = (ClassNode)node;
                this.visitAnnotations(type.getTypeAnnotations());
                if (!type.isGenericsPlaceHolder() && (type.isRedirectNode() || !type.isResolved() && !type.isPrimaryClassNode())) {
                    this.checkGenerics(type);
                }
            }
            if (this.sloc.getOffset() >= start && this.sloc.getEnd() <= until) {
                this.completeVisitation(node, new Region(start, until - start));
            }
        }
    }

    protected void checkNameRange(AnnotatedNode node) {
        if (this.sloc.regionIsCoveredByNameRange(node)) {
            this.completeVisitation((ASTNode)node, new Region(node.getNameStart(), node.getNameEnd() + 1 - node.getNameStart()));
        }
        if (node instanceof ClassNode) {
            this.checkGenerics((ClassNode)node);
        }
    }

    private void checkHeader(ClassNode node) {
        Object[] superTypes;
        String name;
        String source;
        if (this.sloc.getOffset() <= node.getNameEnd()) {
            return;
        }
        if (GroovyUtils.isAnonymous((ClassNode)node)) {
            return;
        }
        GenericsType type = (GenericsType)ArrayUtils.lastElement((Object[])node.getGenericsTypes());
        int offset = type != null ? type.getEnd() : node.getNameEnd() + 1;
        String src = null;
        try {
            src = this.readClassDeclaration(node);
            source = src.substring(offset - node.getStart());
        }
        catch (Exception err) {
            GroovyCore.logException((String)String.format("Error checking super-types at offset %d in file / index %d of:%n%s%n%s", offset, offset - node.getStart(), src, node), (Throwable)err);
            return;
        }
        ClassNode superClass = node.getUnresolvedSuperClass();
        if (superClass != null && source.indexOf(name = GroovyUtils.splitName((ClassNode)superClass)[1]) > 0) {
            int a = ASTNodeFinder.endIndexOf(source, EXTENDS_);
            int b = ASTNodeFinder.indexOf(source, _IMPLEMENTS);
            if (b < 0) {
                b = source.length();
            }
            this.check((ASTNode)superClass, offset + a, offset + b);
        }
        if (ASTNodeFinder.isNotEmpty((Object[])(superTypes = node.getUnresolvedInterfaces()))) {
            int i = 0;
            int n = superTypes.length;
            while (i < n) {
                String name2 = GroovyUtils.splitName((ClassNode)superTypes[i])[1];
                if (source.indexOf(name2) > 0) {
                    char c;
                    int a = ASTNodeFinder.endIndexOf(source, IMPLEMENTS_);
                    int b = source.length();
                    int j = i - 1;
                    while (j >= 0) {
                        if (superTypes[j].getEnd() > 0) {
                            a = superTypes[j].getEnd() - offset;
                            while ((c = source.charAt(a)) == ',' || Character.isWhitespace(c)) {
                                ++a;
                            }
                            break;
                        }
                        --j;
                    }
                    j = i + 1;
                    while (j < n) {
                        if (superTypes[j].getStart() > 0) {
                            b = superTypes[j].getStart() - 1 - offset;
                            while ((c = source.charAt(b - 1)) == ',' || Character.isWhitespace(c)) {
                                --b;
                            }
                            break;
                        }
                        ++j;
                    }
                    this.check((ASTNode)superTypes[i], offset + a, offset + b);
                }
                ++i;
            }
        }
        List subTypes = node.getPermittedSubclasses();
        int i = 0;
        int n = subTypes.size();
        while (i < n) {
            String name3 = GroovyUtils.splitName((ClassNode)((ClassNode)subTypes.get(i)))[1];
            if (source.indexOf(name3) > 0) {
                char c;
                int a = ASTNodeFinder.endIndexOf(source, Pattern.compile("\\bpermits\\s+"));
                int b = source.length();
                int j = i - 1;
                while (j >= 0) {
                    if (((ClassNode)subTypes.get(j)).getEnd() > 0) {
                        a = ((ClassNode)subTypes.get(j)).getEnd() - offset;
                        while ((c = source.charAt(a)) == ',' || Character.isWhitespace(c)) {
                            ++a;
                        }
                        break;
                    }
                    --j;
                }
                j = i + 1;
                while (j < n) {
                    if (((ClassNode)subTypes.get(j)).getStart() > 0) {
                        b = ((ClassNode)subTypes.get(j)).getStart() - 1 - offset;
                        while ((c = source.charAt(b - 1)) == ',' || Character.isWhitespace(c)) {
                            --b;
                        }
                        break;
                    }
                    ++j;
                }
                this.check((ASTNode)subTypes.get(i), offset + a, offset + b);
            }
            ++i;
        }
    }

    private void checkTypes(ClassNode[] nodes) {
        if (ASTNodeFinder.isNotEmpty((Object[])nodes)) {
            ClassNode[] classNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                ClassNode node = classNodeArray[n2];
                this.check((ASTNode)node);
                ++n2;
            }
        }
    }

    private void checkGenerics(ClassNode node) {
        if (ASTNodeFinder.isNotEmpty((Object[])node.getGenericsTypes()) && !node.isEnum()) {
            this.checkGenerics(node.getGenericsTypes());
        }
    }

    private void checkGenerics(GenericsType[] generics) {
        GenericsType[] genericsTypeArray = generics;
        int n = generics.length;
        int n2 = 0;
        while (n2 < n) {
            GenericsType generic = genericsTypeArray[n2];
            int start = generic.getStart();
            int until = start + generic.getName().length();
            if (!generic.isWildcard()) {
                this.check((ASTNode)generic.getType(), start, until);
            } else {
                this.visitAnnotations(generic.getType().getTypeAnnotations());
            }
            start = until + 1;
            until = generic.getEnd();
            if (generic.getLowerBound() != null) {
                this.check((ASTNode)generic.getLowerBound(), start += "super ".length(), until);
            } else if (generic.getUpperBounds() != null) {
                start += "extends ".length();
                ClassNode[] classNodeArray = generic.getUpperBounds();
                int n3 = classNodeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    ClassNode upper = classNodeArray[n4];
                    String name = upper.getName();
                    this.check((ASTNode)upper, start, Math.min(start + name.length(), until));
                    if (upper.getEnd() > 0) {
                        start = upper.getEnd() + 1;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    protected final void completeVisitation(ASTNode node, Region sloc) throws VisitCompleteException {
        this.result = node;
        if (sloc != null) {
            this.sloc = sloc;
        }
        throw new VisitCompleteException();
    }

    private String readClassDeclaration(ClassNode node) {
        String code = (String)node.getNodeMetaData((Object)"groovy.source", x -> String.valueOf(this.module.getContext().readSourceRange(node.getStart(), node.getLength())));
        return code.substring(0, code.indexOf(123, node.getNameEnd() - node.getStart()));
    }

    private static int endIndexOf(String s, Pattern p) {
        Matcher m = p.matcher(s);
        if (m.find()) {
            return m.start() + m.group().length();
        }
        return -1;
    }

    private static int indexOf(String s, Pattern p) {
        Matcher m = p.matcher(s);
        if (m.find()) {
            return m.start();
        }
        return -1;
    }
}

