/*
 * Decompiled with CFR 0.152.
 */
package atu.testrecorder;

import atu.testrecorder.exceptions.ATUTestRecorderException;
import atu.testrecorder.media.MovieWriter;
import atu.testrecorder.media.avi.AVIWriter;
import atu.testrecorder.media.color.Colors;
import atu.testrecorder.media.image.Images;
import atu.testrecorder.media.quicktime.QuickTimeWriter;
import java.awt.AWTException;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;

public class ATUTestRecorder {
    private CursorEnum cursor;
    private String format;
    private int depth = 24;
    private MovieWriter w;
    private long startTime;
    private long time;
    private float screenRate = 15.0f;
    private float mouseRate = 30.0f;
    private int aviSyncInterval = (int)(Math.max(this.screenRate, this.mouseRate) * 60.0f);
    private int qtSyncInterval = (int)Math.max(this.screenRate, this.mouseRate);
    private long maxFrameDuration = 1000L;
    private Robot robot;
    private Rectangle rect;
    private BufferedImage screenCapture;
    private List<MouseCapture> mouseCaptures;
    private BufferedImage videoImg;
    private Graphics2D videoGraphics;
    private ScheduledThreadPoolExecutor screenTimer;
    private ScheduledThreadPoolExecutor mouseTimer;
    private BufferedImage cursorImg;
    private Point cursorOffset = new Point(-8, -5);
    private final Object sync = new Object();
    private float audioRate;
    private Thread audioRunner;
    private AudioFormat audioFormat;
    private String recordingName = "";
    private String recordingRootDirectiry = "";

    public ATUTestRecorder(Boolean isAudioRecordingEnabled) throws ATUTestRecorderException {
        try {
            this.recorder(this.recordingRootDirectiry, this.recordingName, isAudioRecordingEnabled);
        }
        catch (AWTException e) {
            throw new ATUTestRecorderException(e.getMessage());
        }
        catch (IOException e) {
            throw new ATUTestRecorderException(e.getMessage());
        }
    }

    public ATUTestRecorder(String recordingName, Boolean isAudioRecordingEnabled) throws ATUTestRecorderException {
        this.recordingName = recordingName;
        this.recordingRootDirectiry = "";
        try {
            this.recorder(this.recordingRootDirectiry, recordingName, isAudioRecordingEnabled);
        }
        catch (AWTException e) {
            throw new ATUTestRecorderException(e.getMessage());
        }
        catch (IOException e) {
            throw new ATUTestRecorderException(e.getMessage());
        }
    }

    public ATUTestRecorder(String recordingRootDirectiry, String recordingName, Boolean isAudioRecordingEnabled) throws ATUTestRecorderException {
        this.recordingName = recordingName;
        this.recordingRootDirectiry = recordingRootDirectiry;
        try {
            this.recorder(recordingRootDirectiry, recordingName, isAudioRecordingEnabled);
        }
        catch (AWTException e) {
            throw new ATUTestRecorderException(e.getMessage());
        }
        catch (IOException e) {
            throw new ATUTestRecorderException(e.getMessage());
        }
    }

    private void recorder(String recordingRootDirectiry, String recordingName, Boolean isAudioRecordingEnabled) throws IOException, AWTException {
        Window window = new Window(null);
        GraphicsConfiguration cfg = window.getGraphicsConfiguration();
        this.format = "QuickTime";
        this.depth = 24;
        this.cursor = CursorEnum.WHITE;
        this.screenRate = 15.0f;
        this.mouseRate = 30.0f;
        this.audioRate = isAudioRecordingEnabled != false ? 44100.0f : 0.0f;
        this.aviSyncInterval = (int)(Math.max(this.screenRate, this.mouseRate) * 60.0f);
        this.qtSyncInterval = (int)Math.max(this.screenRate, this.mouseRate);
        this.rect = cfg.getBounds();
        this.robot = new Robot(cfg.getDevice());
        if (this.depth == 24) {
            this.videoImg = new BufferedImage(this.rect.width, this.rect.height, 1);
        } else if (this.depth == 16) {
            this.videoImg = new BufferedImage(this.rect.width, this.rect.height, 9);
        } else if (this.depth == 8) {
            this.videoImg = new BufferedImage(this.rect.width, this.rect.height, 13, Colors.createMacColors());
        } else {
            throw new IOException("Unsupported color depth " + this.depth);
        }
        this.videoGraphics = this.videoImg.createGraphics();
        this.videoGraphics.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        this.videoGraphics.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        this.videoGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        this.mouseCaptures = Collections.synchronizedList(new LinkedList());
        this.cursorImg = this.cursor == CursorEnum.BLACK ? Images.toBufferedImage(Images.createImage(ATUTestRecorder.class, "/atu/testrecorder/media/images/Cursor.black.png")) : Images.toBufferedImage(Images.createImage(ATUTestRecorder.class, "/atu/testrecorder/media/images/Cursor.white.png"));
        this.createMovieWriter(recordingRootDirectiry, recordingName);
    }

    protected void createMovieWriter(String recordingRootDirectiry, String recordingName) throws IOException {
        File folder;
        if (recordingRootDirectiry == null) {
            recordingRootDirectiry = "";
        }
        File recordingRootDir = new File(recordingRootDirectiry);
        if (recordingName == null) {
            recordingName = "";
        }
        if (recordingRootDirectiry.trim() == "") {
            folder = new File("." + File.separator);
        } else {
            if (!recordingRootDir.exists()) {
                throw new IOException("Directory \"" + recordingRootDir + "\" does not exist.");
            }
            if (!recordingRootDir.isDirectory()) {
                throw new IOException("\"" + recordingRootDir + "\" is not a directory.");
            }
            folder = new File(String.valueOf(recordingRootDirectiry) + File.separator);
        }
        if (!folder.exists()) {
            folder.mkdirs();
        } else if (!folder.isDirectory()) {
            throw new IOException("\"" + folder + "\" is not a directory.");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd 'at' HH.mm.ss");
        if (this.format.equals("AVI")) {
            AVIWriter aviw = new AVIWriter(new File(folder, "ScreenRecording " + dateFormat.format(new Date()) + ".avi"));
            this.w = aviw;
            aviw.addVideoTrack(AVIWriter.VIDEO_SCREEN_CAPTURE, 1L, (long)((int)this.mouseRate), this.rect.width, this.rect.height, this.depth, this.aviSyncInterval);
            if (this.depth == 8) {
                aviw.setPalette(0, (IndexColorModel)this.videoImg.getColorModel());
            }
        } else if (this.format.equals("QuickTime")) {
            QuickTimeWriter qtw = new QuickTimeWriter(new File(folder, String.valueOf(recordingName) + ".mov"));
            this.w = qtw;
            qtw.addVideoTrack(QuickTimeWriter.VIDEO_ANIMATION, 1000L, this.rect.width, this.rect.height, this.depth, this.qtSyncInterval);
            if (this.audioRate > 0.0f) {
                this.audioFormat = new AudioFormat(this.audioRate, 16, 1, true, true);
                qtw.addAudioTrack(this.audioFormat);
            }
            if (this.depth == 8) {
                qtw.setVideoColorTable(0, (IndexColorModel)this.videoImg.getColorModel());
            }
        } else {
            throw new IOException("Unsupported format " + this.format);
        }
    }

    public void start() throws ATUTestRecorderException {
        this.startTime = this.time = System.currentTimeMillis();
        this.screenTimer = new ScheduledThreadPoolExecutor(1);
        this.screenTimer.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    ATUTestRecorder.this.grabScreen();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }, (int)(1000.0f / this.screenRate), (int)(1000.0f / this.screenRate), TimeUnit.MILLISECONDS);
        this.mouseTimer = new ScheduledThreadPoolExecutor(1);
        this.mouseTimer.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ATUTestRecorder.this.grabMouse();
            }
        }, (int)(1000.0f / this.mouseRate), (int)(1000.0f / this.mouseRate), TimeUnit.MILLISECONDS);
        if (this.audioRate > 0.0f && this.w instanceof QuickTimeWriter) {
            try {
                this.startAudio();
            }
            catch (LineUnavailableException e) {
                throw new ATUTestRecorderException(e.getMessage());
            }
        }
    }

    private void startAudio() throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, this.audioFormat);
        final TargetDataLine line = (TargetDataLine)AudioSystem.getLine(info);
        line.open(this.audioFormat);
        line.start();
        final int bufferSize = this.audioFormat.getFrameSize() != -1 ? (int)this.audioFormat.getSampleRate() * this.audioFormat.getFrameSize() : (int)this.audioFormat.getSampleRate();
        this.audioRunner = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block10: {
                    byte[] buffer = new byte[bufferSize];
                    block8: while (true) {
                        try {
                            while (ATUTestRecorder.this.audioRunner == this) {
                                int count = line.read(buffer, 0, buffer.length);
                                if (count <= 0) continue;
                                Object object = ATUTestRecorder.this.sync;
                                synchronized (object) {
                                    int sampleCount = count * 8 / ATUTestRecorder.this.audioFormat.getSampleSizeInBits();
                                    ATUTestRecorder.this.w.writeSamples(1, sampleCount, buffer, 0, count, 1L, true);
                                    continue block8;
                                }
                            }
                            break block10;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            line.close();
                            return;
                        }
                    }
                    finally {
                        line.close();
                    }
                }
            }
        };
        this.audioRunner.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws ATUTestRecorderException {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e1) {
            throw new ATUTestRecorderException(e1.getMessage());
        }
        this.mouseTimer.shutdown();
        this.screenTimer.shutdown();
        Thread T = this.audioRunner;
        this.audioRunner = null;
        try {
            this.mouseTimer.awaitTermination((int)(1000.0f / this.mouseRate), TimeUnit.MILLISECONDS);
            this.screenTimer.awaitTermination((int)(1000.0f / this.screenRate), TimeUnit.MILLISECONDS);
            if (T != null) {
                T.join();
            }
        }
        catch (InterruptedException e) {
            throw new ATUTestRecorderException(e.getMessage());
        }
        Object object = this.sync;
        synchronized (object) {
            try {
                this.w.close();
            }
            catch (IOException e) {
                throw new ATUTestRecorderException(e.getMessage());
            }
            this.w = null;
        }
        this.videoGraphics.dispose();
        this.videoImg.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grabScreen() throws IOException {
        this.screenCapture = this.robot.createScreenCapture(new Rectangle(0, 0, this.rect.width, this.rect.height));
        long now = System.currentTimeMillis();
        this.videoGraphics.drawImage((Image)this.screenCapture, 0, 0, null);
        boolean hasMouseCapture = false;
        if (this.cursor != CursorEnum.NONE) {
            Point previous = new Point(Integer.MAX_VALUE, Integer.MAX_VALUE);
            while (!this.mouseCaptures.isEmpty() && this.mouseCaptures.get((int)0).time < now) {
                MouseCapture pc = this.mouseCaptures.remove(0);
                if (pc.time <= this.time) continue;
                hasMouseCapture = true;
                Point p = pc.p;
                p.x -= this.rect.x;
                p.y -= this.rect.y;
                Object object = this.sync;
                synchronized (object) {
                    if (!this.w.isVFRSupported() || p.x != previous.x || p.y != previous.y || pc.time - this.time > this.maxFrameDuration) {
                        previous.x = p.x;
                        previous.y = p.y;
                        this.videoGraphics.drawImage((Image)this.cursorImg, p.x + this.cursorOffset.x, p.y + this.cursorOffset.y, null);
                        if (this.w == null) {
                            return;
                        }
                        try {
                            this.w.writeFrame(0, this.videoImg, (int)(pc.time - this.time));
                        }
                        catch (Throwable t) {
                            throw new IllegalStateException("ATU TestRecorder Error");
                        }
                        this.time = pc.time;
                        this.videoGraphics.drawImage(this.screenCapture, p.x + this.cursorOffset.x, p.y + this.cursorOffset.y, p.x + this.cursorOffset.x + this.cursorImg.getWidth() - 1, p.y + this.cursorOffset.y + this.cursorImg.getHeight() - 1, p.x + this.cursorOffset.x, p.y + this.cursorOffset.y, p.x + this.cursorOffset.x + this.cursorImg.getWidth() - 1, p.y + this.cursorOffset.y + this.cursorImg.getHeight() - 1, null);
                    }
                }
            }
        }
        if (!hasMouseCapture) {
            if (this.cursor != CursorEnum.NONE) {
                PointerInfo info = MouseInfo.getPointerInfo();
                Point p = info.getLocation();
                this.videoGraphics.drawImage((Image)this.cursorImg, p.x + this.cursorOffset.x, p.x + this.cursorOffset.y, null);
            }
            Object object = this.sync;
            synchronized (object) {
                this.w.writeFrame(0, this.videoImg, (int)(now - this.time));
            }
            this.time = now;
        }
    }

    private void grabMouse() {
        long now = System.currentTimeMillis();
        PointerInfo info = MouseInfo.getPointerInfo();
        this.mouseCaptures.add(new MouseCapture(now, info.getLocation()));
    }

    private static enum CursorEnum {
        BLACK,
        WHITE,
        NONE;

    }

    private static class MouseCapture {
        public long time;
        public Point p;

        public MouseCapture(long time, Point p) {
            this.time = time;
            this.p = p;
        }
    }
}

