/*
 * Decompiled with CFR 0.152.
 */
package atu.testrecorder.media;

import atu.testrecorder.media.AbstractCodec;
import atu.testrecorder.media.Buffer;
import atu.testrecorder.media.VideoFormat;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;

public abstract class AbstractVideoCodec
extends AbstractCodec {
    private BufferedImage imgConverter;
    private byte[] byteBuf = new byte[4];

    protected byte[] getIndexed8(Buffer buf) {
        BufferedImage image;
        if (buf.data instanceof byte[]) {
            return (byte[])buf.data;
        }
        if (buf.data instanceof BufferedImage && (image = (BufferedImage)buf.data).getRaster().getDataBuffer() instanceof DataBufferByte) {
            return ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        }
        return null;
    }

    protected short[] getRGB15(Buffer buf) {
        if (buf.data instanceof int[]) {
            return (short[])buf.data;
        }
        if (buf.data instanceof BufferedImage) {
            BufferedImage image = (BufferedImage)buf.data;
            if (image.getColorModel() instanceof DirectColorModel) {
                DirectColorModel dcm = (DirectColorModel)image.getColorModel();
                if (image.getRaster().getDataBuffer() instanceof DataBufferShort) {
                    return ((DataBufferShort)image.getRaster().getDataBuffer()).getData();
                }
                if (image.getRaster().getDataBuffer() instanceof DataBufferUShort) {
                    return ((DataBufferUShort)image.getRaster().getDataBuffer()).getData();
                }
            }
            if (this.imgConverter == null) {
                int width = ((VideoFormat)this.outputFormat).getWidth();
                int height = ((VideoFormat)this.outputFormat).getHeight();
                this.imgConverter = new BufferedImage(width, height, 9);
            }
            Graphics2D g = this.imgConverter.createGraphics();
            g.drawImage((Image)image, 0, 0, null);
            g.dispose();
            return ((DataBufferShort)this.imgConverter.getRaster().getDataBuffer()).getData();
        }
        return null;
    }

    protected int[] getRGB24(Buffer buf) {
        if (buf.data instanceof int[]) {
            return (int[])buf.data;
        }
        if (buf.data instanceof BufferedImage) {
            DirectColorModel dcm;
            BufferedImage image = (BufferedImage)buf.data;
            if (image.getColorModel() instanceof DirectColorModel && (dcm = (DirectColorModel)image.getColorModel()).getBlueMask() == 255 && dcm.getGreenMask() == 65280 && dcm.getRedMask() == 0xFF0000 && image.getRaster().getDataBuffer() instanceof DataBufferInt) {
                return ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
            }
            VideoFormat vf = (VideoFormat)this.outputFormat;
            return image.getRGB(0, 0, vf.getWidth(), vf.getHeight(), null, 0, vf.getWidth());
        }
        return null;
    }

    protected int[] getARGB32(Buffer buf) {
        if (buf.data instanceof int[]) {
            return (int[])buf.data;
        }
        if (buf.data instanceof BufferedImage) {
            DirectColorModel dcm;
            BufferedImage image = (BufferedImage)buf.data;
            if (image.getColorModel() instanceof DirectColorModel && (dcm = (DirectColorModel)image.getColorModel()).getBlueMask() == 255 && dcm.getGreenMask() == 65280 && dcm.getRedMask() == 0xFF0000 && image.getRaster().getDataBuffer() instanceof DataBufferInt) {
                return ((DataBufferInt)image.getRaster().getDataBuffer()).getData();
            }
            VideoFormat vf = (VideoFormat)this.outputFormat;
            return image.getRGB(0, 0, vf.getWidth(), vf.getHeight(), null, 0, vf.getWidth());
        }
        return null;
    }

    protected BufferedImage getBufferedImage(Buffer buf) {
        if (buf.data instanceof BufferedImage) {
            return (BufferedImage)buf.data;
        }
        return null;
    }

    protected void writeInt24(ImageOutputStream out, int v) throws IOException {
        this.byteBuf[0] = (byte)(v >>> 16);
        this.byteBuf[1] = (byte)(v >>> 8);
        this.byteBuf[2] = (byte)(v >>> 0);
        out.write(this.byteBuf, 0, 3);
    }

    protected void writeInt24LE(ImageOutputStream out, int v) throws IOException {
        this.byteBuf[2] = (byte)(v >>> 16);
        this.byteBuf[1] = (byte)(v >>> 8);
        this.byteBuf[0] = (byte)(v >>> 0);
        out.write(this.byteBuf, 0, 3);
    }

    protected void writeInts24(ImageOutputStream out, int[] i, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > i.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!");
        }
        byte[] b = new byte[len * 3];
        int boff = 0;
        int j = 0;
        while (j < len) {
            int v = i[off + j];
            b[boff++] = (byte)(v >>> 16);
            b[boff++] = (byte)(v >>> 8);
            b[boff++] = (byte)(v >>> 0);
            ++j;
        }
        out.write(b, 0, len * 3);
    }

    protected void writeInts24LE(ImageOutputStream out, int[] i, int off, int len) throws IOException {
        if (off < 0 || len < 0 || off + len > i.length || off + len < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!");
        }
        byte[] b = new byte[len * 3];
        int boff = 0;
        int j = 0;
        while (j < len) {
            int v = i[off + j];
            b[boff++] = (byte)(v >>> 0);
            b[boff++] = (byte)(v >>> 8);
            b[boff++] = (byte)(v >>> 16);
            ++j;
        }
        out.write(b, 0, len * 3);
    }
}

