/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public final class HttpAcceptUtils {
    public static List<String> splitAcceptHeader(@Nullable String acceptHeaderValue) {
        if (StringUtils.isBlank((CharSequence)acceptHeaderValue)) {
            return ImmutableList.of();
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder currentValue = new StringBuilder();
        boolean inQuotedValue = false;
        for (int i = 0; i < acceptHeaderValue.length(); ++i) {
            char c = acceptHeaderValue.charAt(i);
            if (c == ',' && !inQuotedValue) {
                result.add(currentValue.toString().trim());
                currentValue = new StringBuilder();
                continue;
            }
            if (c == '\"') {
                inQuotedValue = !inQuotedValue;
            }
            currentValue.append(c);
        }
        result.add(currentValue.toString().trim());
        return result;
    }

    private HttpAcceptUtils() {
    }
}

