/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;

public class ValidationReportUtils {
    private ValidationReportUtils() {
    }

    public static void replaceReportOutput(JsonNode reportInput, String searchRegex, String replaceString) {
        ObjectNode schemaObject;
        if (reportInput.isArray()) {
            reportInput.forEach(it -> ValidationReportUtils.replaceReportOutput(it, searchRegex, replaceString));
            return;
        }
        if (!reportInput.isObject()) {
            return;
        }
        if (reportInput.has("reports") && reportInput.get("reports").isObject()) {
            ObjectNode reportsAsJson = (ObjectNode)reportInput.get("reports");
            ArrayList<String> propertiesToModify = new ArrayList<String>();
            reportsAsJson.fields().forEachRemaining(it -> {
                String reportFieldName = (String)it.getKey();
                JsonNode reportValue = (JsonNode)it.getValue();
                ValidationReportUtils.replaceReportOutput(reportValue, searchRegex, replaceString);
                if (reportFieldName.contains(searchRegex)) {
                    propertiesToModify.add(reportFieldName);
                }
            });
            propertiesToModify.forEach(reportFieldName -> {
                String replacementFieldName = reportFieldName.replaceAll(searchRegex, replaceString);
                if (!reportsAsJson.has(replacementFieldName)) {
                    reportsAsJson.set(replacementFieldName, reportsAsJson.get(reportFieldName));
                    reportsAsJson.remove(reportFieldName);
                }
            });
        }
        if (reportInput.has("schema") && reportInput.get("schema").isObject() && (schemaObject = (ObjectNode)reportInput.get("schema")).has("pointer")) {
            schemaObject.put("pointer", schemaObject.get("pointer").textValue().replaceAll(searchRegex, replaceString));
        }
    }
}

