/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oai.validator.whitelist.rule;

import com.atlassian.oai.validator.model.ApiOperation;
import com.atlassian.oai.validator.model.Request;
import com.atlassian.oai.validator.model.Response;
import com.atlassian.oai.validator.report.ValidationReport;
import com.atlassian.oai.validator.whitelist.rule.RequestOrResponseWhitelistRule;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import java.util.Objects;
import javax.annotation.Nullable;

class IsEntityWhitelistRule
implements RequestOrResponseWhitelistRule {
    private final String entityName;

    @Override
    public boolean matches(ValidationReport.Message message, ApiOperation operation, Request request) {
        if (operation == null || operation.getOperation().getRequestBody() == null) {
            return false;
        }
        RequestBody apiRequestBody = operation.getOperation().getRequestBody();
        return apiRequestBody.getContent().values().stream().map(MediaType::getSchema).filter(Objects::nonNull).map(Schema::get$ref).filter(Objects::nonNull).anyMatch($ref -> $ref.endsWith("/" + this.entityName));
    }

    @Override
    public boolean matches(ValidationReport.Message message, ApiOperation operation, Response response) {
        if (operation == null || operation.getOperation().getResponses() == null) {
            return false;
        }
        ApiResponse apiResponse = this.getApiResponse(response, operation);
        if (apiResponse == null || apiResponse.getContent() == null) {
            return false;
        }
        return apiResponse.getContent().values().stream().map(MediaType::getSchema).filter(Objects::nonNull).map(Schema::get$ref).filter(Objects::nonNull).anyMatch($ref -> $ref.endsWith("/" + this.entityName));
    }

    public String toString() {
        return "Is entity: " + this.entityName;
    }

    public IsEntityWhitelistRule(String entityName) {
        this.entityName = Objects.requireNonNull(entityName);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IsEntityWhitelistRule that = (IsEntityWhitelistRule)o;
        return Objects.equals(this.getEntityName(), that.getEntityName());
    }

    public int hashCode() {
        return Objects.hash(this.getEntityName());
    }

    @Nullable
    private ApiResponse getApiResponse(Response response, ApiOperation apiOperation) {
        ApiResponse apiResponse = (ApiResponse)apiOperation.getOperation().getResponses().get((Object)Integer.toString(response.getStatus()));
        if (apiResponse == null) {
            return apiOperation.getOperation().getResponses().getDefault();
        }
        return apiResponse;
    }
}

