package com.kms.katalon.core.common;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Objects;

import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.context.internal.InternalTestCaseContext;
import com.kms.katalon.core.context.internal.InternalTestSuiteContext;
import com.kms.katalon.core.driver.internal.DriverCleanerCollector;
import com.kms.katalon.core.logging.ErrorCollector;
import com.kms.katalon.core.main.ScriptEngine;
import com.kms.katalon.core.main.TestCaseExecutor;
import com.kms.katalon.core.main.TestResult;
import com.kms.katalon.core.model.FailureHandling;
import com.kms.katalon.core.testcase.TestCaseBinding;

import groovy.lang.Binding;

public abstract class CommonExecutor {
    public void setStatusTestSuiteContext(InternalTestSuiteContext testSuiteContext) {
        String status = "COMPLETE";
        if (ErrorCollector.getCollector().containsErrors()) {
            status = "ERROR";
        }
        testSuiteContext.setStatus(status);
    }

    public void cleanDriver() {
        if (RunConfiguration.shouldTerminateDriverAfterTestSuite()) {
            DriverCleanerCollector.getInstance().cleanDrivers();
        }
    }

    public void accessTestCaseMainPhaseLoop(ScriptEngine scriptEngine, TestCaseBinding testCaseBinding) {

        Map<String, Object> values = testCaseBinding.getBindedValues() != null ? testCaseBinding.getBindedValues()
                : new HashMap<>();
        Map<String, Object> bindedValues = new HashMap<>();

        scriptEngine.changeConfigForCollectingVariable();
        for (Entry<String, Object> entry : values.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            try {
                Object runScript = scriptEngine.runScriptWithoutLogging(value != null ? value.toString() : null,
                        new Binding());
                bindedValues.put(key, runScript);
            } catch (Exception e) {
                bindedValues.put(key, value);
            }
        }
        testCaseBinding.setBindedValues(bindedValues);
    }

    public TestResult accessTestCaseMainPhase(int index, TestCaseBinding tcBinding) {
        ErrorCollector errorCollector = ErrorCollector.getCollector();
        List<Throwable> coppiedErrors = errorCollector.getCoppiedErrors();
        errorCollector.clearErrors();

        try {
            var bindedVal = tcBinding.getBindedValues() == null ? ""
                    : tcBinding.getBindedValues().getOrDefault(tcBinding.getIterationVariableName(), "");
            var getIterationVariableValue = Objects.toString(bindedVal);

            InternalTestCaseContext testCaseContext = new InternalTestCaseContext(tcBinding.getTestCaseId(), index,
                    tcBinding.getTestCaseName(), getIterationVariableValue);
            TestCaseExecutor testCaseExecutor = accessTestCaseMainPhaseBody(tcBinding, testCaseContext);
            return testCaseExecutor.execute(FailureHandling.STOP_ON_FAILURE);
        } finally {
            errorCollector.clearErrors();
            errorCollector.getErrors().addAll(coppiedErrors);
        }
    }

    public abstract TestCaseExecutor accessTestCaseMainPhaseBody(TestCaseBinding tcBinding,
            InternalTestCaseContext testCaseContext);
}
