package com.kms.katalon.core.enums.windows;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

public enum LocatorStrategy {
    ACCESSIBILITY_ID("Accessibility ID"), 
    CLASS_NAME("Class Name"), 
    NAME("Name"), 
    TAG_NAME("Tag Name"), 
    XPATH("XPATH");

    private final String locatorStrategy;

    private LocatorStrategy(String locatorStrategy) {
        this.locatorStrategy = locatorStrategy;
    }

    public String getLocatorStrategy() {
        return locatorStrategy;
    }

    public static String[] getStrategies() {
        List<String> strategies = new ArrayList<>();
        for (LocatorStrategy str : values()) {
            strategies.add(str.getLocatorStrategy());
        }
        return strategies.toArray(new String[0]);
    }

    public static LocatorStrategy valueOfStrategy(String strategy) {
        if (StringUtils.isEmpty(strategy)) {
            return null;
        }
        for (LocatorStrategy str : values()) {
            if (str.getLocatorStrategy().equals(strategy)) {
                return str;
            }
        }
        throw new IllegalArgumentException("Strategy: " + strategy + " not found");
    }
}
