package com.kms.katalon.core.helper.screenrecorder;

public enum VideoFileCodec {
    H264("H264", "libx264"), VP9("VP9", "libvpx-vp9");
	
    private String name;

    private String value;

    private VideoFileCodec(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.format("%s (%s)", getName(), getValue());
    }
    
    public static VideoFileCodec getDefaultCodec(VideoFileFormat format) {
        return switch (format) {
            case MP4, AVI, MOV -> VideoFileCodec.H264;
//            case WEBM -> VideoFileCodec.VP9;
            default -> VideoFileCodec.H264; // Default to H264 for unknown formats
        };
    }
}
