package com.kms.katalon.core.logging.model;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import org.apache.commons.text.StringEscapeUtils;

import com.kms.katalon.core.util.ObjectUtil;

/**
 * This class is used to group multiple test execution results into a single result.
 * Used in Report Part.
 */
public class TestCaseGroupLogRecord extends TestCaseLogRecord {

    private int indexInReport = -1;
    
    private TestSuiteLogRecord testSuiteLogRecord;

    public TestCaseGroupLogRecord(TestSuiteLogRecord testSuiteLogRecord, ILogRecord firstRecord, int index) {
        super(firstRecord.getName());
        this.testSuiteLogRecord = testSuiteLogRecord;
        setType(ILogRecord.LOG_TYPE_TEST_CASE);
        if (firstRecord != null) {
            ObjectUtil.clone(firstRecord, this);
            setChildRecords(new ILogRecord[] {});
            addChildRecord(firstRecord);
            setParentLogRecord(null);
            if (firstRecord instanceof AbstractLogRecord) {
                AbstractLogRecord firstAbstractLogRecord = (AbstractLogRecord) firstRecord;
                super.setProperties(firstAbstractLogRecord.getProperties());
            }
        }
        this.setIndexInReport(index);
    }

    @Override
    public ILogRecord[] getChildRecords() {
        return childRecords.stream().filter(logRecord -> logRecord instanceof TestCaseLogRecord).map(logRecord -> {
            logRecord.setDescription(StringEscapeUtils.unescapeJava(logRecord.getDescription()));
            return logRecord;
        }).collect(Collectors.toList()).toArray(new ILogRecord[] {});
    }

    @Override
    public long getStartTime() {
        return !childRecords.isEmpty() ? getLastLogRecord().getStartTime() : 0;
    }

    @Override
    public long getEndTime() {
        return !childRecords.isEmpty() ? getLastLogRecord().getEndTime() : 0;
    }

    @Override
    public TestStatus getStatus() {
        return !childRecords.isEmpty() ? getLastLogRecord().getStatus() : null;
    }

    public TestCaseLogRecord getLastLogRecord() {
        return (TestCaseLogRecord) childRecords.get(childRecords.size() - 1);
    }

    @Override
    public Map<String, String> getProperties() {
        return !childRecords.isEmpty() ? getLastLogRecord().getProperties() : null;
    }

    public int getIndexInReport() {
        return indexInReport;
    }

    public void setIndexInReport(int indexInReport) {
        this.indexInReport = indexInReport;
    }

    @Override
    public int hashCode() {
        return indexInReport;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TestCaseGroupLogRecord)) {
            return false;
        }
        TestCaseGroupLogRecord other = (TestCaseGroupLogRecord) obj;
        return indexInReport == other.indexInReport;
    }

    public TestSuiteLogRecord getTestSuiteLogRecord() {
        return testSuiteLogRecord;
    }

    public void setTestSuiteLogRecord(TestSuiteLogRecord testSuiteLogRecord) {
        this.testSuiteLogRecord = testSuiteLogRecord;
    }
}
