package com.kms.katalon.core.model.internal;

import java.util.List;

/**
 * @apiNote **INTERNAL USE ONLY.** Do not use this class in client code.
 */
public class MobilePlatformExecutionSettings {

    public MobilePlatformExecutionSettings() {
        super();
    }

    // Element timeout
    private int elementTimeoutInSeconds;

    // Action delay (per keyword)
    private int actionDelayInMillis;

    private List<String> actionDelayAffectedKeywords;

    // appium:newCommandTimeout
    private int newCommandTimeoutInSeconds;

    // Self-healing feature
    private boolean enableSelfHealing;

    public int getElementTimeoutInSeconds() {
        return elementTimeoutInSeconds;
    }

    public void setElementTimeoutInSeconds(int elementTimeoutInSeconds) {
        this.elementTimeoutInSeconds = elementTimeoutInSeconds;
    }

    public int getActionDelayInMillis() {
        return actionDelayInMillis;
    }

    public void setActionDelayInMillis(int actionDelayInMillis) {
        this.actionDelayInMillis = actionDelayInMillis;
    }

    public List<String> getActionDelayAffectedKeywords() {
        return actionDelayAffectedKeywords;
    }

    public void setActionDelayAffectedKeywords(List<String> actionDelayAffectedKeywords) {
        this.actionDelayAffectedKeywords = actionDelayAffectedKeywords;
    }

    public int getNewCommandTimeoutInSeconds() {
        return newCommandTimeoutInSeconds;
    }

    public void setNewCommandTimeoutInSeconds(int newCommandTimeoutInSeconds) {
        this.newCommandTimeoutInSeconds = newCommandTimeoutInSeconds;
    }

    public boolean isEnableSelfHealing() {
        return enableSelfHealing;
    }

    public void setEnableSelfHealing(boolean enableSelfHealing) {
        this.enableSelfHealing = enableSelfHealing;
    }

    public static class Builder {
        
        private int elementTimeoutInSeconds;

        private int actionDelayInMillis;

        private List<String> actionDelayAffectedKeywords;

        private int newCommandTimeoutInSeconds;

        private boolean enableSelfHealing;

        public Builder() {
        }

        public Builder elementTimeoutInSeconds(int elementTimeoutInSeconds) {
            this.elementTimeoutInSeconds = elementTimeoutInSeconds;
            return this;
        }

        public Builder actionDelayInMillis(int actionDelayInMillis) {
            this.actionDelayInMillis = actionDelayInMillis;
            return this;
        }

        public Builder actionDelayAffectedKeywords(List<String> actionDelayAffectedKeywords) {
            this.actionDelayAffectedKeywords = actionDelayAffectedKeywords;
            return this;
        }

        public Builder newCommandTimeoutInSeconds(int newCommandTimeoutInSeconds) {
            this.newCommandTimeoutInSeconds = newCommandTimeoutInSeconds;
            return this;
        }

        public Builder enableSelfHealing(boolean enableSelfHealing) {
            this.enableSelfHealing = enableSelfHealing;
            return this;
        }

        public MobilePlatformExecutionSettings build() {
            MobilePlatformExecutionSettings executionSettings = new MobilePlatformExecutionSettings();
            executionSettings.setElementTimeoutInSeconds(elementTimeoutInSeconds);
            executionSettings.setActionDelayInMillis(actionDelayInMillis);
            executionSettings.setActionDelayAffectedKeywords(actionDelayAffectedKeywords);
            executionSettings.setNewCommandTimeoutInSeconds(newCommandTimeoutInSeconds);
            executionSettings.setEnableSelfHealing(enableSelfHealing);
            return executionSettings;
        }
    }
}
