package com.kms.katalon.core.reporting.newreport.extractor;

import java.util.Optional;

import org.apache.commons.lang3.StringUtils;

public class FullMessageExtractor implements IFailureReasonExtractor {

    private static final int MAX_MESSAGE_LENGTH = 1000;
    private static final String TRUNCATION_SUFFIX = "... (truncated)";

    @Override
    public Optional<String> extract(String message) {
        if (StringUtils.isBlank(message)) {
            return Optional.empty();
        }

        String trimmed = message.trim();

        // Truncate if too long
        if (trimmed.length() > MAX_MESSAGE_LENGTH) {
            int truncateAt = MAX_MESSAGE_LENGTH - TRUNCATION_SUFFIX.length();
            trimmed = trimmed.substring(0, truncateAt) + TRUNCATION_SUFFIX;
        }

        return Optional.of(trimmed);
    }
}
