package com.kms.katalon.core.reporting.util;

import java.io.FileOutputStream;
import java.io.IOException;

import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.multipdf.PDFMergerUtility.DocumentMergeMode;

public class PDFUtils {
    public static void mergePDFs(String output, String... inputs) throws IOException {
        try (var outputStream = new FileOutputStream(output)) {
            PDFMergerUtility pdfMergerUtility = new PDFMergerUtility();
            pdfMergerUtility.setDestinationStream(outputStream);
            pdfMergerUtility.setDocumentMergeMode(DocumentMergeMode.PDFBOX_LEGACY_MODE); // To keep the outline
            for (var input : inputs) {
                pdfMergerUtility.addSource(input);
            }
            pdfMergerUtility.mergeDocuments(null);
        }
    }
}
