package com.kms.katalon.core.testobject.authorization;

public enum OAuth2GrantType {
    AUTHORIZATION_CODE("Authorization Code"),
    CLIENT_CREDENTIALS("Client Credentials"),
    PASSWORD_CREDENTIALS("Password Credentials"),
    REFRESH_TOKEN("Refresh Token");

    private final String displayName;

    OAuth2GrantType(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return displayName;
    }

    public static OAuth2GrantType fromDisplayName(String displayName) {
        for (OAuth2GrantType type : values()) {
            if (type.getDisplayName().equals(displayName)) {
                return type;
            }
        }
        
        try {
            return valueOf(displayName);
        } catch (IllegalArgumentException e) {
            // If neither works, throw a descriptive error
            throw new IllegalArgumentException("Unknown grant type display name: " + displayName);
        }
    }
}
