package com.kms.katalon.core.util.internal;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

import com.kms.katalon.util.DocumentBuilderProvider;
import com.kms.katalon.util.TransformerFactoryProvider;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

public class XMLUtil {
    private static final Pattern SOAPPatternEnvelope = Pattern.compile(":Envelope>?");
    
    private static final Pattern SOAPPatternBody = Pattern.compile(":Body>?");
    private XMLUtil() {
        // Hide the default constructor
    }

    public static boolean isValidXml(String xml) {
        try {
            DocumentBuilder dBuilder = DocumentBuilderProvider.newBuilderInstance();
            Document doc = dBuilder.parse(new InputSource(new StringReader(xml)));
            return doc != null;
        } catch (SAXException | IOException | ParserConfigurationException error) {
            return false;
        }
    }
    
    public static boolean isSOAP(String xml) {
        Matcher SOAPEnvMatcher = SOAPPatternEnvelope.matcher(xml);
        Matcher SOAPBodyMatcher = SOAPPatternBody.matcher(xml);
        return SOAPEnvMatcher.find() && SOAPBodyMatcher.find();
    }
    
    public static String extractSOAPBodyAsContent(String xml) {
        try {
            DocumentBuilder db = DocumentBuilderProvider.newBuilderInstance();
            Document doc = db.parse(new InputSource(new StringReader(xml)));
            XPath xPath = XPathFactory.newInstance().newXPath();
            NodeList nodes = (NodeList) xPath.evaluate("/*/*/*", doc, XPathConstants.NODESET);
            if (nodes.getLength() > 0) {
                // Body root node always at the last
                Node lastNode = nodes.item(nodes.getLength() - 1);
                Document newDoc = db.newDocument();
                Element rootElement = (Element) newDoc.importNode(lastNode, true);
                newDoc.appendChild(rootElement);
                DOMSource domSource = new DOMSource(newDoc);
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                TransformerFactory tf = TransformerFactoryProvider.newInstance();
                Transformer transformer = tf.newTransformer();
                transformer.setOutputProperty(OutputKeys.INDENT, "yes");
                transformer.transform(domSource, result);
                return writer.toString();
            }
            return xml;
        } catch (Exception e) {
            // ignore
        }
        return xml;
    }
}
