package com.kms.katalon.core.webservice.keyword;

import com.atlassian.oai.validator.model.Request
import com.kms.katalon.core.annotation.Keyword
import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.exception.StepErrorException
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.BuiltinKeywords
import com.kms.katalon.core.keyword.internal.KeywordExecutor
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.testobject.RequestObject
import com.kms.katalon.core.testobject.ResponseObject
import com.kms.katalon.core.testobject.ValidationTarget
import com.kms.katalon.core.webservice.constants.StringConstants

import groovy.transform.CompileStatic

@CompileStatic
public class WSBuiltInKeywords extends BuiltinKeywords {

    /**
     * Send a HTTP Request to web server
     * @param request the object represents for a HTTP Request, user need to define it from Object Repository->New->Web Service Request, and get it by ObjectRepository.findRequestObject("requestObjectId")
     * @param flowControl
     * @return
     * @throws Exception
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_REQUEST)
    public static ResponseObject sendRequest(RequestObject request, FailureHandling flowControl) throws Exception {
        return (ResponseObject) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "sendRequest", request, flowControl)
    }

    /**
     * Send a HTTP Request to web server
     * @param request the object represents for a HTTP Request, user need to define it from Object Repository->New->Web Service Request, and get it by ObjectRepository.findRequestObject("requestObjectId")
     * @return
     * @throws Exception
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_REQUEST)
    public static ResponseObject sendRequest(RequestObject request) throws Exception {
        return (ResponseObject) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "sendRequest", request)
    }

    /**
     * Send a HTTP Request to web server and verify the response
     * @param request the object represents for a HTTP Request, user need to define it from Object Repository->New->Web Service Request, and get it by ObjectRepository.findRequestObject("requestObjectId")
     * @param flowControl
     * @return
     * @throws Exception
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_REQUEST)
    public static ResponseObject sendRequestAndVerify(RequestObject request, FailureHandling flowControl) throws Exception {
        return (ResponseObject) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "sendRequestAndVerify", request, flowControl)
    }

    /**
     * Send a HTTP Request to web server and verify the response
     * @param request the object represents for a HTTP Request, user need to define it from Object Repository->New->Web Service Request, and get it by ObjectRepository.findRequestObject("requestObjectId")
     * @return
     * @throws Exception
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_REQUEST)
    public static ResponseObject sendRequestAndVerify(RequestObject request) throws Exception {
        return (ResponseObject) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "sendRequestAndVerify", request)
    }

    /**
     * Get the number of expected elements (JSON/XML) in the response (output) of a web service call
     * @param response the object represents for a HTTP Response, user can get responded content type, data, header properties (sometimes user may want to get cookie from response header)
     * @param locator an expression Katalon will use to go through and look for expected element(s), please refer to our user guide for how to write it
     * @param flowControl
     * @return the number of expected elements
     * @throws StepErrorException
     * @throws StepFailedException
     * 
     * @since 7.2.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_ELEMENT)
    public static int getElementsCount(ResponseObject response, String locator, FailureHandling flowControl) throws StepErrorException, StepFailedException {
        return (int) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "getElementsCount", response, locator, flowControl)
    }

    /**
     * Get the number of expected elements (JSON/XML) in the response (output) of a web service call
     * @param response the object represents for a HTTP Response, user can get responded content type, data, header properties (sometimes user may want to get cookie from response header)
     * @param locator an expression Katalon will use to go through and look for expected element(s), please refer to our user guide for how to write it
     * @return the number of expected elements
     * @throws StepErrorException
     * @throws StepFailedException
     * 
     * @since 7.2.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_ELEMENT)
    public static int getElementsCount(ResponseObject response, String locator) throws StepErrorException, StepFailedException {
        return (int) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "getElementsCount", response, locator)
    }

    /**
     * Verify number of expected elements (JSON/XML) in the response (output) of a web service call 
     * @param response the object represents for a HTTP Response, user can get responded content type, data, header properties (sometimes user may want to get cookie from response header)
     * @param locator an expression Katalon will use to go through and look for expected element(s), please refer to our user guide for how to write it   
     * @param count the expected number of element(s) should appear in the responded data (usually is JSON/XML)
     * @param flowControl
     * @return true if your expectation is met, otherwise false 
     * @throws Exception
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_ELEMENT)
    public static boolean verifyElementsCount(ResponseObject response, String locator, int count, FailureHandling flowControl) throws Exception {
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "verifyElementsCount", response, locator, count, flowControl)
    }

    /**
     * Verify number of expected elements (JSON/XML) in the response (output) of a web service call
     * @param response the object represents for a HTTP Response, user can get responded content type, data, header properties (sometimes user may want to get cookie from response header)
     * @param locator an expression Katalon will use to go through and look for expected element(s), please refer to our user guide for how to write it
     * @param count the expected number of element(s) should appear in the responded data (usually is JSON/XML)
     * @return true if your expectation is met, otherwise false
     * @throws Exception
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_ELEMENT)
    public static boolean verifyElementsCount(ResponseObject response, String locator, int count) throws Exception {
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "verifyElementsCount", response, locator, count)
    }

    /**
     * Get property value of an element (defined by a locator) in the returned data from a web service call
     * @param response the object represents for a HTTP Response, user can get responded content type, data, header properties (sometimes user may want to get cookie from response header)
     * @param locator an expression Katalon will use to go through and look for expected element(s), please refer to our user guide for how to write it
     * @param flowControl
     * @return  property value of the expected element
     * @throws StepErrorException
     * @throws StepFailedException
     * 
     * @since 7.2.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_ELEMENT)
    public static Object getElementPropertyValue(ResponseObject response, String locator, FailureHandling flowControl) throws StepErrorException, StepFailedException {
        return KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "getElementPropertyValue", response, locator, flowControl)
    }

    /**
     * Get property value of an element (defined by a locator) in the returned data from a web service call
     * @param response the object represents for a HTTP Response, user can get responded content type, data, header properties (sometimes user may want to get cookie from response header)
     * @param locator an expression Katalon will use to go through and look for expected element(s), please refer to our user guide for how to write it
     * @return property value of the expected element
     * @throws StepErrorException
     * @throws StepFailedException
     * 
     * @since 7.2.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_ELEMENT)
    public static Object getElementPropertyValue(ResponseObject response, String locator) throws StepErrorException, StepFailedException {
        return KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "getElementPropertyValue", response, locator)
    }

    /**
     * Verify that there is an element with expected property value appear in the returned data from a web service call
     * @param response the object represents for a HTTP Response, user can get responded content type, data, header properties (sometimes user may want to get cookie from response header)
     * @param locator an expression Katalon will use to go through and look for expected element(s), please refer to our user guide for how to write it
     * @param value the expected value of element you want to verify in the responded data (usually is JSON/XML)
     * @param flowControl
     * @return true if your expectation is met, otherwise false 
     * @throws StepErrorException
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_ELEMENT)
    public static boolean verifyElementPropertyValue(ResponseObject response, String locator, Object value, FailureHandling flowControl) throws StepErrorException {
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "verifyElementPropertyValue", response, locator, value, flowControl)
    }

    /**
     * Verify that there is an element with expected property value appear in the returned data from a web service call
     * @param response the object represents for a HTTP Response, user can get responded content type, data, header properties (sometimes user may want to get cookie from response header)
     * @param locator an expression Katalon will use to go through and look for expected element(s), please refer to our user guide for how to write it
     * @param value the expected value of element you want to verify in the responded data (usually is JSON/XML)
     * @return true if your expectation is met, otherwise false
     * @throws StepErrorException
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_ELEMENT)
    public static boolean verifyElementPropertyValue(ResponseObject response, String locator, Object value) throws StepErrorException {
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "verifyElementPropertyValue", response, locator, value)
    }

    /**
     * Get text of the element (defined by a locator) which appears in the returned data from a web service call
     * @param response the object represents for a HTTP Response, user can get responded content type, data, header properties (sometimes user may want to get cookie from response header)
     * @param locator an expression Katalon will use to go through and look for expected element(s), please refer to our user guide for how to write it
     * @param flowControl
     * @return text of the expected element
     * @throws StepErrorException
     * @throws StepFailedException
     * 
     * @since 7.2.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_ELEMENT)
    public static String getElementText(ResponseObject response, String locator, FailureHandling flowControl) throws StepErrorException, StepFailedException {
        return (String) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "getElementText", response, locator, flowControl)
    }

    /**
     * Get text of the element (defined by a locator) which appears in the returned data from a web service call
     * @param response the object represents for a HTTP Response, user can get responded content type, data, header properties (sometimes user may want to get cookie from response header)
     * @param locator an expression Katalon will use to go through and look for expected element(s), please refer to our user guide for how to write it
     * @return text of the expected element
     * @throws StepErrorException
     * @throws StepFailedException
     * 
     * @since 7.2.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_ELEMENT)
    public static String getElementText(ResponseObject response, String locator) throws StepErrorException, StepFailedException {
        return (String) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "getElementText", response, locator)
    }

    /**
     * Verify that there is an element with expected text appear in the returned data from a web service call
     * @param response the object represents for a HTTP Response, user can get responded content type, data, header properties (sometimes user may want to get cookie from response header)
     * @param locator an expression Katalon will use to go through and look for expected element(s), please refer to our user guide for how to write it
     * @param text the expected text of element you want to verify in the responded data (usually is JSON/XML)
     * @param flowControl
     * @return true if your element text is found, otherwise false
     * @throws StepFailedException
     * @throws StepErrorException
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_ELEMENT)
    public static boolean verifyElementText(ResponseObject response, String locator, String text, FailureHandling flowControl) throws StepFailedException, StepErrorException {
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "verifyElementText", response, locator, text, flowControl)
    }

    /**
     * Verify that there is an element with expected text appear in the returned data from a web service call
     * @param response the object represents for a HTTP Response, user can get responded content type, data, header properties (sometimes user may want to get cookie from response header)
     * @param locator an expression Katalon will use to go through and look for expected element(s), please refer to our user guide for how to write it
     * @param text the expected text of element you want to verify in the responded data (usually is JSON/XML)
     * @return true if your element text is found, otherwise false
     * @throws StepFailedException
     * @throws StepErrorException
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_ELEMENT)
    public static boolean verifyElementText(ResponseObject response, String locator, String text) throws StepFailedException, StepErrorException {
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "verifyElementText", response, locator, text)
    }

    /**
     * Verify that an expected text appear in the returned data from a web service call
     * @param response the object represents for a HTTP Response, user can get responded content type, data, header properties (sometimes user may want to get cookie from response header)
     * @param string the text you want to look for
     * @param useRegex use regular expression or not
     * @param flowControl
     * @return true if your text is found, otherwise false
     * @throws StepFailedException
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_TEXT)
    public static boolean containsString(ResponseObject response, String string, boolean useRegex, FailureHandling flowControl) throws StepFailedException {
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "containsString", response, string, useRegex, flowControl)
    }

    /**
     * Verify that an expected text appear in the returned data from a web service call
     * @param response the object represents for a HTTP Response, user can get responded content type, data, header properties (sometimes user may want to get cookie from response header)
     * @param string the text you want to look for
     * @param useRegex use regular expression or not
     * @return true if your text is found, otherwise false
     * @throws StepFailedException
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_TEXT)
    public static boolean containsString(ResponseObject response, String string, boolean useRegex) throws StepFailedException {
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "containsString", response, string, useRegex)
    }

    /**
     * Get status code in the returned data from a web service call
     *
     * @param responseObject the object represents for a HTTP Response, user can get responded content type, data, header properties (sometimes user may want to get cookie from response header)
     * @param flowControl
     * @return the response status code
     * @throws StepErrorException
     * @throws StepFailedException
     * 
     * @since 7.2.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_ELEMENT)
    public static int getResponseStatusCode(ResponseObject responseObject, FailureHandling flowControl) throws StepErrorException, StepFailedException {
        return (int) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "getResponseStatusCode", responseObject, flowControl)
    }

    /**
     * Get status code in the returned data from a web service call
     *
     * @param responseObject the object represents for a HTTP Response, user can get responded content type, data, header properties (sometimes user may want to get cookie from response header)
     * @return the response status code
     * @throws StepErrorException
     * @throws StepFailedException
     * 
     * @since 7.2.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_ELEMENT)
    public static int getResponseStatusCode(ResponseObject responseObject) throws StepErrorException, StepFailedException {
        return (int) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "getResponseStatusCode", responseObject)
    }

    /**
     * Verify status code in the returned data from a web service call
     * 
     * @param responseObject the object represents for a HTTP Response, user can get responded content type, data, header properties (sometimes user may want to get cookie from response header)
     * @param expectedStatusCode the expected status code
     * @param flowControl FailureHandling
     * @return true if the response status code is the same as the expected status code, otherwise false
     * @throws StepFailedException
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_ELEMENT)
    public static boolean verifyResponseStatusCode(ResponseObject responseObject, int expectedStatusCode, FailureHandling flowControl) throws StepFailedException {
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "verifyResponseStatusCode", responseObject, expectedStatusCode, flowControl)
    }

    /**
     * Verify status code in the returned data from a web service call
     *
     * @param responseObject the object represents for a HTTP Response, user can get responded content type, data, header properties (sometimes user may want to get cookie from response header)
     * @param expectedStatusCode the expected status code
     * @return true if the response status code is the same as the expected status code, otherwise false
     * @throws StepFailedException
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_ELEMENT)
    public static boolean verifyResponseStatusCode(ResponseObject responseObject, int expectedStatusCode) throws StepFailedException {
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "verifyResponseStatusCode", responseObject, expectedStatusCode)
    }

    /**
     * Verify status code valid in a range of status codes in the returned data from a web service call
     * 
     * @param responseObject the object represents for a HTTP Response, user can get responded content type, data, header properties (sometimes user may want to get cookie from response header)
     * @param fromStatusCode from status code
     * @param toStatusCode to status code
     * @param flowControl FailureHandling
     * @return true if the response status code is in a range of the expected status code, otherwise false
     * @throws StepFailedException
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_ELEMENT)
    public static boolean verifyResponseStatusCodeInRange(ResponseObject responseObject, int fromStatusCode, int toStatusCode, FailureHandling flowControl) throws StepFailedException {
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "verifyResponseStatusCodeInRange", responseObject, fromStatusCode, toStatusCode, flowControl)
    }

    /**
     * Verify status code valid in a range of status codes in the returned data from a web service call
     *
     * @param responseObject the object represents for a HTTP Response, user can get responded content type, data, header properties (sometimes user may want to get cookie from response header)
     * @param fromStatusCode from status code
     * @param toStatusCode to status code
     * @return true if the response status code is in a range of the expected status code, otherwise false
     * @throws StepFailedException
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_ELEMENT)
    public static boolean verifyResponseStatusCodeInRange(ResponseObject responseObject, int fromStatusCode, int toStatusCode) throws StepFailedException {
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "verifyResponseStatusCodeInRange", responseObject, fromStatusCode, toStatusCode)
    }

    /**
     *  Katalon Studio will generate HAR file for each Web Service request by default. This keyword will allow us can enable or disable HAR file generations on demand.
     *  
     *  @param enable true if enable HAR file generation. Otherwise, false.
     *  @throws StepFailedException If Katalon Studio could not save the setting
     *  
     *  @since 8.2.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_UTILITIES)
    public static void setHarFileGeneration(boolean enable) throws StepFailedException{
        KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "setHarFileGeneration", enable)
    }

    /**
     * Katalon Studio will generate HAR file for each Web Service request by default. This keyword will allow us can enable or disable HAR file generations on demand.
     * 
     * @param enable true if enable HAR file generation. Otherwise, false.
     * @param flowControl FailureHandling
     * @throws StepFailedException If Katalon Studio could not save the setting
     * 
     * @since 8.2.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_UTILITIES)
    public static void setHarFileGeneration(boolean enable, FailureHandling flowControl) throws StepFailedException{
        KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "setHarFileGeneration", enable, flowControl)
    }

    /**
     *Checks HAR file generation option is enabled or not.
     *
     * @return true if the response status code is in a range of the expected status code, otherwise false
     * @throws StepFailedException If Katalon Studio could not get the setting
     * 
     * @since 8.2.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_UTILITIES)
    public static boolean getHarFileGeneration() throws StepFailedException{
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "getHarFileGeneration")
    }

    /**
     *Checks HAR file generation option is enabled or not.
     *
     * @param flowControl FailureHandling
     * @return true if the response status code is in a range of the expected status code, otherwise false
     * @throws StepFailedException If Katalon Studio could not get the setting
     * 
     * @since 8.2.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_UTILITIES)
    public static boolean getHarFileGeneration(FailureHandling flowControl) throws StepFailedException{
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "getHarFileGeneration", flowControl)
    }

    /**
     * Validate a JSON object against a JSON schema
     *
     * @param jsonObject The JSON object to be validated, of type {@link String}
     * @param jsonSchema The JSON schema to validate against, which can be a JSON String, an URL, or a File path
     * @param flowControl Specify failure handling schema to determine whether the execution should be allowed to continue or stop, of type {@link FailureHandling}
     *
     * @return true if the JSON object passed the validation, false otherwise
     * @throws StepFailedException If could not find the schema file or the response didn't pass the validation
     *
     * @since 8.4.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_REQUEST)
    public static boolean validateJsonAgainstSchema(String jsonObject, String jsonSchema, FailureHandling flowControl) throws StepFailedException {
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "validateJsonAgainstSchema", jsonObject, jsonSchema, flowControl);
    }

    /**
     * Validate a JSON object against a JSON schema
     *
     * @param jsonObject The JSON object to be validated, of type {@link String}
     * @param jsonSchema The JSON schema to validate against, which can be a JSON String, an URL, or a File path
     *
     * @return true if the JSON object passed the validation, false otherwise
     * @throws StepFailedException If could not find the schema file or the response didn't pass the validation
     *
     * @since 8.4.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_REQUEST)
    public static boolean validateJsonAgainstSchema(String jsonObject, String jsonSchema) throws StepFailedException {
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "validateJsonAgainstSchema", jsonObject, jsonSchema);
    }

    /**
     * Validate a response against a JSON schema
     *
     * @param response The response object to be validated, of type {@link ResponseObject}
     * @param jsonSchema The JSON schema to validate against, which can be a JSON String, an URL, or a File path
     *
     * @return true if the response passed the validation, false otherwise
     * @throws StepFailedException If could not find the schema file or the response didn't pass the validation
     *
     * @since 8.4.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_REQUEST)
    public static boolean validateJsonAgainstSchema(ResponseObject response, String jsonSchema) throws StepFailedException {
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "validateJsonAgainstSchema", response, jsonSchema);
    }

    /**
     * Validate a response against a JSON schema
     *
     * @param response The response object to be validated, of type {@link ResponseObject}
     * @param jsonSchema The JSON schema to validate against, which can be a JSON String, an URL, or a File path
     * @param flowControl Specify failure handling schema to determine whether the execution should be allowed to continue or stop, of type {@link FailureHandling}
     * 
     * @return true if the response passed the validation, false otherwise
     * @throws StepFailedException If could not find the schema file or the response didn't pass the validation
     * 
     * @since 8.4.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_REQUEST)
    public static boolean validateJsonAgainstSchema(ResponseObject response, String jsonSchema, FailureHandling flowControl) throws StepFailedException {
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "validateJsonAgainstSchema", response, jsonSchema, flowControl);
    }

    /**
     * Validate an XML object against an XML schema
     *
     * @param xmlObject The XML object to be validated
     * @param xmlSchema The XML schema to validate against, which can be a JSON String, an URL, or a File path
     * @param flowControl Specify failure handling schema to determine whether the execution should be allowed to continue or stop, of type {@link FailureHandling}
     *
     * @return true if the XML object passed the validation, false otherwise
     * @throws StepFailedException If could not find the schema file or the response didn't pass the validation
     *
     * @since 8.4.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_REQUEST)
    public static boolean validateXmlAgainstSchema(String xmlObject, String xmlSchema, FailureHandling flowControl) throws StepFailedException {
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "validateXmlAgainstSchema", xmlObject, xmlSchema, flowControl);
    }

    /**
     * Validate an XML object against an XML schema
     *
     * @param xmlObject The XML object to be validated
     * @param xmlSchema The XML schema to validate against, which can be a JSON String, an URL, or a File path
     *
     * @return true if the XML object passed the validation, false otherwise
     * @throws StepFailedException If could not find the schema file or the response didn't pass the validation
     *
     * @since 8.4.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_REQUEST)
    public static boolean validateXmlAgainstSchema(String xmlObject, String xmlSchema) throws StepFailedException {
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "validateXmlAgainstSchema", xmlObject, xmlSchema);
    }

    /**
     * Validate a response against an XML schema
     *
     * @param response The response object to be validated, of type {@link ResponseObject}
     * @param xmlSchema The XML schema to validate against, which can be a JSON String, an URL, or a File path
     *
     * @return true if the response passed the validation, false otherwise
     * @throws StepFailedException If could not find the schema file or the response didn't pass the validation
     *
     * @since 8.4.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_REQUEST)
    public static boolean validateXmlAgainstSchema(ResponseObject response, String xmlSchema) throws StepFailedException {
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "validateXmlAgainstSchema", response, xmlSchema);
    }

    /**
     * Validate a response against an XML schema
     *
     * @param response The response object to be validated, of type {@link ResponseObject}
     * @param xmlSchema The XML schema to validate against, which can be a JSON String, an URL, or a File path
     * @param flowControl Specify failure handling schema to determine whether the execution should be allowed to continue or stop, of type {@link FailureHandling}
     *
     * @return true if the response passed the validation, false otherwise
     * @throws StepFailedException If could not find the schema file or the response didn't pass the validation
     *
     * @since 8.4.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_REQUEST)
    public static boolean validateXmlAgainstSchema(ResponseObject response, String xmlSchema, FailureHandling flowControl) throws StepFailedException {
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "validateXmlAgainstSchema", response, xmlSchema, flowControl);
    }

    /**
     * Validate a GraphQL request body against a GraphQL schema
     *
     * @param request The request object to be validated, of type {@link RequestObject}
     * @param graphqlSchema The GraphQL schema to validate against, which can be a JSON String, an URL, or a File path
     * @param flowControl Specify failure handling schema to determine whether the execution should be allowed to continue or stop, of type {@link FailureHandling}
     *
     * @return true if the request passed the validation, false otherwise
     * @throws StepFailedException If could not find the schema file, the request does not have a body content,
     *  or the request did not pass the validation
     *
     * @since 8.4.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_REQUEST)
    public static boolean validateGraphqlRequestAgainstSchema(RequestObject request, String graphqlSchema, FailureHandling flowControl) throws StepFailedException{
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "validateGraphqlRequestAgainstSchema", request, graphqlSchema, flowControl)
    }

    /**
     * Validate a GraphQL request body against a GraphQL schema
     *
     * @param request The request object to be validated, of type {@link RequestObject}
     * @param graphqlSchema The GraphQL schema to validate against, which can be a JSON String, an URL, or a File path
     *
     * @return true if the request passed the validation, false otherwise
     * @throws StepFailedException If could not find the schema file, the request does not have a body content,
     *  or the request did not pass the validation
     *
     * @since 8.4.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_REQUEST)
    public static boolean validateGraphqlRequestAgainstSchema(RequestObject request, String graphqlSchema) throws StepFailedException{
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "validateGraphqlRequestAgainstSchema", request, graphqlSchema)
    }

    /**
     * Validate an OpenAPI/Swagger request against an OpenAPI/Swagger specification
     * 
     * @param request Specify the request object that needs to be validated
     * @param specSrc Specify the OpenAPI/Swagger specification used to validate the OpenAPI/Swagger object
     *
     * @return true if the request passed the validation, false otherwise
     * @throws StepFailedException If could not find the schema file or the request did not pass the validation
     *  
     *  @since 9.7.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_REQUEST)
    public static boolean validateOpenAPIAgainstSpecification(RequestObject request, String specSrc) throws StepFailedException{
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "validateOpenAPIAgainstSpecification", ValidationTarget.REQUEST ,request, specSrc)
    }

    /**
     * Validate an OpenAPI/Swagger request against an OpenAPI/Swagger specification
     *
     * @param request Specify the request object that needs to be validated
     * @param specSrc Specify the OpenAPI/Swagger specification used to validate the OpenAPI/Swagger object
     * @param flowControl Specify failure handling schema to determine whether the execution should be allowed to continue or stop
     *
     * @return true if the request passed the validation, false otherwise
     * @throws StepFailedException If could not find the schema file or the request did not pass the validation
     *
     * @since 9.7.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_REQUEST)
    public static boolean validateOpenAPIAgainstSpecification(RequestObject request, String specSrc, FailureHandling flowControl) throws StepFailedException{
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "validateOpenAPIAgainstSpecification", ValidationTarget.REQUEST, request, specSrc, flowControl)
    }

    /**
     * Validate an OpenAPI/Swagger response against an OpenAPI/Swagger specification
     *
     * @param response Specify the response object that needs to be validated
     * @param request Specify the request for the response that needs to be validated
     * @param specSrc Specify the OpenAPI/Swagger specification used to validate the OpenAPI/Swagger object
     *
     * @return true if the response passed the validation, false otherwise
     * @throws StepFailedException If could not find the schema file or the response did not pass the validation
     *
     * @since 9.7.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_REQUEST)
    public static boolean validateOpenAPIAgainstSpecification(ResponseObject response, RequestObject request, String specSrc) throws StepFailedException{
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "validateOpenAPIAgainstSpecification", ValidationTarget.RESPONSE, response, request, specSrc)
    }

    /**
     * Validate an OpenAPI/Swagger response against an OpenAPI/Swagger specification
     *
     * @param response Specify the response object that needs to be validated
     * @param request Specify the request for the response that needs to be validated
     * @param specSrc Specify the OpenAPI/Swagger specification used to validate the OpenAPI/Swagger object
     * @param flowControl Specify failure handling schema to determine whether the execution should be allowed to continue or stop
     *
     * @return true if the response passed the validation, false otherwise
     * @throws StepFailedException If could not find the schema file or the response did not pass the validation
     *
     * @since 9.7.0
     */
    @CompileStatic
    @Keyword(keywordObject = StringConstants.KW_CATEGORIZE_REQUEST)
    public static boolean validateOpenAPIAgainstSpecification(ResponseObject response, RequestObject request, String specSrc, FailureHandling flowControl) throws StepFailedException{
        return (boolean) KeywordExecutor.executeKeywordForPlatform(KeywordExecutor.PLATFORM_WEB_SERVICE, "validateOpenAPIAgainstSpecification", ValidationTarget.RESPONSE, response, request, specSrc, flowControl)
    }
}
