package com.kms.katalon.core.webui.authentication.basic;

import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.remote.RemoteWebDriver;

import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.driver.bidi.BiDiDriverUtil;
import com.kms.katalon.core.webui.util.WebDriverUtil;

public class BasicAuthenticationStrategyFactory {
    private final String CHROME_BROWSER_NAME = "chrome";
    private final String FIREFOX_BROWSER_NAME = "firefox";
    private final String EDGE_BROWSER_NAME = "edge";

    public BasicAuthenticationStrategy getBasicAuthenticationStrategy() {
        String browserName = WebDriverUtil.getBrowserName(DriverFactory.getWebDriver());
        if (!StringUtils.isEmpty(browserName)) {
            if (StringUtils.containsIgnoreCase(browserName, FIREFOX_BROWSER_NAME)) {
                if (useBiDi()) {
                    return new BiDiBasicAuth();
                }
                
                return new EmbeddedCredentialsUrlBasicAuth();
            }
            
            if (
                StringUtils.containsIgnoreCase(browserName, CHROME_BROWSER_NAME) ||
                StringUtils.containsIgnoreCase(browserName, EDGE_BROWSER_NAME)
            ) {
                // Bypass basic auth using BiDi currently does not work on Chromium browser,
                // so use the Chrome Devtools Protocol instead.
                return new CdpBasicAuth();
            }
        }
        
        return new NoOpBasicAuth();
    }
    
    private boolean useBiDi() {
        if (DriverFactory.getWebDriver() instanceof RemoteWebDriver remoteDriver) {
            return BiDiDriverUtil.getBiDiCapability(remoteDriver.getCapabilities());
        }
        
        return false;
    }
}
