package com.kms.katalon.core.webui.common.controller;

import java.io.IOException;

import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.JavascriptExecutor;

public class WaitForEditablePhase extends ElementWaitingPhase {

    public WaitForEditablePhase(JavascriptExecutor webDriver) {
        super(webDriver);
    }

    @Override
    protected String getWaitingScript() {
        try {
            return super.getInteractableWaitUtilScript() + super.getWaitingScript() + """
                    function checkEditable(element) {
                            return !getReadonly(element);
                    }

                    waitWithDOMMutation(() => checkEditable(element), timeout).then((waited) => {
                        notifyWaitingResult({ result: waited
                            ? ElementWaitingInteractableState.DONE
                            : ElementWaitingInteractableState.TIMED_OUT });
                    }).catch(notifyWaitingError);
                    """;
        } catch (IOException e) {
            throw new JavascriptException("Failed to load interactable wait util script", e);
        }
    }
}
