package com.kms.katalon.core.webui.common.controller;

import org.openqa.selenium.JavascriptExecutor;

/**
 * This class should be called for the last because it will move until the element is able to interact.
 */
public class WaitForTopmostPhase extends ElementWaitingPhase {

    public WaitForTopmostPhase(JavascriptExecutor webDriver) {
        super(webDriver);
    }

    @Override
    protected String getWaitingScript() {
        return super.getWaitingScript() + """
                const positions = [
                    {
                        block: 'start',
                        inline: 'start'
                    },
                    {
                        block: 'center',
                        inline: 'center'
                    },
                    {
                        block: 'end',
                        inline: 'end'
                    },
                    {
                        block: 'start',
                        inline: 'center'
                    },
                    {
                        block: 'start',
                        inline: 'end'
                    },
                    {
                        block: 'center',
                        inline: 'start'
                    },
                    {
                        block: 'center',
                        inline: 'end'
                    },
                    {
                        block: 'end',
                        inline: 'start'
                    },
                    {
                        block: 'end',
                        inline: 'center'
                    }
                ];
                function isShadowRoot(element) {
                    return element.shadowRoot != null;
                }

                function checkTopMost(element) {
                    var { left, top, width, height } = element.getBoundingClientRect();
                    var centerX = width / 2 + left;
                    var centerY = height / 2 + top;
                    var scopedDocument = element.getRootNode();
                    var elementAtPoint = scopedDocument.elementFromPoint(centerX, centerY);
                    var isTopMost = element === elementAtPoint || element.contains(elementAtPoint);
                    return isTopMost;
                }

                function checkAllTopMostPositions(element) {
                    if (checkTopMost(element)) {
                        return true;
                    }
                    return positions.some(position => {
                        element.scrollIntoView({
                            behavior: 'instant',
                            block: position.block,
                            inline: position.inline
                        });
                        return checkTopMost(element);
                    });
                }

                waitWithDOMMutation(() => checkAllTopMostPositions(element), timeout).then((waited) => {
                    notifyWaitingResult({ result: waited
                        ? ElementWaitingInteractableState.DONE
                        : ElementWaitingInteractableState.TIMED_OUT });
                }).catch(notifyWaitingError);
                """;
    }
}
