package com.kms.katalon.core.webui.common.controller;

import org.openqa.selenium.JavascriptExecutor;

public class WaitForVisiblePhase extends ElementWaitingPhase {

    public WaitForVisiblePhase(JavascriptExecutor webDriver) {
        super(webDriver);
    }

    @Override
    protected String getWaitingScript() {
        return super.getWaitingScript() + """
                function checkZeroSize(element) {
                    const elementRect = element?.getBoundingClientRect();
                    return elementRect?.width === 0 || elementRect?.height === 0;
                }
                
                function checkVisibility(element) {
                    if (checkZeroSize(element)) {
                        return false;
                    }
                    if (element.checkVisibility) {
                        return element.checkVisibility({
                            visibilityProperty: true,
                            checkVisibilityCSS: true
                        });
                    }
                    return element.style.display !== 'none' && element.style.visibility !== 'hidden';
                }

                waitWithDOMMutation(() => checkVisibility(element), timeout).then((waited) => {
                    notifyWaitingResult({ result: waited
                        ? ElementWaitingInteractableState.DONE
                        : ElementWaitingInteractableState.TIMED_OUT });
                }).catch(notifyWaitingError);
                """;
    }
}
